/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcIndexer;

public class BcTableModel
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = -3537418851979192646L;
    protected BcTableColumnModel tableColumnModel;
    protected List<List> rowList;
    protected BcIndexer indexer;

    public BcTableModel() {
        this.init(null);
    }

    public BcTableModel(BcTableColumnModel tableColumnModel) {
        this.init(tableColumnModel);
    }

    private final void init(BcTableColumnModel tableColumnModel) {
        this.tableColumnModel = tableColumnModel;
        if (this.tableColumnModel == null) {
            this.tableColumnModel = new BcTableColumnModel();
        }
        this.rowList = new ArrayList<List>();
    }

    @Override
    public int getColumnCount() {
        return this.tableColumnModel.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int columnId) {
        BcTableColumn lbTableColumn;
        MmdField mmdField;
        TableColumn tableColumn = this.tableColumnModel.getColumn(columnId);
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass()) && (mmdField = (lbTableColumn = (BcTableColumn)tableColumn).getMmdField()) != null) {
            return mmdField.dataClass;
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(BcTableColumn tableColumn) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            this.tableColumnModel.addColumn(tableColumn);
            int i = 0;
            while (i < this.rowList.size()) {
                List row = this.getRow(i);
                if (row.size() < this.tableColumnModel.getColumnCount()) {
                    BcCollectionUtil.fill(row, this.tableColumnModel.getColumnCount());
                }
                ++i;
            }
            this.fireTableStructureChanged();
        }
    }

    public BcTableColumn getColumn(int columnId) {
        return (BcTableColumn)this.tableColumnModel.getColumn(columnId);
    }

    @Override
    public String getColumnName(int columnId) {
        BcTableColumn tableColumn = (BcTableColumn)this.tableColumnModel.getColumn(columnId);
        if (tableColumn == null) {
            return null;
        }
        MmdField mmdField = tableColumn.getMmdField();
        if (mmdField != null) {
            return mmdField.fieldName;
        }
        Object headerValue = tableColumn.getHeaderValue();
        if (headerValue != null) {
            return headerValue.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BcTableColumn removeColumn(int columnIndex) {
        BcTableColumn tableColumn = null;
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            tableColumn = (BcTableColumn)this.tableColumnModel.getColumn(columnIndex);
            int columnId = this.tableColumnModel.toModelIndex(columnIndex);
            this.tableColumnModel.removeColumn(tableColumn);
            int i = 0;
            while (i < this.rowList.size()) {
                List row = this.rowList.get(i);
                row.remove(columnId);
                ++i;
            }
        }
        this.fireTableStructureChanged();
        return tableColumn;
    }

    public BcTableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    @Override
    public int getRowCount() {
        return this.rowList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int rowId = this.toRowId(rowIndex);
        return this.getValueAtModel(rowId, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            int rowId = this.toRowId(rowIndex);
            Object oldValue = this.setValueAtModel(newValue, rowId, columnIndex);
            this.isValueChanged(oldValue, newValue);
            if (this.isValueChanged(oldValue, newValue)) {
                this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toRowId(int rowIndex) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            if (this.indexer != null) {
                return this.indexer.toModelId(rowIndex);
            }
            return rowIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAtModel(int rowId, int columnId) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            List row = this.getRow(rowId);
            return row.get(columnId);
        }
    }

    public List getRow(int rowId) {
        return this.rowList.get(rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setValueAtModel(Object newValue, int rowId, int columnId) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            List row = this.getRow(rowId);
            Object oldValue = row.get(columnId);
            row.set(columnId, newValue);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(List row) {
        int rowId = -1;
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            rowId = this.addRow2(row);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addRow2(List row) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            this.rowList.add(row);
            if (this.indexer == null) {
                return this.rowList.size() - 1;
            }
            this.indexer.addIndex(1);
            return this.indexer.toIndex(this.rowList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRowList(List<List> rowList2) {
        int rowId = -1;
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            int idx1 = this.getRowCount() - 1;
            int i = 0;
            while (i < rowList2.size()) {
                List row = rowList2.get(i);
                rowId = this.addRow2(row);
                ++i;
            }
            this.fireTableRowsInserted(idx1, this.getRowCount() - 1);
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List removeRow(int rowIndex) throws Exception {
        List row = null;
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            row = this.rowList.remove(this.toRowId(rowIndex));
            if (this.indexer != null) {
                this.indexer.removeIndex(rowIndex, rowIndex);
            }
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] removeRows(int ... rowIndexes) throws Exception {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            int[] rowIndexe2 = BcCollectionUtil.toUniqueArray(rowIndexes);
            List[] rows = new List[rowIndexe2.length];
            rowIndexe2 = Arrays.copyOf(rowIndexe2, rowIndexe2.length);
            Arrays.sort(rowIndexe2);
            int i = 0;
            while (i < rowIndexe2.length) {
                rows[i] = this.removeRow(rowIndexe2[rowIndexe2.length - i - 1]);
                ++i;
            }
            return rows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.getRowCount() <= 0) {
            return;
        }
        int row1 = 0;
        int row2 = this.getRowCount() - 1;
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            this.rowList.clear();
            if (this.indexer != null) {
                this.indexer.clear();
            }
        }
        this.fireTableRowsDeleted(row1, row2);
    }

    public List<List> getRowList() {
        return this.rowList;
    }

    public BcIndexer getIndexer() {
        if (this.indexer == null) {
            this.indexer = new BcIndexer(this.getRowCount());
        }
        return this.indexer;
    }

    public void setIndexer(BcIndexer indexer) {
        this.indexer = indexer;
    }

    protected boolean isValueChanged(Object value1, Object value2) {
        boolean changed = false;
        if (value1 == null) {
            if (value2 != null) {
                changed = true;
            }
        } else if (value2 == null) {
            changed = true;
        } else if (value1.hashCode() != value2.hashCode()) {
            changed = true;
        }
        return changed;
    }
}

