/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.table;

import java.io.Serializable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCloneUtil;

public class BcTableColumn
extends TableColumn
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5648362508560713562L;
    private MmdField mmdField;
    public boolean isEditable;
    public boolean ascending;
    public double defaultWidth;
    boolean visible;

    public BcTableColumn() {
        this.clear();
    }

    public BcTableColumn(int modelIndex) {
        super(modelIndex);
        this.clear();
    }

    public void clear() {
        this.mmdField = null;
        this.ascending = true;
        this.isEditable = true;
        this.visible = true;
    }

    public MmdField getMmdField() {
        return this.mmdField;
    }

    public void setMmdField(MmdField mmdField) {
        this.mmdField = mmdField;
    }

    @Override
    public Object getHeaderValue() {
        if (super.getHeaderValue() != null) {
            return super.getHeaderValue();
        }
        if (this.mmdField != null) {
            try {
                return MmdUtil.getProvisionalHeaderValue(this.mmdField);
            }
            catch (Exception ex) {
                return ex;
            }
        }
        return null;
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        return super.getHeaderRenderer();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        if (this.visible != newVisible) {
            BcTableUtil.setColumnVisible(this, newVisible);
        }
        this.visible = newVisible;
    }

    public Object clone() throws CloneNotSupportedException {
        BcTableColumn obj = new BcTableColumn();
        if (this.mmdField != null) {
            obj.setMmdField(BcCloneUtil.createClone(this.mmdField));
        }
        obj.isEditable = this.isEditable;
        obj.ascending = this.ascending;
        obj.setModelIndex(this.getModelIndex());
        obj.setHeaderValue(this.getHeaderValue());
        obj.setMinWidth(this.getMinWidth());
        obj.setMaxWidth(this.getMaxWidth());
        obj.setPreferredWidth(this.getPreferredWidth());
        return obj;
    }
}

