/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.util.xml.impl.Attrs;
import jdk.internal.util.xml.impl.Input;
import jdk.internal.util.xml.impl.Pair;
import jdk.internal.util.xml.impl.ReaderUTF16;
import jdk.internal.util.xml.impl.ReaderUTF8;

public abstract class Parser {
    public static final String FAULT = "";
    protected static final int BUFFSIZE_READER = 512;
    protected static final int BUFFSIZE_PARSER = 128;
    private static final int MAX_ARRAY_SIZE = 0x4000000;
    public static final char EOS = '\uffff';
    private Pair mNoNS;
    private Pair mXml;
    private Map<String, Input> mEnt;
    private Map<String, Input> mPEnt;
    protected boolean mIsSAlone;
    protected boolean mIsSAloneSet;
    protected boolean mIsNSAware;
    protected int mPh = -1;
    protected static final int PH_BEFORE_DOC = -1;
    protected static final int PH_DOC_START = 0;
    protected static final int PH_MISC_DTD = 1;
    protected static final int PH_DTD = 2;
    protected static final int PH_DTD_MISC = 3;
    protected static final int PH_DOCELM = 4;
    protected static final int PH_DOCELM_MISC = 5;
    protected static final int PH_AFTER_DOC = 6;
    protected int mEvt;
    protected static final int EV_NULL = 0;
    protected static final int EV_ELM = 1;
    protected static final int EV_ELMS = 2;
    protected static final int EV_ELME = 3;
    protected static final int EV_TEXT = 4;
    protected static final int EV_WSPC = 5;
    protected static final int EV_PI = 6;
    protected static final int EV_CDAT = 7;
    protected static final int EV_COMM = 8;
    protected static final int EV_DTD = 9;
    protected static final int EV_ENT = 10;
    private char mESt;
    protected char[] mBuff = new char[128];
    protected int mBuffIdx;
    protected Pair mPref;
    protected Pair mElm;
    protected Pair mAttL;
    protected Input mDoc;
    protected Input mInp;
    private char[] mChars;
    private int mChLen;
    private int mChIdx;
    protected Attrs mAttrs = new Attrs();
    private String[] mItems;
    private char mAttrIdx;
    private String mUnent;
    private Pair mDltd;
    private static final char[] NONS;
    private static final char[] XML;
    private static final char[] XMLNS;
    private static final byte[] asctyp;
    private static final byte[] nmttyp;

    protected Parser() {
        this.mPref = this.pair(this.mPref);
        this.mPref.name = FAULT;
        this.mPref.value = FAULT;
        this.mPref.chars = NONS;
        this.mNoNS = this.mPref;
        this.mPref = this.pair(this.mPref);
        this.mPref.name = "xml";
        this.mPref.value = "http://www.w3.org/XML/1998/namespace";
        this.mPref.chars = XML;
        this.mXml = this.mPref;
    }

    protected void init() {
        this.mUnent = null;
        this.mElm = null;
        this.mPref = this.mXml;
        this.mAttL = null;
        this.mPEnt = new HashMap<String, Input>();
        this.mEnt = new HashMap<String, Input>();
        this.mDoc = this.mInp;
        this.mChars = this.mInp.chars;
        this.mPh = 0;
    }

    protected void cleanup() {
        while (this.mAttL != null) {
            while (this.mAttL.list != null) {
                if (this.mAttL.list.list != null) {
                    this.del(this.mAttL.list.list);
                }
                this.mAttL.list = this.del(this.mAttL.list);
            }
            this.mAttL = this.del(this.mAttL);
        }
        while (this.mElm != null) {
            this.mElm = this.del(this.mElm);
        }
        while (this.mPref != this.mXml) {
            this.mPref = this.del(this.mPref);
        }
        while (this.mInp != null) {
            this.pop();
        }
        if (this.mDoc != null && this.mDoc.src != null) {
            try {
                this.mDoc.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mPEnt = null;
        this.mEnt = null;
        this.mDoc = null;
        this.mPh = 6;
    }

    protected int step() throws Exception {
        this.mEvt = 0;
        int n = 0;
        block29: while (this.mEvt == 0) {
            char c = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            block0 : switch (n) {
                case 0: {
                    if (c != '<') {
                        this.bkch();
                        this.mBuffIdx = -1;
                        n = 1;
                        break;
                    }
                    switch (this.getch()) {
                        case '/': {
                            this.mEvt = 3;
                            if (this.mElm == null) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = -1;
                            this.bname(this.mIsNSAware);
                            char[] cArray = this.mElm.chars;
                            if (cArray.length == this.mBuffIdx + 1) {
                                for (int n2 = 1; n2 <= this.mBuffIdx; n2 = (int)((char)(n2 + 1))) {
                                    if (cArray[n2] == this.mBuff[n2]) continue;
                                    this.panic(FAULT);
                                }
                            } else {
                                this.panic(FAULT);
                            }
                            if (this.wsskip() != '>') {
                                this.panic(FAULT);
                            }
                            this.getch();
                            break block0;
                        }
                        case '!': {
                            c = this.getch();
                            this.bkch();
                            switch (c) {
                                case '-': {
                                    this.mEvt = 8;
                                    this.comm();
                                    break block0;
                                }
                                case '[': {
                                    this.mEvt = 7;
                                    this.cdat();
                                    break block0;
                                }
                            }
                            this.mEvt = 9;
                            this.dtd();
                            break block0;
                        }
                        case '?': {
                            this.mEvt = 6;
                            this.pi();
                            break block0;
                        }
                    }
                    this.bkch();
                    this.mElm = this.pair(this.mElm);
                    this.mElm.chars = this.qname(this.mIsNSAware);
                    this.mElm.name = this.mElm.local();
                    this.mElm.id = this.mElm.next != null ? this.mElm.next.id : 0;
                    this.mElm.num = 0;
                    Pair pair = this.find(this.mAttL, this.mElm.chars);
                    this.mElm.list = pair != null ? pair.list : null;
                    this.mAttrIdx = '\u0000';
                    Pair pair2 = this.pair(null);
                    pair2.num = 0;
                    this.attr(pair2);
                    this.del(pair2);
                    this.mElm.value = this.mIsNSAware ? this.rslv(this.mElm.chars) : null;
                    switch (this.wsskip()) {
                        case '>': {
                            this.getch();
                            this.mEvt = 2;
                            break block0;
                        }
                        case '/': {
                            this.getch();
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            this.mEvt = 1;
                            break block0;
                        }
                    }
                    this.panic(FAULT);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            this.bappend(c);
                            break block0;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block0;
                        }
                        case '<': {
                            this.mEvt = 5;
                            this.bkch();
                            this.bflash_ws();
                            break block0;
                        }
                    }
                    this.bkch();
                    n = 2;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '&': {
                            if (this.mUnent == null) {
                                this.mUnent = this.ent('x');
                                if (this.mUnent == null) continue block29;
                                this.mEvt = 4;
                                this.bkch();
                                this.setch('&');
                                this.bflash();
                                break block0;
                            }
                            this.mEvt = 10;
                            this.skippedEnt(this.mUnent);
                            this.mUnent = null;
                            break block0;
                        }
                        case '<': {
                            this.mEvt = 4;
                            this.bkch();
                            this.bflash();
                            break block0;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block0;
                        }
                        case '\uffff': {
                            this.panic(FAULT);
                        }
                    }
                    this.bappend(c);
                    break;
                }
                default: {
                    this.panic(FAULT);
                }
            }
        }
        return this.mEvt;
    }

    private void dtd() throws Exception {
        Object var2_1 = null;
        String string = null;
        Pair pair = null;
        if (!"DOCTYPE".equals(this.name(false))) {
            this.panic(FAULT);
        }
        this.mPh = 2;
        int n = 0;
        block24: while (n >= 0) {
            char c = this.getch();
            if (c == '\uffff') {
                this.panic(FAULT);
            }
            switch (n) {
                case 0: {
                    if (this.chtyp(c) == ' ') continue block24;
                    this.bkch();
                    string = this.name(this.mIsNSAware);
                    this.wsskip();
                    n = 1;
                    continue block24;
                }
                case 1: {
                    switch (this.chtyp(c)) {
                        case 'A': {
                            this.bkch();
                            pair = this.pubsys(' ');
                            n = 2;
                            this.docType(string, pair.name, pair.value);
                            continue block24;
                        }
                        case '[': {
                            this.bkch();
                            n = 2;
                            this.docType(string, null, null);
                            continue block24;
                        }
                        case '>': {
                            this.bkch();
                            n = 3;
                            this.docType(string, null, null);
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
                case 2: {
                    switch (this.chtyp(c)) {
                        case '[': {
                            this.dtdsub();
                            n = 3;
                            continue block24;
                        }
                        case '>': {
                            this.bkch();
                            n = 3;
                            continue block24;
                        }
                        case ' ': {
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
                case 3: {
                    switch (this.chtyp(c)) {
                        case '>': {
                            if (pair != null) {
                                InputSource inputSource = this.resolveEnt(string, pair.name, pair.value);
                                if (inputSource != null) {
                                    if (!this.mIsSAlone) {
                                        this.bkch();
                                        this.setch(']');
                                        this.push(new Input(512));
                                        this.setinp(inputSource);
                                        this.mInp.pubid = pair.name;
                                        this.mInp.sysid = pair.value;
                                        this.dtdsub();
                                    } else {
                                        this.skippedEnt("[dtd]");
                                        if (inputSource.getCharacterStream() != null) {
                                            try {
                                                inputSource.getCharacterStream().close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                        if (inputSource.getByteStream() != null) {
                                            try {
                                                inputSource.getByteStream().close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                } else {
                                    this.skippedEnt("[dtd]");
                                }
                                this.del(pair);
                            }
                            n = -1;
                            continue block24;
                        }
                        case ' ': {
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdsub() throws Exception {
        int n = 0;
        block25: while (n >= 0) {
            char c = this.getch();
            switch (n) {
                case 0: {
                    switch (this.chtyp(c)) {
                        case '<': {
                            c = this.getch();
                            switch (c) {
                                case '?': {
                                    this.pi();
                                    continue block25;
                                }
                                case '!': {
                                    c = this.getch();
                                    this.bkch();
                                    if (c == '-') {
                                        this.comm();
                                        continue block25;
                                    }
                                    this.bntok();
                                    switch (this.bkeyword()) {
                                        case 'n': {
                                            this.dtdent();
                                            break;
                                        }
                                        case 'a': {
                                            this.dtdattl();
                                            break;
                                        }
                                        case 'e': {
                                            this.dtdelm();
                                            break;
                                        }
                                        case 'o': {
                                            this.dtdnot();
                                            break;
                                        }
                                        default: {
                                            this.panic(FAULT);
                                        }
                                    }
                                    n = 1;
                                    continue block25;
                                }
                            }
                            this.panic(FAULT);
                            continue block25;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block25;
                        }
                        case ']': {
                            n = -1;
                            continue block25;
                        }
                        case ' ': {
                            continue block25;
                        }
                        case 'Z': {
                            if (this.getch() != ']') {
                                this.panic(FAULT);
                            }
                            n = -1;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 1: {
                    switch (c) {
                        case '>': {
                            n = 0;
                            continue block25;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdent() throws Exception {
        String string = null;
        char[] cArray = null;
        Input input = null;
        Pair pair = null;
        int n = 0;
        block21: while (n >= 0) {
            char c = this.getch();
            switch (n) {
                case 0: {
                    switch (this.chtyp(c)) {
                        case ' ': {
                            continue block21;
                        }
                        case '%': {
                            c = this.getch();
                            this.bkch();
                            if (this.chtyp(c) == ' ') {
                                this.wsskip();
                                string = this.name(false);
                                switch (this.chtyp(this.wsskip())) {
                                    case 'A': {
                                        pair = this.pubsys(' ');
                                        if (this.wsskip() == '>') {
                                            if (!this.mPEnt.containsKey(string)) {
                                                input = new Input();
                                                input.pubid = pair.name;
                                                input.sysid = pair.value;
                                                this.mPEnt.put(string, input);
                                            }
                                        } else {
                                            this.panic(FAULT);
                                        }
                                        this.del(pair);
                                        n = -1;
                                        continue block21;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        this.bqstr('d');
                                        cArray = new char[this.mBuffIdx + 1];
                                        System.arraycopy(this.mBuff, 1, cArray, 1, cArray.length - 1);
                                        cArray[0] = 32;
                                        if (!this.mPEnt.containsKey(string)) {
                                            input = new Input(cArray);
                                            input.pubid = this.mInp.pubid;
                                            input.sysid = this.mInp.sysid;
                                            input.xmlenc = this.mInp.xmlenc;
                                            input.xmlver = this.mInp.xmlver;
                                            this.mPEnt.put(string, input);
                                        }
                                        n = -1;
                                        continue block21;
                                    }
                                }
                                this.panic(FAULT);
                                continue block21;
                            }
                            this.pent(' ');
                            continue block21;
                        }
                    }
                    this.bkch();
                    string = this.name(false);
                    n = 1;
                    continue block21;
                }
                case 1: {
                    switch (this.chtyp(c)) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            if (this.mEnt.get(string) == null) {
                                cArray = new char[this.mBuffIdx];
                                System.arraycopy(this.mBuff, 1, cArray, 0, cArray.length);
                                if (!this.mEnt.containsKey(string)) {
                                    input = new Input(cArray);
                                    input.pubid = this.mInp.pubid;
                                    input.sysid = this.mInp.sysid;
                                    input.xmlenc = this.mInp.xmlenc;
                                    input.xmlver = this.mInp.xmlver;
                                    this.mEnt.put(string, input);
                                }
                            }
                            n = -1;
                            continue block21;
                        }
                        case 'A': {
                            this.bkch();
                            pair = this.pubsys(' ');
                            switch (this.wsskip()) {
                                case '>': {
                                    if (this.mEnt.containsKey(string)) break;
                                    input = new Input();
                                    input.pubid = pair.name;
                                    input.sysid = pair.value;
                                    this.mEnt.put(string, input);
                                    break;
                                }
                                case 'N': {
                                    if ("NDATA".equals(this.name(false))) {
                                        this.wsskip();
                                        this.unparsedEntDecl(string, pair.name, pair.value, this.name(false));
                                        break;
                                    }
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.del(pair);
                            n = -1;
                            continue block21;
                        }
                        case ' ': {
                            continue block21;
                        }
                    }
                    this.panic(FAULT);
                    continue block21;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdelm() throws Exception {
        this.wsskip();
        this.name(this.mIsNSAware);
        while (true) {
            char c = this.getch();
            switch (c) {
                case '>': {
                    this.bkch();
                    return;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
            }
        }
    }

    private void dtdattl() throws Exception {
        char[] cArray = null;
        Pair pair = null;
        int n = 0;
        block14: while (n >= 0) {
            char c = this.getch();
            switch (n) {
                case 0: {
                    switch (this.chtyp(c)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            cArray = this.qname(this.mIsNSAware);
                            pair = this.find(this.mAttL, cArray);
                            if (pair == null) {
                                pair = this.pair(this.mAttL);
                                pair.chars = cArray;
                                this.mAttL = pair;
                            }
                            n = 1;
                            continue block14;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
                case 1: {
                    switch (this.chtyp(c)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            this.dtdatt(pair);
                            if (this.wsskip() != '>') continue block14;
                            return;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdatt(Pair pair) throws Exception {
        char[] cArray = null;
        Pair pair2 = null;
        int n = 0;
        block57: while (n >= 0) {
            char c = this.getch();
            switch (n) {
                case 0: {
                    switch (this.chtyp(c)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            cArray = this.qname(this.mIsNSAware);
                            pair2 = this.find(pair.list, cArray);
                            if (pair2 == null) {
                                pair2 = this.pair(pair.list);
                                pair2.chars = cArray;
                                pair.list = pair2;
                            } else {
                                pair2 = this.pair(null);
                                pair2.chars = cArray;
                                pair2.id = 99;
                            }
                            this.wsskip();
                            n = 1;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 1: {
                    switch (this.chtyp(c)) {
                        case '(': {
                            pair2.id = 117;
                            n = 2;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.bkch();
                    this.bntok();
                    pair2.id = this.bkeyword();
                    switch (pair2.id) {
                        case 111: {
                            if (this.wsskip() != '(') {
                                this.panic(FAULT);
                            }
                            c = this.getch();
                            n = 2;
                            continue block57;
                        }
                        case 78: 
                        case 82: 
                        case 84: 
                        case 99: 
                        case 105: 
                        case 110: 
                        case 114: 
                        case 116: {
                            this.wsskip();
                            n = 4;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 2: {
                    switch (this.chtyp(c)) {
                        case '-': 
                        case '.': 
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': 
                        case 'd': {
                            this.bkch();
                            switch (pair2.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            n = 3;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 3: {
                    switch (c) {
                        case ')': {
                            this.wsskip();
                            n = 4;
                            continue block57;
                        }
                        case '|': {
                            this.wsskip();
                            switch (pair2.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 4: {
                    switch (c) {
                        case '#': {
                            this.bntok();
                            switch (this.bkeyword()) {
                                case 'F': {
                                    switch (this.wsskip()) {
                                        case '\"': 
                                        case '\'': {
                                            n = 5;
                                            continue block57;
                                        }
                                        case '\uffff': {
                                            this.panic(FAULT);
                                        }
                                    }
                                    n = -1;
                                    continue block57;
                                }
                                case 'I': 
                                case 'Q': {
                                    n = -1;
                                    continue block57;
                                }
                            }
                            this.panic(FAULT);
                            continue block57;
                        }
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            n = 5;
                            continue block57;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.bkch();
                    n = -1;
                    continue block57;
                }
                case 5: {
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            pair2.list = this.pair(null);
                            pair2.list.chars = new char[pair2.chars.length + this.mBuffIdx + 3];
                            System.arraycopy(pair2.chars, 1, pair2.list.chars, 0, pair2.chars.length - 1);
                            pair2.list.chars[pair2.chars.length - 1] = 61;
                            pair2.list.chars[pair2.chars.length] = c;
                            System.arraycopy(this.mBuff, 1, pair2.list.chars, pair2.chars.length + 1, this.mBuffIdx);
                            pair2.list.chars[pair2.chars.length + this.mBuffIdx + 1] = c;
                            pair2.list.chars[pair2.chars.length + this.mBuffIdx + 2] = 32;
                            n = -1;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdnot() throws Exception {
        this.wsskip();
        String string = this.name(false);
        this.wsskip();
        Pair pair = this.pubsys('N');
        this.notDecl(string, pair.name, pair.value);
        this.del(pair);
    }

    private void attr(Pair pair) throws Exception {
        switch (this.wsskip()) {
            case '/': 
            case '>': {
                if ((pair.num & 2) == 0) {
                    pair.num |= 2;
                    Input input = this.mInp;
                    Pair pair2 = this.mElm.list;
                    while (pair2 != null) {
                        Pair pair3;
                        if (pair2.list != null && (pair3 = this.find(pair.next, pair2.chars)) == null) {
                            this.push(new Input(pair2.list.chars));
                        }
                        pair2 = pair2.next;
                    }
                    if (this.mInp != input) {
                        this.attr(pair);
                        return;
                    }
                }
                this.mAttrs.setLength(this.mAttrIdx);
                this.mItems = this.mAttrs.mItems;
                return;
            }
            case '\uffff': {
                this.panic(FAULT);
            }
        }
        pair.chars = this.qname(this.mIsNSAware);
        pair.name = pair.local();
        String string = this.atype(pair);
        this.wsskip();
        if (this.getch() != '=') {
            this.panic(FAULT);
        }
        this.bqstr((char)pair.id);
        String string2 = new String(this.mBuff, 1, this.mBuffIdx);
        Pair pair4 = this.pair(pair);
        pair4.num = pair.num & 0xFFFFFFFE;
        if (!this.mIsNSAware || !this.isdecl(pair, string2)) {
            this.mAttrIdx = (char)(this.mAttrIdx + '\u0001');
            this.attr(pair4);
            this.mAttrIdx = (char)(this.mAttrIdx - '\u0001');
            char c = (char)(this.mAttrIdx << 3);
            this.mItems[c + '\u0001'] = pair.qname();
            this.mItems[c + 2] = this.mIsNSAware ? pair.name : FAULT;
            this.mItems[c + 3] = string2;
            this.mItems[c + 4] = string;
            switch (pair.num & 3) {
                case 0: {
                    this.mItems[c + 5] = null;
                    break;
                }
                case 1: {
                    this.mItems[c + 5] = "d";
                    break;
                }
                default: {
                    this.mItems[c + 5] = "D";
                }
            }
            this.mItems[c + '\u0000'] = pair.chars[0] != '\u0000' ? this.rslv(pair.chars) : FAULT;
        } else {
            this.newPrefix();
            this.attr(pair4);
        }
        this.del(pair4);
    }

    private String atype(Pair pair) throws Exception {
        Pair pair2;
        pair.id = 99;
        if (this.mElm.list == null || (pair2 = this.find(this.mElm.list, pair.chars)) == null) {
            return "CDATA";
        }
        pair.num |= 1;
        pair.id = 105;
        switch (pair2.id) {
            case 105: {
                return "ID";
            }
            case 114: {
                return "IDREF";
            }
            case 82: {
                return "IDREFS";
            }
            case 110: {
                return "ENTITY";
            }
            case 78: {
                return "ENTITIES";
            }
            case 116: {
                return "NMTOKEN";
            }
            case 84: {
                return "NMTOKENS";
            }
            case 117: {
                return "NMTOKEN";
            }
            case 111: {
                return "NOTATION";
            }
            case 99: {
                pair.id = 99;
                return "CDATA";
            }
        }
        this.panic(FAULT);
        return null;
    }

    private void comm() throws Exception {
        if (this.mPh == 0) {
            this.mPh = 1;
        }
        this.mBuffIdx = -1;
        int n = 0;
        block13: while (n >= 0) {
            char c;
            char c2 = c = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            if (c == '\uffff') {
                this.panic(FAULT);
            }
            switch (n) {
                case 0: {
                    if (c == '-') {
                        n = 1;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 1: {
                    if (c == '-') {
                        n = 2;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 2: {
                    switch (c) {
                        case '-': {
                            n = 3;
                            continue block13;
                        }
                    }
                    this.bappend(c);
                    continue block13;
                }
                case 3: {
                    switch (c) {
                        case '-': {
                            n = 4;
                            continue block13;
                        }
                    }
                    this.bappend('-');
                    this.bappend(c);
                    n = 2;
                    continue block13;
                }
                case 4: {
                    if (c != '>') break;
                    this.comm(this.mBuff, this.mBuffIdx + 1);
                    n = -1;
                    continue block13;
                }
            }
            this.panic(FAULT);
        }
    }

    private void pi() throws Exception {
        String string = null;
        this.mBuffIdx = -1;
        int n = 0;
        block15: while (n >= 0) {
            char c = this.getch();
            if (c == '\uffff') {
                this.panic(FAULT);
            }
            switch (n) {
                case 0: {
                    switch (this.chtyp(c)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            string = this.name(false);
                            if (string.isEmpty() || this.mXml.name.equals(string.toLowerCase())) {
                                this.panic(FAULT);
                            }
                            if (this.mPh == 0) {
                                this.mPh = 1;
                            }
                            this.wsskip();
                            n = 1;
                            this.mBuffIdx = -1;
                            continue block15;
                        }
                    }
                    this.panic(FAULT);
                    continue block15;
                }
                case 1: {
                    switch (c) {
                        case '?': {
                            n = 2;
                            continue block15;
                        }
                    }
                    this.bappend(c);
                    continue block15;
                }
                case 2: {
                    switch (c) {
                        case '>': {
                            this.pi(string, new String(this.mBuff, 0, this.mBuffIdx + 1));
                            n = -1;
                            continue block15;
                        }
                        case '?': {
                            this.bappend('?');
                            continue block15;
                        }
                    }
                    this.bappend('?');
                    this.bappend(c);
                    n = 1;
                    continue block15;
                }
            }
            this.panic(FAULT);
        }
    }

    private void cdat() throws Exception {
        this.mBuffIdx = -1;
        int n = 0;
        block12: while (n >= 0) {
            char c = this.getch();
            if (c == '\uffff') {
                this.panic(FAULT);
            }
            switch (n) {
                case 0: {
                    if (c == '[') {
                        n = 1;
                        continue block12;
                    }
                    this.panic(FAULT);
                    continue block12;
                }
                case 1: {
                    if (this.chtyp(c) == 'A') {
                        this.bappend(c);
                        continue block12;
                    }
                    if (!"CDATA".equals(new String(this.mBuff, 0, this.mBuffIdx + 1))) {
                        this.panic(FAULT);
                    }
                    this.bkch();
                    n = 2;
                    continue block12;
                }
                case 2: {
                    if (c != '[') {
                        this.panic(FAULT);
                    }
                    this.mBuffIdx = -1;
                    n = 3;
                    continue block12;
                }
                case 3: {
                    if (c != ']') {
                        this.bappend(c);
                        continue block12;
                    }
                    n = 4;
                    continue block12;
                }
                case 4: {
                    if (c != ']') {
                        this.bappend(']');
                        this.bappend(c);
                        n = 3;
                        continue block12;
                    }
                    n = 5;
                    continue block12;
                }
                case 5: {
                    switch (c) {
                        case ']': {
                            this.bappend(']');
                            continue block12;
                        }
                        case '>': {
                            this.bflash();
                            n = -1;
                            continue block12;
                        }
                    }
                    this.bappend(']');
                    this.bappend(']');
                    this.bappend(c);
                    n = 3;
                    continue block12;
                }
            }
            this.panic(FAULT);
        }
    }

    protected String name(boolean bl) throws Exception {
        this.mBuffIdx = -1;
        this.bname(bl);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    protected char[] qname(boolean bl) throws Exception {
        this.mBuffIdx = -1;
        this.bname(bl);
        char[] cArray = new char[this.mBuffIdx + 1];
        System.arraycopy(this.mBuff, 0, cArray, 0, this.mBuffIdx + 1);
        return cArray;
    }

    private void pubsys(Input input) throws Exception {
        Pair pair = this.pubsys(' ');
        input.pubid = pair.name;
        input.sysid = pair.value;
        this.del(pair);
    }

    private Pair pubsys(char c) throws Exception {
        Pair pair = this.pair(null);
        String string = this.name(false);
        if ("PUBLIC".equals(string)) {
            this.bqstr('i');
            pair.name = new String(this.mBuff, 1, this.mBuffIdx);
            switch (this.wsskip()) {
                case '\"': 
                case '\'': {
                    this.bqstr(' ');
                    pair.value = new String(this.mBuff, 1, this.mBuffIdx);
                    break;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
                default: {
                    if (c != 'N') {
                        this.panic(FAULT);
                    }
                    pair.value = null;
                }
            }
            return pair;
        }
        if ("SYSTEM".equals(string)) {
            pair.name = null;
            this.bqstr(' ');
            pair.value = new String(this.mBuff, 1, this.mBuffIdx);
            return pair;
        }
        this.panic(FAULT);
        return null;
    }

    protected String eqstr(char c) throws Exception {
        if (c == '=') {
            this.wsskip();
            if (this.getch() != '=') {
                this.panic(FAULT);
            }
        }
        this.bqstr(c == '=' ? (char)'-' : (char)c);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    private String ent(char c) throws Exception {
        int n = this.mBuffIdx + 1;
        Input input = null;
        String string = null;
        this.mESt = (char)256;
        this.bappend('&');
        int n2 = 0;
        block25: while (n2 >= 0) {
            char c2 = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            switch (n2) {
                case 0: 
                case 1: {
                    switch (this.chtyp(c2)) {
                        case '-': 
                        case '.': 
                        case 'd': {
                            if (n2 != 1) {
                                this.panic(FAULT);
                            }
                        }
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bappend(c2);
                            this.eappend(c2);
                            n2 = 1;
                            continue block25;
                        }
                        case ':': {
                            if (this.mIsNSAware) {
                                this.panic(FAULT);
                            }
                            this.bappend(c2);
                            this.eappend(c2);
                            n2 = 1;
                            continue block25;
                        }
                        case ';': {
                            if (this.mESt < '\u0100') {
                                this.mBuffIdx = n - 1;
                                this.bappend(this.mESt);
                                n2 = -1;
                                continue block25;
                            }
                            if (this.mPh == 2) {
                                this.bappend(';');
                                n2 = -1;
                                continue block25;
                            }
                            string = new String(this.mBuff, n + 1, this.mBuffIdx - n);
                            input = this.mEnt.get(string);
                            this.mBuffIdx = n - 1;
                            if (input != null) {
                                if (input.chars == null) {
                                    InputSource inputSource = this.resolveEnt(string, input.pubid, input.sysid);
                                    if (inputSource != null) {
                                        this.push(new Input(512));
                                        this.setinp(inputSource);
                                        this.mInp.pubid = input.pubid;
                                        this.mInp.sysid = input.sysid;
                                        string = null;
                                    } else if (c != 'x') {
                                        this.panic(FAULT);
                                    }
                                } else {
                                    this.push(input);
                                    string = null;
                                }
                            } else if (c != 'x') {
                                this.panic(FAULT);
                            }
                            n2 = -1;
                            continue block25;
                        }
                        case '#': {
                            if (n2 != 0) {
                                this.panic(FAULT);
                            }
                            n2 = 2;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 2: {
                    switch (this.chtyp(c2)) {
                        case 'd': {
                            this.bappend(c2);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int n3 = Integer.parseInt(new String(this.mBuff, n + 1, this.mBuffIdx - n), 10);
                                if (n3 >= 65535) {
                                    this.panic(FAULT);
                                }
                                c2 = (char)n3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = n - 1;
                            if (c2 == ' ' || this.mInp.next != null) {
                                this.bappend(c2, c);
                            } else {
                                this.bappend(c2);
                            }
                            n2 = -1;
                            continue block25;
                        }
                        case 'a': {
                            if (this.mBuffIdx != n || c2 != 'x') break;
                            n2 = 3;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 3: {
                    switch (this.chtyp(c2)) {
                        case 'A': 
                        case 'a': 
                        case 'd': {
                            this.bappend(c2);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int n4 = Integer.parseInt(new String(this.mBuff, n + 1, this.mBuffIdx - n), 16);
                                if (n4 >= 65535) {
                                    this.panic(FAULT);
                                }
                                c2 = (char)n4;
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = n - 1;
                            if (c2 == ' ' || this.mInp.next != null) {
                                this.bappend(c2, c);
                            } else {
                                this.bappend(c2);
                            }
                            n2 = -1;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
            }
            this.panic(FAULT);
        }
        return string;
    }

    private void pent(char c) throws Exception {
        int n = this.mBuffIdx + 1;
        Input input = null;
        String string = null;
        this.bappend('%');
        if (this.mPh != 2) {
            return;
        }
        this.bname(false);
        string = new String(this.mBuff, n + 2, this.mBuffIdx - n - 1);
        if (this.getch() != ';') {
            this.panic(FAULT);
        }
        input = this.mPEnt.get(string);
        this.mBuffIdx = n - 1;
        if (input != null) {
            if (input.chars == null) {
                InputSource inputSource = this.resolveEnt(string, input.pubid, input.sysid);
                if (inputSource != null) {
                    if (c != '-') {
                        this.bappend(' ');
                    }
                    this.push(new Input(512));
                    this.setinp(inputSource);
                    this.mInp.pubid = input.pubid;
                    this.mInp.sysid = input.sysid;
                } else {
                    this.skippedEnt("%" + string);
                }
            } else {
                if (c == '-') {
                    input.chIdx = 1;
                } else {
                    this.bappend(' ');
                    input.chIdx = 0;
                }
                this.push(input);
            }
        } else {
            this.skippedEnt("%" + string);
        }
    }

    private boolean isdecl(Pair pair, String string) {
        if (pair.chars[0] == '\u0000') {
            if ("xmlns".equals(pair.name)) {
                this.mPref = this.pair(this.mPref);
                this.mPref.list = this.mElm;
                this.mPref.value = string;
                this.mPref.name = FAULT;
                this.mPref.chars = NONS;
                ++this.mElm.num;
                return true;
            }
        } else if (pair.eqpref(XMLNS)) {
            int n = pair.name.length();
            this.mPref = this.pair(this.mPref);
            this.mPref.list = this.mElm;
            this.mPref.value = string;
            this.mPref.name = pair.name;
            this.mPref.chars = new char[n + 1];
            this.mPref.chars[0] = (char)(n + 1);
            pair.name.getChars(0, n, this.mPref.chars, 1);
            ++this.mElm.num;
            return true;
        }
        return false;
    }

    private String rslv(char[] cArray) throws Exception {
        Pair pair = this.mPref;
        while (pair != null) {
            if (pair.eqpref(cArray)) {
                return pair.value;
            }
            pair = pair.next;
        }
        if (cArray[0] == '\u0001') {
            pair = this.mPref;
            while (pair != null) {
                if (pair.chars[0] == '\u0000') {
                    return pair.value;
                }
                pair = pair.next;
            }
        }
        this.panic(FAULT);
        return null;
    }

    protected char wsskip() throws IOException {
        char c;
        do {
            char c2 = c = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
        } while (c < '\u0080' && nmttyp[c] == 3);
        --this.mChIdx;
        return c;
    }

    protected abstract void docType(String var1, String var2, String var3) throws SAXException;

    protected abstract void comm(char[] var1, int var2);

    protected abstract void pi(String var1, String var2) throws Exception;

    protected abstract void newPrefix() throws Exception;

    protected abstract void skippedEnt(String var1) throws Exception;

    protected abstract InputSource resolveEnt(String var1, String var2, String var3) throws Exception;

    protected abstract void notDecl(String var1, String var2, String var3) throws Exception;

    protected abstract void unparsedEntDecl(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract void panic(String var1) throws Exception;

    private void bname(boolean bl) throws Exception {
        int n;
        int n2;
        ++this.mBuffIdx;
        int n3 = n2 = this.mBuffIdx;
        int n4 = n = n2 + 1;
        int n5 = this.mChIdx;
        int n6 = bl ? 0 : 2;
        block12: while (true) {
            if (this.mChIdx >= this.mChLen) {
                this.bcopy(n5, n4);
                this.getch();
                n5 = --this.mChIdx;
                n4 = n;
            }
            char c = this.mChars[this.mChIdx++];
            char c2 = '\u0000';
            if (c < '\u0080') {
                c2 = (char)nmttyp[c];
            } else if (c == '\uffff') {
                this.panic(FAULT);
            }
            switch (n6) {
                case 0: 
                case 2: {
                    switch (c2) {
                        case '\u0000': {
                            ++n;
                            n6 = (short)(n6 + 1);
                            continue block12;
                        }
                        case '\u0001': {
                            --this.mChIdx;
                            n6 = (short)(n6 + 1);
                            continue block12;
                        }
                    }
                    this.panic(FAULT);
                    continue block12;
                }
                case 1: 
                case 3: {
                    switch (c2) {
                        case '\u0000': 
                        case '\u0002': {
                            ++n;
                            continue block12;
                        }
                        case '\u0001': {
                            ++n;
                            if (!bl) continue block12;
                            if (n3 != n2) {
                                this.panic(FAULT);
                            }
                            n3 = n - 1;
                            if (n6 != 1) continue block12;
                            n6 = 2;
                            continue block12;
                        }
                    }
                    --this.mChIdx;
                    this.bcopy(n5, n4);
                    this.mBuff[n2] = (char)(n3 - n2);
                    return;
                }
            }
            this.panic(FAULT);
        }
    }

    private void bntok() throws Exception {
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        block4: while (true) {
            char c = this.getch();
            switch (this.chtyp(c)) {
                case '-': 
                case '.': 
                case ':': 
                case 'A': 
                case 'X': 
                case '_': 
                case 'a': 
                case 'd': {
                    this.bappend(c);
                    continue block4;
                }
                case 'Z': {
                    this.panic(FAULT);
                }
            }
            break;
        }
        this.bkch();
    }

    private char bkeyword() throws Exception {
        String string = new String(this.mBuff, 1, this.mBuffIdx);
        switch (string.length()) {
            case 2: {
                return "ID".equals(string) ? (char)'i' : '?';
            }
            case 5: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREF".equals(string) ? (char)'r' : '?';
                    }
                    case 'C': {
                        return "CDATA".equals(string) ? (char)'c' : '?';
                    }
                    case 'F': {
                        return "FIXED".equals(string) ? (char)'F' : '?';
                    }
                }
                break;
            }
            case 6: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREFS".equals(string) ? (char)'R' : '?';
                    }
                    case 'E': {
                        return "ENTITY".equals(string) ? (char)'n' : '?';
                    }
                }
                break;
            }
            case 7: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IMPLIED".equals(string) ? (char)'I' : '?';
                    }
                    case 'N': {
                        return "NMTOKEN".equals(string) ? (char)'t' : '?';
                    }
                    case 'A': {
                        return "ATTLIST".equals(string) ? (char)'a' : '?';
                    }
                    case 'E': {
                        return "ELEMENT".equals(string) ? (char)'e' : '?';
                    }
                }
                break;
            }
            case 8: {
                switch (this.mBuff[2]) {
                    case 'N': {
                        return "ENTITIES".equals(string) ? (char)'N' : '?';
                    }
                    case 'M': {
                        return "NMTOKENS".equals(string) ? (char)'T' : '?';
                    }
                    case 'O': {
                        return "NOTATION".equals(string) ? (char)'o' : '?';
                    }
                    case 'E': {
                        return "REQUIRED".equals(string) ? (char)'Q' : '?';
                    }
                }
                break;
            }
        }
        return '?';
    }

    private void bqstr(char c) throws Exception {
        Input input = this.mInp;
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        int n = 0;
        block18: while (n >= 0) {
            int n2 = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block18;
                        }
                        case 39: {
                            n = 2;
                            continue block18;
                        }
                        case 34: {
                            n = 3;
                            continue block18;
                        }
                    }
                    this.panic(FAULT);
                    continue block18;
                }
                case 2: 
                case 3: {
                    switch (n2) {
                        case 39: {
                            if (n == 2 && this.mInp == input) {
                                n = -1;
                                continue block18;
                            }
                            this.bappend((char)n2);
                            continue block18;
                        }
                        case 34: {
                            if (n == 3 && this.mInp == input) {
                                n = -1;
                                continue block18;
                            }
                            this.bappend((char)n2);
                            continue block18;
                        }
                        case 38: {
                            if (c != 'd') {
                                this.ent(c);
                                continue block18;
                            }
                            this.bappend((char)n2);
                            continue block18;
                        }
                        case 37: {
                            if (c == 'd') {
                                this.pent('-');
                                continue block18;
                            }
                            this.bappend((char)n2);
                            continue block18;
                        }
                        case 60: {
                            if (c == '-' || c == 'd') {
                                this.bappend((char)n2);
                                continue block18;
                            }
                            this.panic(FAULT);
                            continue block18;
                        }
                        case 65535: {
                            this.panic(FAULT);
                        }
                        case 13: {
                            if (c == ' ' || this.mInp.next != null) break;
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            n2 = 10;
                        }
                    }
                    this.bappend((char)n2, c);
                    continue block18;
                }
            }
            this.panic(FAULT);
        }
        if (c == 'i' && this.mBuff[this.mBuffIdx] == ' ') {
            --this.mBuffIdx;
        }
    }

    protected abstract void bflash() throws Exception;

    protected abstract void bflash_ws() throws Exception;

    private void bappend(char c, char c2) throws Exception {
        block0 : switch (c2) {
            case 'i': {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.mBuffIdx > 0 && this.mBuff[this.mBuffIdx] != ' ') {
                            this.bappend(' ');
                        }
                        return;
                    }
                }
                break;
            }
            case 'c': {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        c = (char)32;
                        break block0;
                    }
                }
                break;
            }
        }
        ++this.mBuffIdx;
        if (this.mBuffIdx < this.mBuff.length) {
            this.mBuff[this.mBuffIdx] = c;
        } else {
            --this.mBuffIdx;
            this.bappend(c);
        }
    }

    private void bappend(char c) throws Exception {
        this.ensureCapacity(++this.mBuffIdx);
        this.mBuff[this.mBuffIdx] = c;
    }

    private void bcopy(int n, int n2) throws Exception {
        int n3 = this.mChIdx - n;
        this.ensureCapacity(n2 + n3 + 1);
        System.arraycopy(this.mChars, n, this.mBuff, n2, n3);
        this.mBuffIdx += n3;
    }

    private void eappend(char c) {
        block0 : switch (this.mESt) {
            case '\u0100': {
                switch (c) {
                    case 'l': {
                        this.mESt = (char)257;
                        break block0;
                    }
                    case 'g': {
                        this.mESt = (char)258;
                        break block0;
                    }
                    case 'a': {
                        this.mESt = (char)259;
                        break block0;
                    }
                    case 'q': {
                        this.mESt = (char)263;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0101': {
                this.mESt = (char)(c == 't' ? 60 : 512);
                break;
            }
            case '\u0102': {
                this.mESt = (char)(c == 't' ? 62 : 512);
                break;
            }
            case '\u0103': {
                switch (c) {
                    case 'm': {
                        this.mESt = (char)260;
                        break block0;
                    }
                    case 'p': {
                        this.mESt = (char)261;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0104': {
                this.mESt = (char)(c == 'p' ? 38 : 512);
                break;
            }
            case '\u0105': {
                this.mESt = (char)(c == 'o' ? 262 : 512);
                break;
            }
            case '\u0106': {
                this.mESt = (char)(c == 's' ? 39 : 512);
                break;
            }
            case '\u0107': {
                this.mESt = (char)(c == 'u' ? 264 : 512);
                break;
            }
            case '\u0108': {
                this.mESt = (char)(c == 'o' ? 265 : 512);
                break;
            }
            case '\u0109': {
                this.mESt = (char)(c == 't' ? 34 : 512);
                break;
            }
            case '\"': 
            case '&': 
            case '\'': 
            case '<': 
            case '>': {
                this.mESt = (char)512;
            }
        }
    }

    protected void setinp(InputSource inputSource) throws Exception {
        Reader reader = null;
        this.mChIdx = 0;
        this.mChLen = 0;
        this.mChars = this.mInp.chars;
        this.mInp.src = null;
        if (this.mPh < 0) {
            this.mIsSAlone = false;
        }
        this.mIsSAloneSet = false;
        if (inputSource.getCharacterStream() != null) {
            reader = inputSource.getCharacterStream();
            this.xml(reader);
        } else if (inputSource.getByteStream() != null) {
            if (inputSource.getEncoding() != null) {
                String string = inputSource.getEncoding().toUpperCase();
                reader = string.equals("UTF-16") ? this.bom(inputSource.getByteStream(), 'U') : this.enc(string, inputSource.getByteStream());
                this.xml(reader);
            } else {
                reader = this.bom(inputSource.getByteStream(), ' ');
                if (reader == null) {
                    reader = this.enc("UTF-8", inputSource.getByteStream());
                    String string = this.xml(reader);
                    if (string.startsWith("UTF-16")) {
                        this.panic(FAULT);
                    }
                    reader = this.enc(string, inputSource.getByteStream());
                } else {
                    this.xml(reader);
                }
            }
        } else {
            this.panic(FAULT);
        }
        this.mInp.src = reader;
        this.mInp.pubid = inputSource.getPublicId();
        this.mInp.sysid = inputSource.getSystemId();
    }

    private Reader bom(InputStream inputStream, char c) throws Exception {
        int n = inputStream.read();
        switch (n) {
            case 239: {
                if (c == 'U') {
                    this.panic(FAULT);
                }
                if (inputStream.read() != 187) {
                    this.panic(FAULT);
                }
                if (inputStream.read() != 191) {
                    this.panic(FAULT);
                }
                return new ReaderUTF8(inputStream);
            }
            case 254: {
                if (inputStream.read() != 255) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(inputStream, 'b');
            }
            case 255: {
                if (inputStream.read() != 254) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(inputStream, 'l');
            }
            case -1: {
                this.mChars[this.mChIdx++] = 65535;
                return new ReaderUTF8(inputStream);
            }
        }
        if (c == 'U') {
            this.panic(FAULT);
        }
        switch (n & 0xF0) {
            case 192: 
            case 208: {
                this.mChars[this.mChIdx++] = (char)((n & 0x1F) << 6 | inputStream.read() & 0x3F);
                break;
            }
            case 224: {
                this.mChars[this.mChIdx++] = (char)((n & 0xF) << 12 | (inputStream.read() & 0x3F) << 6 | inputStream.read() & 0x3F);
                break;
            }
            case 240: {
                throw new UnsupportedEncodingException();
            }
            default: {
                this.mChars[this.mChIdx++] = (char)n;
            }
        }
        return null;
    }

    private String xml(Reader reader) throws Exception {
        int n;
        String string = null;
        String string2 = "UTF-8";
        int n2 = this.mChIdx != 0 ? (int)((short)(this.mChars[0] == '<' ? 1 : -1)) : 0;
        block38: while (n2 >= 0 && this.mChIdx < this.mChars.length) {
            int n3 = reader.read();
            n = n3 >= 0 ? (int)n3 : 65535;
            this.mChars[this.mChIdx++] = n;
            switch (n2) {
                case 0: {
                    switch (n) {
                        case 60: {
                            n2 = 1;
                            continue block38;
                        }
                        case 65279: {
                            n3 = reader.read();
                            this.mChars[this.mChIdx - 1] = n = n3 >= 0 ? (int)n3 : 65535;
                            n2 = (short)(n == 60 ? 1 : -1);
                            continue block38;
                        }
                    }
                    n2 = -1;
                    continue block38;
                }
                case 1: {
                    n2 = (short)(n == 63 ? 2 : -1);
                    continue block38;
                }
                case 2: {
                    n2 = (short)(n == 120 ? 3 : -1);
                    continue block38;
                }
                case 3: {
                    n2 = (short)(n == 109 ? 4 : -1);
                    continue block38;
                }
                case 4: {
                    n2 = (short)(n == 108 ? 5 : -1);
                    continue block38;
                }
                case 5: {
                    switch (n) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            n2 = 6;
                            continue block38;
                        }
                    }
                    n2 = -1;
                    continue block38;
                }
                case 6: {
                    switch (n) {
                        case 63: {
                            n2 = 7;
                            continue block38;
                        }
                        case 65535: {
                            n2 = -2;
                            continue block38;
                        }
                    }
                    continue block38;
                }
                case 7: {
                    switch (n) {
                        case 62: 
                        case 65535: {
                            n2 = -2;
                            continue block38;
                        }
                    }
                    n2 = 6;
                    continue block38;
                }
            }
            this.panic(FAULT);
        }
        this.mChLen = this.mChIdx;
        this.mChIdx = 0;
        if (n2 == -1) {
            return string2;
        }
        this.mChIdx = 5;
        n2 = 0;
        block39: while (n2 >= 0) {
            n = this.getch();
            switch (n2) {
                case 0: {
                    if (this.chtyp((char)n) == ' ') continue block39;
                    this.bkch();
                    n2 = 1;
                    continue block39;
                }
                case 1: 
                case 2: 
                case 3: {
                    switch (this.chtyp((char)n)) {
                        case 'A': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            string = this.name(false).toLowerCase();
                            if ("version".equals(string)) {
                                if (n2 != 1) {
                                    this.panic(FAULT);
                                }
                                if (!"1.0".equals(this.eqstr('='))) {
                                    this.panic(FAULT);
                                }
                                this.mInp.xmlver = (char)256;
                                n2 = 2;
                                continue block39;
                            }
                            if ("encoding".equals(string)) {
                                if (n2 != 2) {
                                    this.panic(FAULT);
                                }
                                string2 = this.mInp.xmlenc = this.eqstr('=').toUpperCase();
                                n2 = 3;
                                continue block39;
                            }
                            if ("standalone".equals(string)) {
                                if (n2 == 1 || this.mPh >= 0) {
                                    this.panic(FAULT);
                                }
                                if ((string = this.eqstr('=').toLowerCase()).equals("yes")) {
                                    this.mIsSAlone = true;
                                } else if (string.equals("no")) {
                                    this.mIsSAlone = false;
                                } else {
                                    this.panic(FAULT);
                                }
                                this.mIsSAloneSet = true;
                                n2 = 4;
                                continue block39;
                            }
                            this.panic(FAULT);
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                        case '?': {
                            if (n2 == 1) {
                                this.panic(FAULT);
                            }
                            this.bkch();
                            n2 = 4;
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
                case 4: {
                    switch (this.chtyp((char)n)) {
                        case '?': {
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            if (this.mPh <= 0) {
                                this.mPh = 1;
                            }
                            n2 = -1;
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
            }
            this.panic(FAULT);
        }
        return string2;
    }

    private Reader enc(String string, InputStream inputStream) throws UnsupportedEncodingException {
        if (string.equals("UTF-8")) {
            return new ReaderUTF8(inputStream);
        }
        if (string.equals("UTF-16LE")) {
            return new ReaderUTF16(inputStream, 'l');
        }
        if (string.equals("UTF-16BE")) {
            return new ReaderUTF16(inputStream, 'b');
        }
        return new InputStreamReader(inputStream, string);
    }

    protected void push(Input input) {
        this.mInp.chLen = this.mChLen;
        this.mInp.chIdx = this.mChIdx;
        input.next = this.mInp;
        this.mInp = input;
        this.mChars = input.chars;
        this.mChLen = input.chLen;
        this.mChIdx = input.chIdx;
    }

    protected void pop() {
        if (this.mInp.src != null) {
            try {
                this.mInp.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mInp.src = null;
        }
        this.mInp = this.mInp.next;
        if (this.mInp != null) {
            this.mChars = this.mInp.chars;
            this.mChLen = this.mInp.chLen;
            this.mChIdx = this.mInp.chIdx;
        } else {
            this.mChars = null;
            this.mChLen = 0;
            this.mChIdx = 0;
        }
    }

    protected char chtyp(char c) {
        if (c < '\u0080') {
            return (char)asctyp[c];
        }
        return c != '\uffff' ? (char)'X' : 'Z';
    }

    protected char getch() throws IOException {
        if (this.mChIdx >= this.mChLen) {
            if (this.mInp.src == null) {
                this.pop();
                return this.getch();
            }
            int n = this.mInp.src.read(this.mChars, 0, this.mChars.length);
            if (n < 0) {
                if (this.mInp != this.mDoc) {
                    this.pop();
                    return this.getch();
                }
                this.mChars[0] = 65535;
                this.mChLen = 1;
            } else {
                this.mChLen = n;
            }
            this.mChIdx = 0;
        }
        return this.mChars[this.mChIdx++];
    }

    protected void bkch() throws Exception {
        if (this.mChIdx <= 0) {
            this.panic(FAULT);
        }
        --this.mChIdx;
    }

    protected void setch(char c) {
        this.mChars[this.mChIdx] = c;
    }

    protected Pair find(Pair pair, char[] cArray) {
        Pair pair2 = pair;
        while (pair2 != null) {
            if (pair2.eqname(cArray)) {
                return pair2;
            }
            pair2 = pair2.next;
        }
        return null;
    }

    protected Pair pair(Pair pair) {
        Pair pair2;
        if (this.mDltd != null) {
            pair2 = this.mDltd;
            this.mDltd = pair2.next;
        } else {
            pair2 = new Pair();
        }
        pair2.next = pair;
        return pair2;
    }

    protected Pair del(Pair pair) {
        Pair pair2 = pair.next;
        pair.name = null;
        pair.value = null;
        pair.chars = null;
        pair.list = null;
        pair.next = this.mDltd;
        this.mDltd = pair;
        return pair2;
    }

    private void ensureCapacity(int n) throws Exception {
        if (this.mBuff == null) {
            int n2 = n > 128 ? n + 128 : 128;
            this.mBuff = new char[n2];
            return;
        }
        if (this.mBuff.length <= n) {
            int n3;
            int n4 = this.mBuff.length << 1;
            int n5 = n3 = n4 > n ? n4 : n + 128;
            if (n3 < 0 || n3 > 0x4000000) {
                this.panic(FAULT);
            }
            this.mBuff = Arrays.copyOf(this.mBuff, n3);
        }
    }

    static {
        int n;
        NONS = new char[1];
        Parser.NONS[0] = '\u0000';
        XML = new char[4];
        Parser.XML[0] = 4;
        Parser.XML[1] = 120;
        Parser.XML[2] = 109;
        Parser.XML[3] = 108;
        XMLNS = new char[6];
        Parser.XMLNS[0] = 6;
        Parser.XMLNS[1] = 120;
        Parser.XMLNS[2] = 109;
        Parser.XMLNS[3] = 108;
        Parser.XMLNS[4] = 110;
        Parser.XMLNS[5] = 115;
        asctyp = new byte[128];
        for (n = 0; n < 32; n = (int)((short)(n + 1))) {
            int n2 = n;
            Parser.asctyp[n2] = 122;
        }
        Parser.asctyp[9] = 32;
        Parser.asctyp[13] = 32;
        Parser.asctyp[10] = 32;
        while (n < 48) {
            int n3 = n;
            int n4 = n;
            n = (short)(n + 1);
            Parser.asctyp[n3] = (byte)n4;
        }
        while (n <= 57) {
            int n5 = n;
            n = (short)(n + 1);
            Parser.asctyp[n5] = 100;
        }
        while (n < 65) {
            int n6 = n;
            int n7 = n;
            n = (short)(n + 1);
            Parser.asctyp[n6] = (byte)n7;
        }
        while (n <= 90) {
            int n8 = n;
            n = (short)(n + 1);
            Parser.asctyp[n8] = 65;
        }
        while (n < 97) {
            int n9 = n;
            int n10 = n;
            n = (short)(n + 1);
            Parser.asctyp[n9] = (byte)n10;
        }
        while (n <= 122) {
            int n11 = n;
            n = (short)(n + 1);
            Parser.asctyp[n11] = 97;
        }
        while (n < 128) {
            int n12 = n;
            int n13 = n;
            n = (short)(n + 1);
            Parser.asctyp[n12] = (byte)n13;
        }
        nmttyp = new byte[128];
        for (n = 0; n < 48; n = (int)((short)(n + 1))) {
            Parser.nmttyp[n] = -1;
        }
        while (n <= 57) {
            int n14 = n;
            n = (short)(n + 1);
            Parser.nmttyp[n14] = 2;
        }
        while (n < 65) {
            int n15 = n;
            n = (short)(n + 1);
            Parser.nmttyp[n15] = -1;
        }
        for (n = 91; n < 97; n = (int)((short)(n + 1))) {
            Parser.nmttyp[n] = -1;
        }
        for (n = 123; n < 128; n = (int)((short)(n + 1))) {
            Parser.nmttyp[n] = -1;
        }
        Parser.nmttyp[95] = 0;
        Parser.nmttyp[58] = 1;
        Parser.nmttyp[46] = 2;
        Parser.nmttyp[45] = 2;
        Parser.nmttyp[32] = 3;
        Parser.nmttyp[9] = 3;
        Parser.nmttyp[13] = 3;
        Parser.nmttyp[10] = 3;
    }
}

