/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import java.awt.color.ColorSpace;

public final class SimpleCMYKColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 5387117338644522424L;
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new SimpleCMYKColorSpace();
        }
        return theInstance;
    }

    private SimpleCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object object) {
        return object instanceof SimpleCMYKColorSpace;
    }

    public int hashCode() {
        return System.identityHashCode(theInstance);
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = 1.0f - f4;
        float[] fArray2 = new float[]{f5 * (1.0f - f), f5 * (1.0f - f2), f5 * (1.0f - f3)};
        for (int i = 0; i < 3; ++i) {
            float f6 = fArray2[i];
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            if (f6 < 0.0031308f) {
                fArray2[i] = 12.92f * f6;
                continue;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            fArray2[i] = (float)(1.055 * Math.pow(f6, 0.4166666666666667) - 0.055);
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        for (int i = 0; i < 3; ++i) {
            if (fArray[i] < 0.040449936f) {
                int n = i;
                fArray[n] = fArray[n] / 12.92f;
                continue;
            }
            fArray[i] = (float)Math.pow(((double)fArray[i] + 0.055) / 1.055, 2.4);
        }
        float f = 1.0f - fArray[0];
        float f2 = 1.0f - fArray[1];
        float f3 = 1.0f - fArray[2];
        float f4 = Math.min(f, Math.min(f2, f3));
        if (f4 != 1.0f) {
            float f5 = 1.0f - f4;
            f = (f - f4) / f5;
            f2 = (f2 - f4) / f5;
            f3 = (f3 - f4) / f5;
        } else {
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        }
        return new float[]{f, f2, f3, f4};
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return this.csRGB.toCIEXYZ(this.toRGB(fArray));
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(fArray));
    }
}

