/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.attribute.FileAttribute;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.wbs1.model.Wbs1Access;
import jp.co.extreme.module.xweb.common.WbxAccessLogger;

public class WbxAccessLoggerImpl
implements WbxAccessLogger {
    private File file;
    private FileWriter filewriter;

    public WbxAccessLoggerImpl() throws Exception {
        File dir = null;
        try {
            dir = new File(AfbApplication.getInstance().toReal("${APP}log/"));
            BcFileUtil.mkdirs(dir, new FileAttribute[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.file = new File(dir, "access_log.txt");
        this.filewriter = new FileWriter(this.file, true);
    }

    @Override
    public void log(Wbs1Access access) {
        try {
            String accessDate = BcTimeUtil.toString(access.accessDate, "yyyy/MM/dd");
            String accessTime = BcTimeUtil.toStringFromHHmmssSSS(access.accessTime, "HH:mm:ss.SSS");
            String log = BcStringUtil.toCsv(accessDate, accessTime, access.remoteAddress, access.remoteUser, access.requestUrl, access.referer);
            this.filewriter.write(String.valueOf(log.toString()) + "\n");
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }
}

