/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.fx;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.mmdx.common.MmdxWords;
import jp.co.extreme.module.mmdx.model.MmdxModel;

public class MmdxHeaderPane
extends BorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxNumberField schemaIdField = new FxNumberField();
    FxTextField tableNameField = new FxTextField();
    FxTextField logicalNameField = new FxTextField();
    MmdxModel mmdxModel;

    public MmdxHeaderPane() throws Exception {
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.schemaIdField.setPrefColumnCount(6);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new Label(MmdxWords.getInstance().schemaId), new Node[]{this.schemaIdField});
        this.centerPane.addNodeUnit(controlUnit);
        this.tableNameField.setPrefColumnCount(40);
        controlUnit = new FxNodeUnit((Node)new Label(BcWords.getInstance().tableName), new Node[]{this.tableNameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.logicalNameField.setPrefColumnCount(40);
        controlUnit = new FxNodeUnit((Node)new Label(BcWords.getInstance().logicalName), new Node[]{this.logicalNameField});
        this.centerPane.addNodeUnit(controlUnit);
        FxUtil.setEditable((Node)this, false);
        this.tableNameField.setEditable(true);
        this.logicalNameField.setEditable(true);
    }

    public void setXmmd(MmdxModel mmdxModel) throws Exception {
        this.mmdxModel = mmdxModel;
        this.schemaIdField.setValue(mmdxModel.dataSourceId);
        this.tableNameField.setText(mmdxModel.tableName);
        this.logicalNameField.setText(mmdxModel.logicalName);
    }

    protected void storeData() throws Exception {
        this.mmdxModel.dataSourceId = this.schemaIdField.getBigDecimal().intValue();
        this.mmdxModel.tableName = this.tableNameField.getText();
        this.mmdxModel.logicalName = this.logicalNameField.getText();
    }
}

