/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerFactory;
import jp.co.extreme.base.log.BcLoggerJul;
import jp.co.extreme.base.log.BcSimpleLoggerShutdownHook;
import jp.co.extreme.base.log.JLogFormatter;

public class BcLoggerFactoryJul
implements BcLoggerFactory {
    private BcSimpleLoggerShutdownHook shutdownHook;
    Formatter formatter = new JLogFormatter();

    @Override
    public BcLogger createLogger(String loggerName, boolean isAdditive, boolean consoleEnabled) throws Exception {
        System.out.println("createLogger:loggerName=" + loggerName);
        BcLoggerJul loggerJul = (BcLoggerJul)BcLogUtil.loggerMap.get(loggerName);
        Logger julLogger = null;
        if (loggerJul == null) {
            julLogger = Logger.getLogger(loggerName);
            julLogger.setUseParentHandlers(isAdditive);
            loggerJul = new BcLoggerJul();
            loggerJul.setjulLogger(julLogger);
        } else {
            julLogger = loggerJul.getjulLogger();
        }
        BcLoggerFactoryJul.removeHandler(julLogger);
        if (consoleEnabled) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(this.formatter);
            julLogger.addHandler(consoleHandler);
        }
        if (this.shutdownHook != null) {
            this.shutdownHook = new BcSimpleLoggerShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        return loggerJul;
    }

    @Override
    public void addFileFileHandler(BcLogger logger, File destFile) throws Exception {
        BcLoggerJul loggerJul = (BcLoggerJul)logger;
        Logger julLogger = loggerJul.getjulLogger();
        System.out.println("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileHandler fileHandler = new FileHandler(destFile.getPath(), true);
        fileHandler.setFormatter(this.formatter);
        julLogger.addHandler(fileHandler);
    }

    public static Level toJulLevel(BcLogConstants.LogLevel logLevel) {
        Level julLevel = null;
        switch (logLevel) {
            case OFF: {
                julLevel = Level.OFF;
                break;
            }
            case FATAL: {
                julLevel = Level.SEVERE;
                break;
            }
            case ERROR: {
                julLevel = Level.SEVERE;
                break;
            }
            case WARN: {
                julLevel = Level.WARNING;
                break;
            }
            case INFO: {
                julLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                julLevel = Level.CONFIG;
                break;
            }
            case TRACE: {
                julLevel = Level.FINEST;
                break;
            }
            case ALL: {
                julLevel = Level.ALL;
            }
        }
        return julLevel;
    }

    public static BcLogConstants.LogLevel toLogLevel(Level julLevel) {
        BcLogConstants.LogLevel logLevel = null;
        if (julLevel == Level.OFF) {
            logLevel = BcLogConstants.LogLevel.OFF;
        } else if (julLevel == Level.SEVERE) {
            logLevel = BcLogConstants.LogLevel.FATAL;
        } else if (julLevel == Level.SEVERE) {
            logLevel = BcLogConstants.LogLevel.ERROR;
        } else if (julLevel == Level.WARNING) {
            logLevel = BcLogConstants.LogLevel.WARN;
        } else if (julLevel == Level.INFO) {
            logLevel = BcLogConstants.LogLevel.INFO;
        } else if (julLevel == Level.CONFIG) {
            logLevel = BcLogConstants.LogLevel.DEBUG;
        } else if (julLevel == Level.FINEST) {
            logLevel = BcLogConstants.LogLevel.TRACE;
        } else if (julLevel == Level.ALL) {
            logLevel = BcLogConstants.LogLevel.ALL;
        }
        return logLevel;
    }

    public static void removeHandler(Logger julLogger) throws Exception {
        Handler[] handlers;
        Handler[] handlerArray = handlers = julLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            julLogger.removeHandler(handler);
            ++n2;
        }
    }
}

