/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import sun.swing.SwingUtilities2;

public class FixedHeightLayoutCache
extends AbstractLayoutCache {
    private FHTreeStateNode root;
    private int rowCount;
    private Rectangle boundsBuffer;
    private Hashtable<TreePath, FHTreeStateNode> treePathMapping;
    private SearchInfo info;
    private Stack<Stack<TreePath>> tempStacks = new Stack();

    public FixedHeightLayoutCache() {
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
        this.info = new SearchInfo();
        this.setRowHeight(1);
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild(false);
    }

    @Override
    public void setRootVisible(boolean bl) {
        if (this.isRootVisible() != bl) {
            super.setRootVisible(bl);
            if (this.root != null) {
                if (bl) {
                    ++this.rowCount;
                    this.root.adjustRowBy(1);
                } else {
                    --this.rowCount;
                    this.root.adjustRowBy(-1);
                }
                this.visibleNodesChanged();
            }
        }
    }

    @Override
    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("FixedHeightLayoutCache only supports row heights greater than 0");
        }
        if (this.getRowHeight() != n) {
            super.setRowHeight(n);
            this.visibleNodesChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void invalidatePathBounds(TreePath treePath) {
    }

    @Override
    public void invalidateSizes() {
        this.visibleNodesChanged();
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
            return fHTreeStateNode != null && fHTreeStateNode.isExpanded();
        }
        return false;
    }

    @Override
    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        int n;
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return this.getBounds(fHTreeStateNode, -1, rectangle);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded() && (n = this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent())) != -1) {
            return this.getBounds(fHTreeStateNode, n, rectangle);
        }
        return null;
    }

    @Override
    public TreePath getPathForRow(int n) {
        if (n >= 0 && n < this.getRowCount() && this.root.getPathForRow(n, this.getRowCount(), this.info)) {
            return this.info.getPath();
        }
        return null;
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        if (treePath == null || this.root == null) {
            return -1;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return fHTreeStateNode.getRow();
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return fHTreeStateNode.getRowToModelIndex(this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return -1;
    }

    @Override
    public TreePath getPathClosestTo(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        int n3 = this.getRowContainingYLocation(n2);
        return this.getPathForRow(n3);
    }

    @Override
    public int getVisibleChildCount(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode == null) {
            return 0;
        }
        return fHTreeStateNode.getTotalChildCount();
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode, this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return null;
    }

    @Override
    public void setExpandedState(TreePath treePath, boolean bl) {
        if (bl) {
            this.ensurePathIsExpanded(treePath, true);
        } else if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null && (fHTreeStateNode = this.getNodeForPath(treePath2, false, true)) != null) {
                fHTreeStateNode.makeVisible();
            }
            if ((fHTreeStateNode = this.getNodeForPath(treePath, true, false)) != null) {
                fHTreeStateNode.collapse(true);
            }
        }
    }

    @Override
    public boolean getExpandedState(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        return fHTreeStateNode != null ? fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded() : false;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(SwingUtilities2.getTreePath(treeModelEvent, this.getModel()), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null) {
                int n;
                if (nArray != null && (n = nArray.length) > 0) {
                    Object object = fHTreeStateNode.getUserObject();
                    for (int i = 0; i < n; ++i) {
                        FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode.getChildAtModelIndex(nArray[i]);
                        if (fHTreeStateNode2 == null) continue;
                        fHTreeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[i]));
                    }
                    if (fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                        this.visibleNodesChanged();
                    }
                } else if (fHTreeStateNode == this.root && fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n;
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(SwingUtilities2.getTreePath(treeModelEvent, this.getModel()), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n = nArray.length) > 0) {
                boolean bl = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                for (int i = 0; i < n; ++i) {
                    fHTreeStateNode.childInsertedAtModelIndex(nArray[i], bl);
                }
                if (bl && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n;
            TreePath treePath = SwingUtilities2.getTreePath(treeModelEvent, this.getModel());
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n = nArray.length) > 0) {
                Object[] objectArray = treeModelEvent.getChildren();
                boolean bl = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                for (int i = n - 1; i >= 0; --i) {
                    fHTreeStateNode.removeChildAtModelIndex(nArray[i], bl);
                }
                if (bl) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (this.treeModel.getChildCount(fHTreeStateNode.getUserObject()) == 0 && fHTreeStateNode.isLeaf()) {
                        fHTreeStateNode.collapse(false);
                    }
                    this.visibleNodesChanged();
                } else if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = SwingUtilities2.getTreePath(treeModelEvent, this.getModel());
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            if (fHTreeStateNode == this.root || fHTreeStateNode == null && (treePath == null && this.treeModel != null && this.treeModel.getRoot() == null || treePath != null && treePath.getPathCount() <= 1)) {
                this.rebuild(true);
            } else if (fHTreeStateNode != null) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getParent();
                boolean bl = fHTreeStateNode.isExpanded();
                boolean bl2 = fHTreeStateNode.isVisible();
                int n = fHTreeStateNode2.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                fHTreeStateNode2.remove(n);
                if (bl2 && bl) {
                    int n2 = fHTreeStateNode.getRow();
                    fHTreeStateNode2.resetChildrenRowsFrom(n2, n, fHTreeStateNode.getChildIndex());
                    fHTreeStateNode = this.getNodeForPath(treePath, false, true);
                    fHTreeStateNode.expand();
                }
                if (this.treeSelectionModel != null && bl2 && bl) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (bl2) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private Rectangle getBounds(FHTreeStateNode fHTreeStateNode, int n, Rectangle rectangle) {
        int n2;
        boolean bl;
        Object object;
        int n3;
        if (n == -1) {
            n3 = fHTreeStateNode.getRow();
            object = fHTreeStateNode.getUserObject();
            bl = fHTreeStateNode.isExpanded();
            n2 = fHTreeStateNode.getLevel();
        } else {
            n3 = fHTreeStateNode.getRowToModelIndex(n);
            object = this.treeModel.getChild(fHTreeStateNode.getUserObject(), n);
            bl = false;
            n2 = fHTreeStateNode.getLevel() + 1;
        }
        Rectangle rectangle2 = this.getNodeDimensions(object, n3, n2, bl, this.boundsBuffer);
        if (rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = rectangle2.x;
        rectangle.height = this.getRowHeight();
        rectangle.y = n3 * rectangle.height;
        rectangle.width = rectangle2.width;
        return rectangle;
    }

    private void adjustRowCountBy(int n) {
        this.rowCount += n;
    }

    private void addMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.put(fHTreeStateNode.getTreePath(), fHTreeStateNode);
    }

    private void removeMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.remove(fHTreeStateNode.getTreePath());
    }

    private FHTreeStateNode getMapping(TreePath treePath) {
        return this.treePathMapping.get(treePath);
    }

    private void rebuild(boolean bl) {
        Object object;
        this.treePathMapping.clear();
        if (this.treeModel != null && (object = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(object, 0);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            if (this.isRootVisible()) {
                this.rowCount = 1;
                this.root.row = 0;
            } else {
                this.rowCount = 0;
                this.root.row = -1;
            }
            this.root.expand();
        } else {
            this.root = null;
            this.rowCount = 0;
        }
        if (bl && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private int getRowContainingYLocation(int n) {
        if (this.getRowCount() == 0) {
            return -1;
        }
        return Math.max(0, Math.min(this.getRowCount() - 1, n / this.getRowHeight()));
    }

    private boolean ensurePathIsExpanded(TreePath treePath, boolean bl) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl = true;
            }
            if (treePath != null && (fHTreeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                fHTreeStateNode.makeVisible();
                if (bl) {
                    fHTreeStateNode.expand();
                }
                return true;
            }
        }
        return false;
    }

    private FHTreeStateNode createNodeForValue(Object object, int n) {
        return new FHTreeStateNode(object, n, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FHTreeStateNode getNodeForPath(TreePath treePath, boolean bl, boolean bl2) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getMapping(treePath);
            if (fHTreeStateNode != null) {
                if (bl && !fHTreeStateNode.isVisible()) {
                    return null;
                }
                return fHTreeStateNode;
            }
            if (bl) {
                return null;
            }
            Stack<Object> stack = this.tempStacks.size() == 0 ? new Stack() : this.tempStacks.pop();
            try {
                stack.push(treePath);
                fHTreeStateNode = null;
                for (treePath = treePath.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
                    fHTreeStateNode = this.getMapping(treePath);
                    if (fHTreeStateNode != null) {
                        while (fHTreeStateNode != null && stack.size() > 0) {
                            treePath = (TreePath)stack.pop();
                            fHTreeStateNode = fHTreeStateNode.createChildFor(treePath.getLastPathComponent());
                        }
                        FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode;
                        return fHTreeStateNode2;
                    }
                    stack.push(treePath);
                }
            }
            finally {
                stack.removeAllElements();
                this.tempStacks.push(stack);
            }
            return null;
        }
        return null;
    }

    private class VisibleFHTreeStateNodeEnumeration
    implements Enumeration<TreePath> {
        protected FHTreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode) {
            this(fHTreeStateNode, -1);
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode, int n) {
            this.parent = fHTreeStateNode;
            this.nextIndex = n;
            this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
        }

        @Override
        public boolean hasMoreElements() {
            return this.parent != null;
        }

        @Override
        public TreePath nextElement() {
            FHTreeStateNode fHTreeStateNode;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath treePath = this.nextIndex == -1 ? this.parent.getTreePath() : ((fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : fHTreeStateNode.getTreePath());
            this.updateNextObject();
            return treePath;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == FixedHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.parent.getParent();
                if (fHTreeStateNode != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = fHTreeStateNode;
                    this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            FHTreeStateNode fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex);
            if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
                this.parent = fHTreeStateNode;
                this.nextIndex = -1;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(fHTreeStateNode.getUserObject());
            }
            return true;
        }
    }

    private class SearchInfo {
        protected FHTreeStateNode node;
        protected boolean isNodeParentNode;
        protected int childIndex;

        private SearchInfo() {
        }

        protected TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private class FHTreeStateNode
    extends DefaultMutableTreeNode {
        protected boolean isExpanded;
        protected int childIndex;
        protected int childCount;
        protected int row;
        protected TreePath path;

        public FHTreeStateNode(Object object, int n, int n2) {
            super(object);
            this.childIndex = n;
            this.row = n2;
        }

        @Override
        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((FHTreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                FixedHeightLayoutCache.this.addMapping(this);
            }
        }

        @Override
        public void remove(int n) {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n);
            fHTreeStateNode.removeFromMapping();
            super.remove(n);
        }

        @Override
        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null) {
                    this.resetChildrenPaths(fHTreeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public FHTreeStateNode getChildAtModelIndex(int n) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                if (((FHTreeStateNode)this.getChildAt((int)i)).childIndex != n) continue;
                return (FHTreeStateNode)this.getChildAt(i);
            }
            return null;
        }

        public boolean isVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode == null) {
                return true;
            }
            return fHTreeStateNode.isExpanded() && fHTreeStateNode.isVisible();
        }

        public int getRow() {
            return this.row;
        }

        public int getRowToModelIndex(int n) {
            int n2;
            int n3 = n2 = this.getRow() + 1;
            int n4 = this.getChildCount();
            for (int i = 0; i < n4; ++i) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                if (fHTreeStateNode.childIndex < n) continue;
                if (fHTreeStateNode.childIndex == n) {
                    return fHTreeStateNode.row;
                }
                if (i == 0) {
                    return this.getRow() + 1 + n;
                }
                return fHTreeStateNode.row - (fHTreeStateNode.childIndex - n);
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (this.childCount - n);
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int n;
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null && (n = fHTreeStateNode.getIndex(this)) + 1 < fHTreeStateNode.getChildCount()) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getChildAt(n + 1);
                    return fHTreeStateNode2.row - this.row - (fHTreeStateNode2.childIndex - this.childIndex);
                }
                int n2 = this.childCount;
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    n2 += ((FHTreeStateNode)this.getChildAt(i)).getTotalChildCount();
                }
                return n2;
            }
            return 0;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public int getVisibleLevel() {
            if (FixedHeightLayoutCache.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        protected void resetChildrenPaths(TreePath treePath) {
            FixedHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            FixedHeightLayoutCache.this.addMapping(this);
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                ((FHTreeStateNode)this.getChildAt(i)).resetChildrenPaths(this.path);
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                FixedHeightLayoutCache.this.removeMapping(this);
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    ((FHTreeStateNode)this.getChildAt(i)).removeFromMapping();
                }
            }
        }

        protected FHTreeStateNode createChildFor(Object object) {
            int n = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.getUserObject(), object);
            if (n < 0) {
                return null;
            }
            FHTreeStateNode fHTreeStateNode = FixedHeightLayoutCache.this.createNodeForValue(object, n);
            int n2 = this.isVisible() ? this.getRowToModelIndex(n) : -1;
            fHTreeStateNode.row = n2;
            int n3 = this.getChildCount();
            for (int i = 0; i < n3; ++i) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(i);
                if (fHTreeStateNode2.childIndex <= n) continue;
                this.insert(fHTreeStateNode, i);
                return fHTreeStateNode;
            }
            this.add(fHTreeStateNode);
            return fHTreeStateNode;
        }

        protected void adjustRowBy(int n) {
            this.row += n;
            if (this.isExpanded) {
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    ((FHTreeStateNode)this.getChildAt(i)).adjustRowBy(n);
                }
            }
        }

        protected void adjustRowBy(int n, int n2) {
            FHTreeStateNode fHTreeStateNode;
            if (this.isExpanded) {
                for (int i = this.getChildCount() - 1; i >= n2; --i) {
                    ((FHTreeStateNode)this.getChildAt(i)).adjustRowBy(n);
                }
            }
            if ((fHTreeStateNode = (FHTreeStateNode)this.getParent()) != null) {
                fHTreeStateNode.adjustRowBy(n, fHTreeStateNode.getIndex(this) + 1);
            }
        }

        protected void didExpand() {
            int n = this.setRowAndChildren(this.row);
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            int n2 = n - this.row - 1;
            if (fHTreeStateNode != null) {
                fHTreeStateNode.adjustRowBy(n2, fHTreeStateNode.getIndex(this) + 1);
            }
            FixedHeightLayoutCache.this.adjustRowCountBy(n2);
        }

        protected int setRowAndChildren(int n) {
            this.row = n;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int n2 = this.row + 1;
            int n3 = 0;
            int n4 = this.getChildCount();
            for (int i = 0; i < n4; ++i) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                n2 += fHTreeStateNode.childIndex - n3;
                n3 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n2 = fHTreeStateNode.setRowAndChildren(n2);
                    continue;
                }
                fHTreeStateNode.row = n2++;
            }
            return n2 + this.childCount - n3;
        }

        protected void resetChildrenRowsFrom(int n, int n2, int n3) {
            FHTreeStateNode fHTreeStateNode;
            int n4 = n;
            int n5 = n3;
            int n6 = this.getChildCount();
            for (int i = n2; i < n6; ++i) {
                fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                n4 += fHTreeStateNode.childIndex - n5;
                n5 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n4 = fHTreeStateNode.setRowAndChildren(n4);
                    continue;
                }
                fHTreeStateNode.row = n4++;
            }
            n4 += this.childCount - n5;
            fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.resetChildrenRowsFrom(n4, fHTreeStateNode.getIndex(this) + 1, this.childIndex + 1);
            } else {
                FixedHeightLayoutCache.this.rowCount = n4;
            }
        }

        protected void makeVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
        }

        protected void expandParentAndReceiver() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand() {
            if (!this.isExpanded && !this.isLeaf()) {
                boolean bl = this.isVisible();
                this.isExpanded = true;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject());
                if (bl) {
                    this.didExpand();
                }
                if (bl && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean bl) {
            if (this.isExpanded) {
                if (this.isVisible() && bl) {
                    int n = this.getTotalChildCount();
                    this.isExpanded = false;
                    FixedHeightLayoutCache.this.adjustRowCountBy(-n);
                    this.adjustRowBy(-n, 0);
                } else {
                    this.isExpanded = false;
                }
                if (bl && this.isVisible() && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        @Override
        public boolean isLeaf() {
            TreeModel treeModel = FixedHeightLayoutCache.this.getModel();
            return treeModel != null ? treeModel.isLeaf(this.getUserObject()) : true;
        }

        protected void addNode(FHTreeStateNode fHTreeStateNode) {
            boolean bl = false;
            int n = fHTreeStateNode.getChildIndex();
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                if (((FHTreeStateNode)this.getChildAt(i)).getChildIndex() <= n) continue;
                bl = true;
                this.insert(fHTreeStateNode, i);
                i = n2;
            }
            if (!bl) {
                this.add(fHTreeStateNode);
            }
        }

        protected void removeChildAtModelIndex(int n, boolean bl) {
            FHTreeStateNode fHTreeStateNode = this.getChildAtModelIndex(n);
            if (fHTreeStateNode != null) {
                int n2 = fHTreeStateNode.getRow();
                int n3 = this.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                this.remove(n3);
                this.adjustChildIndexs(n3, -1);
                --this.childCount;
                if (bl) {
                    this.resetChildrenRowsFrom(n2, n3, n);
                }
            } else {
                int n4 = this.getChildCount();
                for (int i = 0; i < n4; ++i) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(i);
                    if (fHTreeStateNode2.childIndex < n) continue;
                    if (bl) {
                        this.adjustRowBy(-1, i);
                        FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                    }
                    while (i < n4) {
                        --((FHTreeStateNode)this.getChildAt((int)i)).childIndex;
                        ++i;
                    }
                    --this.childCount;
                    return;
                }
                if (bl) {
                    this.adjustRowBy(-1, n4);
                    FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                }
                --this.childCount;
            }
        }

        protected void adjustChildIndexs(int n, int n2) {
            int n3 = this.getChildCount();
            for (int i = n; i < n3; ++i) {
                ((FHTreeStateNode)this.getChildAt((int)i)).childIndex += n2;
            }
        }

        protected void childInsertedAtModelIndex(int n, boolean bl) {
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                if (fHTreeStateNode.childIndex < n) continue;
                if (bl) {
                    this.adjustRowBy(1, i);
                    FixedHeightLayoutCache.this.adjustRowCountBy(1);
                }
                while (i < n2) {
                    ++((FHTreeStateNode)this.getChildAt((int)i)).childIndex;
                    ++i;
                }
                ++this.childCount;
                return;
            }
            if (bl) {
                this.adjustRowBy(1, n2);
                FixedHeightLayoutCache.this.adjustRowCountBy(1);
            }
            ++this.childCount;
        }

        protected boolean getPathForRow(int n, int n2, SearchInfo searchInfo) {
            int n3;
            if (this.row == n) {
                searchInfo.node = this;
                searchInfo.isNodeParentNode = false;
                searchInfo.childIndex = this.childIndex;
                return true;
            }
            FHTreeStateNode fHTreeStateNode = null;
            int n4 = this.getChildCount();
            for (n3 = 0; n3 < n4; ++n3) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode2.row > n) {
                    if (n3 == 0) {
                        searchInfo.node = this;
                        searchInfo.isNodeParentNode = true;
                        searchInfo.childIndex = n - this.row - 1;
                        return true;
                    }
                    int n5 = 1 + fHTreeStateNode2.row - (fHTreeStateNode2.childIndex - fHTreeStateNode.childIndex);
                    if (n < n5) {
                        return fHTreeStateNode.getPathForRow(n, n5, searchInfo);
                    }
                    searchInfo.node = this;
                    searchInfo.isNodeParentNode = true;
                    searchInfo.childIndex = n - n5 + fHTreeStateNode.childIndex + 1;
                    return true;
                }
                fHTreeStateNode = fHTreeStateNode2;
            }
            if (fHTreeStateNode != null) {
                n3 = n2 - (this.childCount - fHTreeStateNode.childIndex) + 1;
                if (n < n3) {
                    return fHTreeStateNode.getPathForRow(n, n3, searchInfo);
                }
                searchInfo.node = this;
                searchInfo.isNodeParentNode = true;
                searchInfo.childIndex = n - n3 + fHTreeStateNode.childIndex + 1;
                return true;
            }
            n3 = n - this.row - 1;
            if (n3 >= this.childCount) {
                return false;
            }
            searchInfo.node = this;
            searchInfo.isNodeParentNode = true;
            searchInfo.childIndex = n3;
            return true;
        }

        protected int getCountTo(int n) {
            int n2 = n + 1;
            int n3 = this.getChildCount();
            for (int i = 0; i < n3; ++i) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                if (fHTreeStateNode.childIndex >= n) {
                    i = n3;
                    continue;
                }
                n2 += fHTreeStateNode.getTotalChildCount();
            }
            if (this.parent != null) {
                return n2 + ((FHTreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!FixedHeightLayoutCache.this.isRootVisible()) {
                return n2 - 1;
            }
            return n2;
        }

        protected int getNumExpandedChildrenTo(int n) {
            int n2 = n;
            int n3 = this.getChildCount();
            for (int i = 0; i < n3; ++i) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i);
                if (fHTreeStateNode.childIndex >= n) {
                    return n2;
                }
                n2 += fHTreeStateNode.getTotalChildCount();
            }
            return n2;
        }

        protected void didAdjustTree() {
        }
    }
}

