/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;

public class Broken11ClassFixer {
    private byte[] src;
    private int srcPos;
    private byte[] dest;
    private int destPos;
    private int numConstantPoolEntries;
    private boolean detectedBogusLocalVariableNameIndex;
    private static final int CODE_MASK = 1;
    private static final int LOCAL_VARIABLE_TABLE_MASK = 2;
    private byte[] constantPoolUtf8Entries;
    private static final int CONSTANT_CLASS_TAG = 7;
    private static final int CONSTANT_FIELD_REF_TAG = 9;
    private static final int CONSTANT_METHOD_REF_TAG = 10;
    private static final int CONSTANT_INTERFACE_METHOD_REF_TAG = 11;
    private static final int CONSTANT_STRING_TAG = 8;
    private static final int CONSTANT_INTEGER_TAG = 3;
    private static final int CONSTANT_FLOAT_TAG = 4;
    private static final int CONSTANT_LONG_TAG = 5;
    private static final int CONSTANT_DOUBLE_TAG = 6;
    private static final int CONSTANT_NAME_AND_TYPE_TAG = 12;
    private static final int CONSTANT_UTF8_TAG = 1;

    public void process(byte[] byArray, int n, int n2) throws Exception {
        this.init(byArray, n, n2);
        this.copyHeader();
        this.scanAndCopyConstantPool();
        this.copyAccessFlagsAndClassInformation();
        this.copyInterfaces();
        this.scanAndCopyFields();
        this.scanAndCopyMethods();
        this.copyAttributes();
    }

    public byte[] getProcessedData() {
        return this.dest;
    }

    public int getProcessedDataOffset() {
        return 0;
    }

    public int getProcessedDataLength() {
        return this.destPos;
    }

    private void init(byte[] byArray, int n, int n2) {
        this.src = byArray;
        this.srcPos = n;
        this.dest = new byte[n2];
        this.destPos = 0;
        this.detectedBogusLocalVariableNameIndex = false;
    }

    private int srcPos() {
        return this.srcPos;
    }

    private int destPos() {
        return this.destPos;
    }

    private int readByte() {
        return this.src[this.srcPos++] & 0xFF;
    }

    private int readShort() {
        int n = this.readByte();
        int n2 = this.readByte();
        return n << 8 | n2;
    }

    private int readInt() {
        int n = this.readShort();
        int n2 = this.readShort();
        return n << 16 | n2;
    }

    private void writeByte(int n) {
        this.dest[this.destPos++] = (byte)n;
    }

    private void writeShort(int n) {
        this.writeByte(n >> 8);
        this.writeByte(n);
    }

    private void writeInt(int n) {
        this.writeShort(n >> 16);
        this.writeShort(n);
    }

    private void writeByteAt(int n, int n2) {
        this.dest[n] = (byte)n2;
    }

    private void writeShortAt(int n, int n2) {
        this.writeByteAt(n, n2 >> 8);
        this.writeByteAt(n + 1, n2);
    }

    private void writeIntAt(int n, int n2) {
        this.writeShortAt(n, n2 >> 16);
        this.writeShortAt(n + 2, n2);
    }

    private void copy(int n) {
        for (int i = 0; i < n; ++i) {
            this.dest[this.destPos + i] = this.src[this.srcPos + i];
        }
        this.srcPos += n;
        this.destPos += n;
    }

    private int copyByte() {
        int n = this.readByte();
        this.writeByte(n);
        return n;
    }

    private int copyShort() {
        int n = this.readShort();
        this.writeShort(n);
        return n;
    }

    private int copyInt() {
        int n = this.readInt();
        this.writeInt(n);
        return n;
    }

    private void copyHeader() {
        this.copy(8);
    }

    private void scanAndCopyConstantPool() {
        this.numConstantPoolEntries = this.copyShort() - 1;
        this.constantPoolUtf8Entries = new byte[this.numConstantPoolEntries];
        block6: for (int i = 0; i < this.numConstantPoolEntries; ++i) {
            int n = this.copyByte();
            switch (n) {
                case 7: 
                case 8: {
                    this.copy(2);
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.copy(4);
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i;
                    continue block6;
                }
                case 1: {
                    this.scanAndCopyUtf8(i);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Invalid constant pool tag " + n);
                }
            }
        }
    }

    private void scanAndCopyUtf8(int n) {
        int n2 = this.copyShort();
        String string = "Code";
        String string2 = "LocalVariableTable";
        if (n2 == string.length()) {
            if (this.copyUtf8LookingFor(string)) {
                this.markCodeInCP(n);
            }
        } else if (n2 == string2.length()) {
            if (this.copyUtf8LookingFor(string2)) {
                this.markLocalVariableTableInCP(n);
            }
        } else {
            this.copy(n2);
        }
    }

    private boolean copyUtf8LookingFor(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = this.copyByte();
            if (n2 == (string.charAt(i) & 0xFF)) continue;
            this.copy(n - i - 1);
            return false;
        }
        return true;
    }

    private void markCodeInCP(int n) {
        int n2 = n;
        this.constantPoolUtf8Entries[n2] = (byte)(this.constantPoolUtf8Entries[n2] | 1);
    }

    private void markLocalVariableTableInCP(int n) {
        int n2 = n;
        this.constantPoolUtf8Entries[n2] = (byte)(this.constantPoolUtf8Entries[n2] | 2);
    }

    private void copyAccessFlagsAndClassInformation() {
        this.copy(6);
    }

    private void copyInterfaces() {
        int n = this.copyShort();
        this.copy(2 * n);
    }

    private void scanAndCopyFields() {
        int n = this.copyShort();
        for (int i = 0; i < n; ++i) {
            this.scanAndCopyAccessFlags();
            this.copy(4);
            this.copyAttributes();
        }
    }

    private void scanAndCopyAccessFlags() {
        int n = this.readShort();
        n = Modifier.isPublic(n) ? (n &= 0xFFFFFFF9) : (Modifier.isProtected(n) ? (n &= 0xFFFFFFFC) : (n &= 0xFFFFFFFA));
        if (Modifier.isAbstract(n)) {
            n &= 0xFFFFF6C5;
        }
        this.writeShort(n);
    }

    private boolean cpIdxIsLocalVariableTable(int n) {
        return (this.constantPoolUtf8Entries[n - 1] & 2) != 0;
    }

    private boolean cpIdxIsCode(int n) {
        return (this.constantPoolUtf8Entries[n - 1] & 1) != 0;
    }

    private boolean isValidConstantPoolIndex(int n) {
        return n > 0 && n <= this.numConstantPoolEntries;
    }

    private boolean isValidStartAndLength(int n, int n2, int n3) {
        return n >= 0 && n + n2 <= n3;
    }

    private void copyAttributes() {
        int n = this.copyShort();
        for (int i = 0; i < n; ++i) {
            this.copyAttribute();
        }
    }

    private void copyAttribute() {
        this.copy(2);
        this.copyRestOfAttribute();
    }

    private void copyRestOfAttribute() {
        this.copy(this.copyInt());
    }

    private void scanAndCopyMethods() {
        int n = this.copyShort();
        for (int i = 0; i < n; ++i) {
            this.scanAndCopyAccessFlags();
            this.copy(4);
            int n2 = this.copyShort();
            for (int j = 0; j < n2; ++j) {
                int n3 = this.copyShort();
                if (this.cpIdxIsCode(n3)) {
                    this.processCodeAttribute();
                    continue;
                }
                this.copyRestOfAttribute();
            }
        }
    }

    private void processCodeAttribute() {
        int n = this.destPos();
        int n2 = this.copyInt();
        this.copy(4);
        int n3 = this.copyInt();
        this.copy(n3);
        this.copy(8 * this.copyShort());
        int n4 = this.copyShort();
        for (int i = 0; i < n4; ++i) {
            int n5 = this.copyShort();
            if (this.cpIdxIsLocalVariableTable(n5)) {
                this.processLocalVariableTableAttribute(n, n2, n3);
                continue;
            }
            this.copyRestOfAttribute();
        }
    }

    private void processLocalVariableTableAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = this.destPos();
        int n6 = this.copyInt();
        int n7 = this.destPos();
        int n8 = n4 = this.copyShort();
        for (int i = 0; i < n4; ++i) {
            int n9 = this.readShort();
            int n10 = this.readShort();
            int n11 = this.readShort();
            int n12 = this.readShort();
            int n13 = this.readShort();
            if (this.isValidConstantPoolIndex(n11) && this.isValidStartAndLength(n9, n10, n3)) {
                this.writeShort(n9);
                this.writeShort(n10);
                this.writeShort(n11);
                this.writeShort(n12);
                this.writeShort(n13);
                continue;
            }
            this.writeIntAt(n, n2 -= 10);
            this.writeIntAt(n5, n6 -= 10);
            this.writeShortAt(n7, --n8);
            this.detectedBogusLocalVariableNameIndex = true;
        }
    }

    private static void usage() {
        System.err.println("Usage: java Broken11ClassFixer [filename]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Broken11ClassFixer.usage();
        }
        try {
            File file = new File(stringArray[0]);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            for (int i = 0; i < byArray.length; i += bufferedInputStream.read(byArray, i, byArray.length - i)) {
            }
            Broken11ClassFixer broken11ClassFixer = new Broken11ClassFixer();
            broken11ClassFixer.process(byArray, 0, byArray.length);
            if (broken11ClassFixer.detectedBogusLocalVariableNameIndex) {
                System.err.println("Detected bogus local variable name index");
            }
            if (broken11ClassFixer.srcPos < byArray.length) {
                System.err.println("Detected extra bytes at the end of the class file");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

