/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.doc.barcode.renderer.DcfQrCodeRenderer;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.dao.Wbs1CouponDetailDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1CouponHeaderDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1CouponDetail;
import jp.co.extreme.module.wbs1.model.Wbs1CouponHeader;
import jp.co.extreme.module.wbs1.server.Wbs1CouponServerUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.util.HttpJacksonUtil;

public class Wbs1CouponWCB
extends Wbs1AbstractWCB {
    public void getCoupon(HtsvArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        Wbs1Account loginAccount = XwebUtil.getLoginAccount(wcbArg, true);
        JsonNode jsonNode = HttpJacksonUtil.getJsonNode(wcbArg.getRequest());
        String code1 = jsonNode.get("code1").asText();
        BcLogUtil.debug("code1=" + code1);
        Wbs1CouponDetail couponDetail = null;
        Throwable throwable = null;
        Object var8_10 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            couponDetail = Wbs1CouponServerUtil.getInstance().createCoupon(dtsSession, code1, loginAccount.personId);
            dtsSession.commit();
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("couponCode", String.valueOf(couponDetail.code1) + couponDetail.code2);
            String jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(resMap);
            WbfwUtil.outputHtml(wcbArg, jsonStr);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void couponShow(HtsvArgument wcbArg) throws Exception {
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        String couponCode = requestParameter.getAsString("couponCode");
        BcLogUtil.debug("couponCode=" + couponCode);
        String[] codes = Wbs1CouponServerUtil.getInstance().parseCode(couponCode);
        BcLogUtil.debug("codes[0]=" + codes[0] + " codes[1]=" + codes[1]);
        Wbs1CouponHeader couponHeader = null;
        Wbs1CouponDetail couponDetail = null;
        Throwable throwable = null;
        Object var8_10 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            couponDetail = (Wbs1CouponDetail)Wbs1CouponDetailDAO.getInstance().getByCode(dtsSession, codes[0], codes[1]);
            if (couponDetail != null) {
                couponHeader = (Wbs1CouponHeader)Wbs1CouponHeaderDAO.getInstance().getByCode1(dtsSession, couponDetail.code1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().center_start());
        sb.append(this.getHtmlBuilder().div_start(""));
        sb.append((CharSequence)this.getHtmlBuilder().span_start(null));
        sb.append(this.getHtmlBuilder().h(2, couponHeader.name));
        sb.append(this.getHtmlBuilder().span_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(""));
        String param1 = WbfwUtil.createParameter("couponCode", (Object)couponCode);
        String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.couponImage)) + WbfwUtil.createUrlQuery(param1);
        sb.append(this.getHtmlBuilder().image(href, "coupon"));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(""));
        sb.append((CharSequence)this.getHtmlBuilder().span_start(null));
        sb.append("\u30af\u30fc\u30dd\u30f3\u30b3\u30fc\u30c9: " + couponCode);
        sb.append(this.getHtmlBuilder().span_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().center_end());
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, "\u30af\u30fc\u30dd\u30f3:" + couponCode, null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void couponImage(HtsvArgument wcbArg) throws Exception {
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        String couponCode = requestParameter.getAsString("couponCode");
        BcLogUtil.debug("couponCode=" + couponCode);
        String[] codes = Wbs1CouponServerUtil.getInstance().parseCode(couponCode);
        BcLogUtil.debug("codes[0]=" + codes[0] + " codes[1]=" + codes[1]);
        Wbs1CouponDetail couponDetail = null;
        Throwable throwable = null;
        Object var7_9 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            couponDetail = (Wbs1CouponDetail)Wbs1CouponDetailDAO.getInstance().getByCode(dtsSession, codes[0], codes[1]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DcfQrCodeRenderer qrCodeRenderer = new DcfQrCodeRenderer();
        qrCodeRenderer.setWidth(240);
        qrCodeRenderer.setHeight(240);
        qrCodeRenderer.setBarcodeValue(String.valueOf(couponDetail.code1) + couponDetail.code2);
        BufferedImage bufferedImage = qrCodeRenderer.getImage();
        ServletOutputStream os = wcbArg.getResponse().getOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)os);
    }

    public static enum Method implements WbxPath
    {
        getCoupon(null),
        couponShow(null),
        couponImage(null);

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1CouponWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

