/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.KnownOIDs;

public final class ObjectIdentifier
implements Serializable {
    private static final int MAXIMUM_OID_SIZE = 4096;
    private byte[] encoding = null;
    private volatile transient String stringForm;
    private static final long serialVersionUID = 8697030238860181294L;
    private Object components = null;
    private int componentLen = -1;
    private transient boolean componentsCalculated = false;
    private static ConcurrentHashMap<String, ObjectIdentifier> oidTable = new ConcurrentHashMap();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encoding == null) {
            if (this.components == null) {
                throw new InvalidObjectException("OID components is null");
            }
            int[] nArray = (int[])((int[])this.components).clone();
            if (this.componentLen > nArray.length) {
                this.componentLen = nArray.length;
            }
            ObjectIdentifier.checkOidSize(this.componentLen);
            this.init(nArray, this.componentLen);
            this.components = nArray;
        } else {
            this.encoding = (byte[])this.encoding.clone();
            ObjectIdentifier.checkOidSize(this.encoding.length);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.componentsCalculated) {
            int[] nArray = this.toIntArray();
            if (nArray != null) {
                this.components = nArray;
                this.componentLen = nArray.length;
            } else {
                this.components = HugeOidNotSupportedByOldJDK.theOne;
            }
            this.componentsCalculated = true;
        }
        objectOutputStream.defaultWriteObject();
    }

    public ObjectIdentifier(String string) throws IOException {
        int n = 46;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[string.length()];
        int n5 = 0;
        int n6 = 0;
        try {
            String string2 = null;
            do {
                int n7 = 0;
                n3 = string.indexOf(n, n2);
                if (n3 == -1) {
                    string2 = string.substring(n2);
                    n7 = string.length() - n2;
                } else {
                    string2 = string.substring(n2, n3);
                    n7 = n3 - n2;
                }
                if (n7 > 9) {
                    BigInteger bigInteger = new BigInteger(string2);
                    if (n6 == 0) {
                        ObjectIdentifier.checkFirstComponent(bigInteger);
                        n5 = bigInteger.intValue();
                    } else {
                        if (n6 == 1) {
                            ObjectIdentifier.checkSecondComponent(n5, bigInteger);
                            bigInteger = bigInteger.add(BigInteger.valueOf(40 * n5));
                        } else {
                            ObjectIdentifier.checkOtherComponent(n6, bigInteger);
                        }
                        n4 += ObjectIdentifier.pack7Oid(bigInteger, byArray, n4);
                    }
                } else {
                    int n8 = Integer.parseInt(string2);
                    if (n6 == 0) {
                        ObjectIdentifier.checkFirstComponent(n8);
                        n5 = n8;
                    } else {
                        if (n6 == 1) {
                            ObjectIdentifier.checkSecondComponent(n5, n8);
                            n8 += 40 * n5;
                        } else {
                            ObjectIdentifier.checkOtherComponent(n6, n8);
                        }
                        n4 += ObjectIdentifier.pack7Oid(n8, byArray, n4);
                    }
                }
                n2 = n3 + 1;
                ++n6;
                ObjectIdentifier.checkOidSize(n4);
            } while (n3 != -1);
            ObjectIdentifier.checkCount(n6);
            this.encoding = new byte[n4];
            System.arraycopy(byArray, 0, this.encoding, 0, n4);
            this.stringForm = string;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("ObjectIdentifier() -- Invalid format: " + exception.toString(), exception);
        }
    }

    public ObjectIdentifier(int[] nArray) throws IOException {
        ObjectIdentifier.checkCount(nArray.length);
        ObjectIdentifier.checkFirstComponent(nArray[0]);
        ObjectIdentifier.checkSecondComponent(nArray[0], nArray[1]);
        for (int i = 2; i < nArray.length; ++i) {
            ObjectIdentifier.checkOtherComponent(i, nArray[i]);
        }
        this.init(nArray, nArray.length);
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.getByte();
        if (by != 6) {
            throw new IOException("ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n = derInputStream.getDefiniteLength();
        ObjectIdentifier.checkOidSize(n);
        if (n > derInputStream.available()) {
            throw new IOException("ObjectIdentifier length exceeds data available.  Length: " + n + ", Available: " + derInputStream.available());
        }
        this.encoding = new byte[n];
        derInputStream.getBytes(this.encoding);
        ObjectIdentifier.check(this.encoding);
    }

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derInputBuffer);
        int n = derInputStream.available();
        ObjectIdentifier.checkOidSize(n);
        this.encoding = new byte[n];
        derInputStream.getBytes(this.encoding);
        ObjectIdentifier.check(this.encoding);
    }

    private void init(int[] nArray, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[n * 5 + 1];
        if (nArray[1] < Integer.MAX_VALUE - nArray[0] * 40) {
            n2 += ObjectIdentifier.pack7Oid(nArray[0] * 40 + nArray[1], byArray, n2);
        } else {
            BigInteger bigInteger = BigInteger.valueOf(nArray[1]);
            bigInteger = bigInteger.add(BigInteger.valueOf(nArray[0] * 40));
            n2 += ObjectIdentifier.pack7Oid(bigInteger, byArray, n2);
        }
        for (int i = 2; i < n; ++i) {
            n2 += ObjectIdentifier.pack7Oid(nArray[i], byArray, n2);
            ObjectIdentifier.checkOidSize(n2);
        }
        this.encoding = new byte[n2];
        System.arraycopy(byArray, 0, this.encoding, 0, n2);
    }

    public static ObjectIdentifier of(String string) throws IOException {
        ObjectIdentifier objectIdentifier = oidTable.get(string);
        if (objectIdentifier == null) {
            objectIdentifier = new ObjectIdentifier(string);
            oidTable.put(string, objectIdentifier);
        }
        return objectIdentifier;
    }

    public static ObjectIdentifier of(KnownOIDs knownOIDs) {
        String string = knownOIDs.value();
        ObjectIdentifier objectIdentifier = oidTable.get(string);
        if (objectIdentifier == null) {
            try {
                objectIdentifier = new ObjectIdentifier(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            oidTable.put(string, objectIdentifier);
        }
        return objectIdentifier;
    }

    public static ObjectIdentifier newInternal(int[] nArray) {
        try {
            return new ObjectIdentifier(nArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write((byte)6, this.encoding);
    }

    @Deprecated
    public boolean equals(ObjectIdentifier objectIdentifier) {
        return this.equals((Object)objectIdentifier);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
        return Arrays.equals(this.encoding, objectIdentifier.encoding);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoding);
    }

    private int[] toIntArray() {
        int n = this.encoding.length;
        int[] nArray = new int[20];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if ((this.encoding[i] & 0x80) == 0) {
                if (i - n3 + 1 > 4) {
                    BigInteger bigInteger = new BigInteger(1, ObjectIdentifier.pack(this.encoding, n3, i - n3 + 1, 7, 8));
                    if (n3 == 0) {
                        nArray[n2++] = 2;
                        BigInteger bigInteger2 = bigInteger.subtract(BigInteger.valueOf(80L));
                        if (bigInteger2.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                            return null;
                        }
                        nArray[n2++] = bigInteger2.intValue();
                    } else {
                        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                            return null;
                        }
                        nArray[n2++] = bigInteger.intValue();
                    }
                } else {
                    int n4 = 0;
                    for (int j = n3; j <= i; ++j) {
                        n4 <<= 7;
                        byte by = this.encoding[j];
                        n4 |= by & 0x7F;
                    }
                    if (n3 == 0) {
                        if (n4 < 80) {
                            nArray[n2++] = n4 / 40;
                            nArray[n2++] = n4 % 40;
                        } else {
                            nArray[n2++] = 2;
                            nArray[n2++] = n4 - 80;
                        }
                    } else {
                        nArray[n2++] = n4;
                    }
                }
                n3 = i + 1;
            }
            if (n2 < nArray.length) continue;
            nArray = Arrays.copyOf(nArray, n2 + 10);
        }
        return Arrays.copyOf(nArray, n2);
    }

    public String toString() {
        String string = this.stringForm;
        if (string == null) {
            int n = this.encoding.length;
            StringBuffer stringBuffer = new StringBuffer(n * 4);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if ((this.encoding[i] & 0x80) != 0) continue;
                if (n2 != 0) {
                    stringBuffer.append('.');
                }
                if (i - n2 + 1 > 4) {
                    BigInteger bigInteger = new BigInteger(1, ObjectIdentifier.pack(this.encoding, n2, i - n2 + 1, 7, 8));
                    if (n2 == 0) {
                        stringBuffer.append("2.");
                        stringBuffer.append(bigInteger.subtract(BigInteger.valueOf(80L)));
                    } else {
                        stringBuffer.append(bigInteger);
                    }
                } else {
                    int n3 = 0;
                    for (int j = n2; j <= i; ++j) {
                        n3 <<= 7;
                        byte by = this.encoding[j];
                        n3 |= by & 0x7F;
                    }
                    if (n2 == 0) {
                        if (n3 < 80) {
                            stringBuffer.append(n3 / 40);
                            stringBuffer.append('.');
                            stringBuffer.append(n3 % 40);
                        } else {
                            stringBuffer.append("2.");
                            stringBuffer.append(n3 - 80);
                        }
                    } else {
                        stringBuffer.append(n3);
                    }
                }
                n2 = i + 1;
            }
            this.stringForm = string = stringBuffer.toString();
        }
        return string;
    }

    private static byte[] pack(byte[] byArray, int n, int n2, int n3, int n4) {
        assert (n3 > 0 && n3 <= 8) : "input NUB must be between 1 and 8";
        assert (n4 > 0 && n4 <= 8) : "output NUB must be between 1 and 8";
        if (n3 == n4) {
            return (byte[])byArray.clone();
        }
        int n5 = n2 * n3;
        byte[] byArray2 = new byte[(n5 + n4 - 1) / n4];
        int n6 = 0;
        int n7 = (n5 + n4 - 1) / n4 * n4 - n5;
        while (n6 < n5) {
            int n8 = n3 - n6 % n3;
            if (n8 > n4 - n7 % n4) {
                n8 = n4 - n7 % n4;
            }
            int n9 = n7 / n4;
            byArray2[n9] = (byte)(byArray2[n9] | (byArray[n + n6 / n3] + 256 >> n3 - n6 % n3 - n8 & (1 << n8) - 1) << n4 - n7 % n4 - n8);
            n6 += n8;
            n7 += n8;
        }
        return byArray2;
    }

    private static int pack7Oid(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = ObjectIdentifier.pack(byArray, n, n2, 8, 7);
        int n4 = byArray3.length - 1;
        int n5 = byArray3.length - 2;
        while (n5 >= 0) {
            if (byArray3[n5] != 0) {
                n4 = n5;
            }
            int n6 = n5--;
            byArray3[n6] = (byte)(byArray3[n6] | 0x80);
        }
        System.arraycopy(byArray3, n4, byArray2, n3, byArray3.length - n4);
        return byArray3.length - n4;
    }

    private static int pack8(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = ObjectIdentifier.pack(byArray, n, n2, 7, 8);
        int n4 = byArray3.length - 1;
        for (int i = byArray3.length - 2; i >= 0; --i) {
            if (byArray3[i] == 0) continue;
            n4 = i;
        }
        System.arraycopy(byArray3, n4, byArray2, n3, byArray3.length - n4);
        return byArray3.length - n4;
    }

    private static int pack7Oid(int n, byte[] byArray, int n2) {
        byte[] byArray2 = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return ObjectIdentifier.pack7Oid(byArray2, 0, 4, byArray, n2);
    }

    private static int pack7Oid(BigInteger bigInteger, byte[] byArray, int n) {
        byte[] byArray2 = bigInteger.toByteArray();
        return ObjectIdentifier.pack7Oid(byArray2, 0, byArray2.length, byArray, n);
    }

    private static void check(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n < 1 || (byArray[n - 1] & 0x80) != 0) {
            throw new IOException("ObjectIdentifier() -- Invalid DER encoding, not ended");
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != -128 || i != 0 && (byArray[i - 1] & 0x80) != 0) continue;
            throw new IOException("ObjectIdentifier() -- Invalid DER encoding, useless extra octet detected");
        }
    }

    private static void checkCount(int n) throws IOException {
        if (n < 2) {
            throw new IOException("ObjectIdentifier() -- Must be at least two oid components ");
        }
    }

    private static void checkFirstComponent(int n) throws IOException {
        if (n < 0 || n > 2) {
            throw new IOException("ObjectIdentifier() -- First oid component is invalid ");
        }
    }

    private static void checkFirstComponent(BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1 || bigInteger.compareTo(BigInteger.valueOf(2L)) == 1) {
            throw new IOException("ObjectIdentifier() -- First oid component is invalid ");
        }
    }

    private static void checkSecondComponent(int n, int n2) throws IOException {
        if (n2 < 0 || n != 2 && n2 > 39) {
            throw new IOException("ObjectIdentifier() -- Second oid component is invalid ");
        }
    }

    private static void checkSecondComponent(int n, BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1 || n != 2 && bigInteger.compareTo(BigInteger.valueOf(39L)) == 1) {
            throw new IOException("ObjectIdentifier() -- Second oid component is invalid ");
        }
    }

    private static void checkOtherComponent(int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IOException("ObjectIdentifier() -- oid component #" + (n + 1) + " must be non-negative ");
        }
    }

    private static void checkOtherComponent(int n, BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1) {
            throw new IOException("ObjectIdentifier() -- oid component #" + (n + 1) + " must be non-negative ");
        }
    }

    private static void checkOidSize(int n) throws IOException {
        if (n < 0) {
            throw new IOException("ObjectIdentifier encoded length was negative: " + n);
        }
        if (n > 4096) {
            throw new IOException("ObjectIdentifier encoded length exceeds the restriction in JDK (OId length(>=): " + n + ", Restriction: " + 4096 + ")");
        }
    }

    static class HugeOidNotSupportedByOldJDK
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static HugeOidNotSupportedByOldJDK theOne = new HugeOidNotSupportedByOldJDK();

        HugeOidNotSupportedByOldJDK() {
        }
    }
}

