/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.time.Instant;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource source, AuthorizationProvider authorizationProvider) {
        result = new Result();
        try {
            lastModified = source.getLastModified();
            connection = (HttpURLConnection)UrlConnectionFactory.createConnection(source.getURI().toURL(), lastModified, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
            connection.connect();
            try {
                code = connection.getResponseCode();
                switch (code) {
                    case 304: {
                        HttpInputStreamUtil.LOGGER.debug("{} resource {}: not modified since {}", new Supplier[]{HttpInputStreamUtil.formatProtocol(source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$0(org.apache.logging.log4j.core.util.internal.LastModifiedSource ), ()Ljava/lang/Object;)((LastModifiedSource)source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$1(long ), ()Ljava/lang/Object;)((long)lastModified)});
                        Result.access$0(result, Status.NOT_MODIFIED);
                        var12_7 = result;
                        return var12_7;
                    }
                    case 404: {
                        HttpInputStreamUtil.LOGGER.debug("{} resource {}: not found", new Supplier[]{HttpInputStreamUtil.formatProtocol(source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$2(org.apache.logging.log4j.core.util.internal.LastModifiedSource ), ()Ljava/lang/Object;)((LastModifiedSource)source)});
                        Result.access$0(result, Status.NOT_FOUND);
                        var12_8 = result;
                        return var12_8;
                    }
                    case 200: {
                        var7_10 = null;
                        var8_13 = null;
                        is = connection.getInputStream();
                        try {
                            source.setLastModified(connection.getLastModified());
                            HttpInputStreamUtil.LOGGER.debug("{} resource {}: last modified on {}", new Supplier[]{HttpInputStreamUtil.formatProtocol(source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$3(org.apache.logging.log4j.core.util.internal.LastModifiedSource ), ()Ljava/lang/Object;)((LastModifiedSource)source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$4(java.net.HttpURLConnection ), ()Ljava/lang/Object;)((HttpURLConnection)connection)});
                            Result.access$0(result, Status.SUCCESS);
                            Result.access$1(result, HttpInputStreamUtil.readStream(is));
                            var12_9 = result;
                            if (is == null) ** GOTO lbl69
                        }
                        catch (Throwable var7_11) {
                            try {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw var7_11;
                                }
                                catch (Throwable var8_14) {
                                    if (var7_10 == null) {
                                        var7_10 = var8_14;
                                    } else if (var7_10 != var8_14) {
                                        var7_10.addSuppressed(var8_14);
                                    }
                                    throw var7_10;
                                }
                            }
                            catch (IOException e) {
                                try {
                                    var8_13 = null;
                                    var9_17 = null;
                                    try {
                                        es = connection.getErrorStream();
                                        try {
                                            if (HttpInputStreamUtil.LOGGER.isDebugEnabled()) {
                                                HttpInputStreamUtil.LOGGER.debug("Error accessing {} resource at {}: {}", (Object)HttpInputStreamUtil.formatProtocol(source).get(), (Object)source, (Object)HttpInputStreamUtil.readStream(es), (Object)e);
                                            }
                                        }
                                        finally {
                                            if (es != null) {
                                                es.close();
                                            }
                                        }
                                    }
                                    catch (Throwable var9_18) {
                                        if (var8_13 == null) {
                                            var8_13 = var9_18;
                                        } else if (var8_13 != var9_18) {
                                            var8_13.addSuppressed(var9_18);
                                        }
                                        throw var8_13;
                                    }
                                }
                                catch (IOException ioe) {
                                    HttpInputStreamUtil.LOGGER.debug("Error accessing {} resource at {}", new Supplier[]{HttpInputStreamUtil.formatProtocol(source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$5(org.apache.logging.log4j.core.util.internal.LastModifiedSource ), ()Ljava/lang/Object;)((LastModifiedSource)source), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$6(java.io.IOException ), ()Ljava/lang/Object;)((IOException)e)});
                                }
                                throw new ConfigurationException("Unable to access " + source, e);
                            }
                        }
                        is.close();
lbl69:
                        // 2 sources

                        return var12_9;
                    }
                    case 401: {
                        throw new ConfigurationException("Authentication required for " + source);
                    }
                    case 403: {
                        throw new ConfigurationException("Access denied to " + source);
                    }
                }
                if (code < 0) {
                    HttpInputStreamUtil.LOGGER.debug("{} resource {}: invalid response code", (Object)HttpInputStreamUtil.formatProtocol(source), (Object)source);
                } else {
                    HttpInputStreamUtil.LOGGER.debug("{} resource {}: unexpected response code {}", (Object)HttpInputStreamUtil.formatProtocol(source), (Object)source, (Object)code);
                }
                throw new ConfigurationException("Unable to access " + source);
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            HttpInputStreamUtil.LOGGER.debug("Error accessing {} resource at {}", (Object)HttpInputStreamUtil.formatProtocol(source), (Object)source, (Object)e);
            throw new ConfigurationException("Unable to access " + source, e);
        }
    }

    private static Supplier<String> formatProtocol(Source source) {
        return () -> Strings.toRootUpperCase(source.getURI().getScheme());
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    private static /* synthetic */ Object lambda$0(LastModifiedSource lastModifiedSource) {
        return lastModifiedSource;
    }

    private static /* synthetic */ Object lambda$1(long l) {
        return Instant.ofEpochMilli(l);
    }

    private static /* synthetic */ Object lambda$2(LastModifiedSource lastModifiedSource) {
        return lastModifiedSource;
    }

    private static /* synthetic */ Object lambda$3(LastModifiedSource lastModifiedSource) {
        return lastModifiedSource;
    }

    private static /* synthetic */ Object lambda$4(HttpURLConnection httpURLConnection) {
        return Instant.ofEpochMilli(httpURLConnection.getLastModified());
    }

    private static /* synthetic */ Object lambda$5(LastModifiedSource lastModifiedSource) {
        return lastModifiedSource;
    }

    private static /* synthetic */ Object lambda$6(IOException iOException) {
        return iOException;
    }

    @NullMarked
    public static class Result {
        private byte @Nullable [] bytes = null;
        private Status status;

        public Result() {
            this(Status.ERROR);
        }

        public Result(Status status) {
            this.status = status;
        }

        public @Nullable InputStream getInputStream() {
            return this.bytes != null ? new ByteArrayInputStream(this.bytes) : null;
        }

        public Status getStatus() {
            return this.status;
        }

        static /* synthetic */ void access$0(Result result, Status status) {
            result.status = status;
        }

        static /* synthetic */ void access$1(Result result, byte[] byArray) {
            result.bytes = byArray;
        }
    }
}

