/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.commons.net.nntp.NewsgroupInfo;

public class ArticleReader {
    public static void main(String[] args) throws SocketException, IOException {
        BufferedReader brBody;
        String line;
        BufferedReader brHdr;
        String password;
        String user;
        if (args.length != 2 && args.length != 3 && args.length != 5) {
            System.out.println("Usage: MessageThreading <hostname> <groupname> [<article specifier> [<user> <password>]]");
            return;
        }
        String hostname = args[0];
        String newsgroup = args[1];
        String articleSpec = args.length >= 3 ? args[2] : null;
        NNTPClient client = new NNTPClient();
        client.addProtocolCommandListener(new PrintCommandListener(Util.newPrintWriter(System.out), true));
        client.connect(hostname);
        if (args.length == 5 && !client.authenticate(user = args[3], password = args[4])) {
            System.out.println("Authentication failed for user " + user + "!");
            System.exit(1);
        }
        NewsgroupInfo group = new NewsgroupInfo();
        client.selectNewsgroup(newsgroup, group);
        if (articleSpec != null) {
            brHdr = (BufferedReader)client.retrieveArticleHeader(articleSpec);
        } else {
            long articleNum = group.getLastArticleLong();
            brHdr = client.retrieveArticleHeader(articleNum);
        }
        if (brHdr != null) {
            while ((line = brHdr.readLine()) != null) {
                System.out.println(line);
            }
            brHdr.close();
        }
        if (articleSpec != null) {
            brBody = (BufferedReader)client.retrieveArticleBody(articleSpec);
        } else {
            long articleNum = group.getLastArticleLong();
            brBody = client.retrieveArticleBody(articleNum);
        }
        if (brBody != null) {
            while ((line = brBody.readLine()) != null) {
                System.out.println(line);
            }
            brBody.close();
        }
    }
}

