/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.stream.Streams;

public class CharSetUtils {
    public static boolean containsAny(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return false;
        }
        CharSet chars = CharSet.getInstance(set);
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (chars.contains(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int count(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set);
        int count = 0;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (chars.contains(c)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private static boolean deepEmpty(String[] strings) {
        return Streams.of(strings).allMatch(StringUtils::isEmpty);
    }

    public static String delete(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        return CharSetUtils.modify(str, set, false);
    }

    public static String keep(String str, String ... set) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set)) {
            return "";
        }
        return CharSetUtils.modify(str, set, true);
    }

    private static String modify(String str, String[] set, boolean expect) {
        char[] chrs;
        CharSet chars = CharSet.getInstance(set);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] cArray = chrs = str.toCharArray();
        int n = chrs.length;
        int n2 = 0;
        while (n2 < n) {
            char chr = cArray[n2];
            if (chars.contains(chr) == expect) {
                buffer.append(chr);
            }
            ++n2;
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String squeeze(String str, String ... set) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        chars = CharSet.getInstance(set);
        buffer = new StringBuilder(str.length());
        chrs = str.toCharArray();
        sz = chrs.length;
        lastChar = chrs[0];
        inChars = null;
        notInChars = null;
        buffer.append(lastChar);
        i = 1;
        while (i < sz) {
            block4: {
                ch = chrs[i];
                if (ch != lastChar) ** GOTO lbl22
                if (inChars != null && ch == inChars.charValue()) break block4;
                if (notInChars != null && ch == notInChars.charValue()) ** GOTO lbl22
                if (chars.contains(ch)) {
                    inChars = Character.valueOf(ch);
                } else {
                    notInChars = Character.valueOf(ch);
lbl22:
                    // 3 sources

                    buffer.append(ch);
                    lastChar = ch;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    @Deprecated
    public CharSetUtils() {
    }
}

