/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.dao;

import java.sql.Timestamp;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.common.OrmConstants;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.orm.entity.OrmGeneralData;
import jp.co.extreme.orm.persistence.OrmPersistenceAddition;
import jp.co.extreme.orm.persistence.OrmPersistenceUtil;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSetClause;
import jp.co.extreme.sql.model.SqlUpdateQuery;

public class KscfGeneralDataDAO
extends OrmAbstractDAO {
    protected String lineSep = String.valueOf(BcStringUtil.CARRIAGE_RETURN_STR) + BcStringUtil.LINE_FEED_STR;

    private KscfGeneralDataDAO() {
        super(new Object[0]);
    }

    public static KscfGeneralDataDAO getInstance() {
        return SingletonHolder.instance;
    }

    public String createInsertQuery(DtsSession dtsSession, MmdModel mmdModel, OrmGeneralData generalData) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlUpdateQuery updateQuery = new SqlUpdateQuery();
        updateQuery.tableName = mmdModel.tableName;
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            Object value = generalData.getValue(i);
            SqlSetClause setClause = new SqlSetClause(mmdField.columnName, value);
            updateQuery.addSetClause(setClause);
            ++i;
        }
        return sqlContext.buildInsertQuery(updateQuery);
    }

    public int insert(DtsSession dtsSession, MmdModel mmdModel, OrmGeneralData generalData) throws Exception {
        String query = this.createInsertQuery(dtsSession, mmdModel, generalData);
        BcLogUtil.debug("query=" + query);
        int cnt = SqlUtil.executeUpdate(dtsSession.getConnection(), query);
        return cnt;
    }

    public void update(DtsSession dtsSession, Object entity) throws Exception {
    }

    public void generalDataTransaction(DtsSession dtsSession, MmdModel mmdModel, Object entity) throws Exception {
        SqlUpdateQuery updateQuery = new SqlUpdateQuery();
        updateQuery.tableName = mmdModel.tableName;
        if (entity instanceof OrmGeneralData) {
            OrmGeneralData generalData = (OrmGeneralData)entity;
            this.generalDataTransaction2(dtsSession, generalData);
        } else {
            this.getPersistenceProxy().createCommonSetPhrase(updateQuery, entity);
            int i = 0;
            while (i < mmdModel.getFieldCount()) {
                MmdField mmdField = mmdModel.getField(i);
                if (!OrmConstants.isSystemColumn(mmdField.columnName)) {
                    Object valueObject = MmdUtil.getValue(mmdField, entity);
                    updateQuery.addSetClause(new SqlSetClause(mmdField.columnName, valueObject));
                }
                ++i;
            }
        }
    }

    public void generalDataTransaction2(DtsSession dtsSession, OrmGeneralData generalData) throws Exception {
        Number dataId;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlUpdateQuery updateQuery = new SqlUpdateQuery();
        updateQuery.tableName = generalData.getModel().tableName;
        String dataName = MmdUtil.createTableColumnName(generalData.getModel().tableName, "sy_oid");
        Number oid = (Number)generalData.getValue("sy_oid");
        int newOid = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, dataName);
        OrmPersistenceUtil.insertNewRecord(dtsSession, generalData.getModel().tableName, "sy_oid", newOid);
        OrmPersistenceAddition.updateNextObjectId(dtsSession, generalData.getModel().tableName, oid.intValue(), newOid);
        generalData.setValue("sy_oid", (Object)newOid);
        generalData.setValue("sy_noid", (Object)-1);
        generalData.setValue("sy_timestamp", (Object)new Timestamp(BcTimeUtil.createCalendar().getTimeInMillis()));
        if (generalData.getModel().getFieldByColumnName("id") != null && (dataId = (Number)generalData.getValue("id")).intValue() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(generalData.getModel().tableName, "id"));
            generalData.setValue("id", (Object)newDataId);
        }
        this.getPersistenceProxy().createCommonSetPhrase(updateQuery, (Object)generalData);
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (!OrmConstants.isSystemColumn(mmdField.columnName)) {
                updateQuery.addSetClause(new SqlSetClause(mmdField.columnName, valueObject));
            }
            ++i;
        }
        this.getPersistenceProxy().createWhereClause(generalData, updateQuery);
        String query = sqlContext.buildUpdateQuery(updateQuery);
        BcLogUtil.debug("query=" + query);
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            stmt.executeUpdate(query);
        }
    }

    public static String toWhere(String operator, MmdModel mmdModel, MmdField mmdField, OrmGeneralData generalData) throws Exception {
        Object value = KscfGeneralDataDAO.getValueObject(mmdModel, mmdField, generalData);
        return SqlUtil.toWhere(operator, value, mmdField.sqlTypeId);
    }

    public static Object getValueObject(MmdModel mmdModel, MmdField mmdField, OrmGeneralData generalData) throws Exception {
        int index = mmdModel.getFieldIndexByName(mmdField.fieldName);
        Object value = generalData.getValue(index);
        return value;
    }

    /* synthetic */ KscfGeneralDataDAO(KscfGeneralDataDAO kscfGeneralDataDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final KscfGeneralDataDAO instance = new KscfGeneralDataDAO(null);

        private SingletonHolder() {
        }
    }
}

