/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.SwgUtil;

public class HswgNetworkPropertyPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = 2740601814628674675L;
    protected SwgTextField hostAddressField = new SwgTextField();
    protected SwgTextField hostPortNoField = new SwgTextField();
    protected SwgTextField localPortNoField = new SwgTextField();
    protected Properties netProps;
    protected Window window;

    public HswgNetworkPropertyPanel() throws Exception {
        this.setBorderSize(16, 58, 0, 0);
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        this.setDescription("Server \u306e \u30a2\u30c9\u30ec\u30b9\uff08IP \u307e\u305f\u306f DNS \u540d\uff09\u53ca\u3073 \u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002", -1);
        this.initComponent();
    }

    public void init(Properties netProps) throws Exception {
        this.netProps = null;
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 120;
        int c2x = c1x + c1w + colGap;
        int c2w = 200;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel("host server address", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.hostAddressField, (double)c2x, (double)ly, (double)c2w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("host server port no.", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.hostPortNoField, (double)c2x, (double)ly, (double)c2w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("local server port no.", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.localPortNoField, (double)c2x, (double)ly, (double)c2w, (double)rowHeight);
    }

    @Override
    protected void okButtonAction() throws Exception {
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.hostAddressField.getText().length() <= 0) {
            msgList.add("address \u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
        if (this.hostPortNoField.getText().length() <= 0 || this.localPortNoField.getText().length() <= 0) {
            msgList.add("port no. \u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
        int hostPortNo = -1;
        int localPortNo = -1;
        try {
            hostPortNo = BcNumberUtil.parseInteger(this.hostPortNoField.getText());
            localPortNo = BcNumberUtil.parseInteger(this.localPortNoField.getText());
        }
        catch (NumberFormatException ex) {
            msgList.add("port no. \u306f 1 \uff5e 65535 \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        }
        if (hostPortNo < 1 && hostPortNo > 65535 || localPortNo < 1 && localPortNo > 65535) {
            msgList.add("port no. \u306f 1 \uff5e 65535 \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        }
        if (msgList.size() > 0) {
            JOptionPane.showMessageDialog(this, SwgUtil.createMessageComponent(null, msgList), BcWords.getInstance().warning, 2);
            return;
        }
        try {
            this.netProps = new Properties();
            this.close();
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public Properties showAsDialog(Properties netProps, Component ownerCompo) throws Exception {
        this.init(netProps);
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        this.window = dialog;
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                HswgNetworkPropertyPanel.this.hostAddressField.requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    HswgNetworkPropertyPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    HswgNetworkPropertyPanel.this.handleException(ex);
                }
            }
        });
        dialog.setTitle("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306e\u8a2d\u5b9a");
        SwgUtil.setCenter(this.window, 480.0, 260.0);
        this.window.setVisible(true);
        return this.netProps;
    }
}

