/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.connector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.rmi.ServerException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import jp.co.extreme.base.core.BcByteUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.rmi.common.RmiConnectionEventHandler;
import jp.co.extreme.rmi.common.RmiDataRecieveEventHandler;
import jp.co.extreme.rmi.connector.RmiConnector;
import jp.co.extreme.rmi.model.RmiNetConfig;
import jp.co.extreme.rmi.model.RmiPacket;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;

public class RmiNonBlockingConnector
extends BcThread
implements RmiConnector {
    protected RmiConnectionEventHandler rmixConnectionEventListener;
    protected RmiDataRecieveEventHandler rmiRecieveHandler;
    protected SocketChannel socketChannel;
    protected Selector selector;
    protected Queue requestQueue;
    public int SIZE_SIZE = 4;
    protected int sendBufSize = 0x100000;
    protected byte[] sendBytes;
    protected int sendPos;
    protected int readBufSize = 0x100000;
    protected ByteBuffer readBuf;
    protected byte[] recieveSizeBuf = new byte[this.SIZE_SIZE];
    protected int reciveSize;
    protected ByteArrayOutputStream byteArrayOutputStream;
    protected RmiNetConfig netConfig;
    public int TYPE_binary = 1;
    public int TYPE_rmix = 2;
    protected RmiRespons rmiRes2;
    protected Iterator keyIterator;
    protected Set selectedKeys;
    protected SelectionKey selectionKey;

    public RmiNetConfig getNetConfig() {
        return this.netConfig;
    }

    public void setNetConfig(RmiNetConfig netConfig) {
        this.netConfig = netConfig;
    }

    public void connect(SocketChannel socketChannel) throws Exception {
        this.socketChannel = socketChannel;
        socketChannel.configureBlocking(false);
        this.selector = Selector.open();
        SelectionKey selectionKey = socketChannel.register(this.selector, 5);
        this.requestQueue = new ConcurrentLinkedQueue();
        this.readBuf = ByteBuffer.allocate(this.readBufSize);
        this.startThread();
    }

    public void connect(InetSocketAddress inetSocketAddress) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.connect(inetSocketAddress);
        this.connect(socketChannel);
    }

    @Override
    public boolean isOpen() throws Exception {
        if (this.socketChannel != null) {
            return this.socketChannel.isOpen();
        }
        return false;
    }

    @Override
    protected void run2() throws Exception {
        try {
            this.recieve();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.stopThread();
            this.close(this);
        }
    }

    protected void recieve() throws Exception {
        try {
            this.trans2();
        }
        catch (CancelledKeyException ex) {
            BcLogUtil.error(ex);
        }
        catch (SocketException ex) {
            BcLogUtil.error(ex);
            this.stopThread();
            this.close(this);
        }
        catch (IOException ex) {
            BcLogUtil.error(ex);
            this.stopThread();
            this.close(this);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void trans2() throws Exception {
        this.selector.select();
        this.selectedKeys = this.selector.selectedKeys();
        for (SelectionKey this.selectionKey : this.selectedKeys) {
            int len;
            this.keyIterator.remove();
            if (this.selectionKey.isWritable()) {
                if (this.sendBytes == null) {
                    this.sendBytes = (byte[])this.requestQueue.poll();
                }
                if (this.sendBytes != null) {
                    if (this.sendPos <= 0) {
                        byte[] sendSizeBuf = BcByteUtil.toByteArray(this.sendBytes.length, ByteOrder.BIG_ENDIAN);
                        this.socketChannel.write(ByteBuffer.wrap(sendSizeBuf));
                    }
                    int length = Math.min(this.sendBufSize, this.sendBytes.length - this.sendPos);
                    ByteBuffer sendBuf = ByteBuffer.wrap(this.sendBytes, this.sendPos, length);
                    this.sendPos += this.socketChannel.write(sendBuf);
                    if (this.sendPos == this.sendBytes.length) {
                        this.sendBytes = null;
                        this.sendPos = 0;
                    }
                }
            }
            if (!this.selectionKey.isReadable() || (len = this.socketChannel.read(this.readBuf)) <= 0) continue;
            if (this.byteArrayOutputStream == null) {
                this.byteArrayOutputStream = new ByteArrayOutputStream();
                System.arraycopy(this.readBuf.array(), 0, this.recieveSizeBuf, 0, this.SIZE_SIZE);
                this.reciveSize = BcByteUtil.toInt(this.recieveSizeBuf, ByteOrder.BIG_ENDIAN);
                this.byteArrayOutputStream.write(this.readBuf.array(), this.SIZE_SIZE, this.readBuf.position() - this.SIZE_SIZE);
            } else {
                this.byteArrayOutputStream.write(this.readBuf.array(), 0, this.readBuf.position());
            }
            this.readBuf.position(0);
            if (this.byteArrayOutputStream.size() != this.reciveSize) continue;
            this.dataRecieved(this.byteArrayOutputStream.toByteArray());
            this.byteArrayOutputStream = null;
        }
    }

    @Override
    public void close(Object operator) throws Exception {
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            this.socketChannel = null;
        }
        this.selector = null;
        if (this.requestQueue != null) {
            this.requestQueue.clear();
            this.requestQueue = null;
        }
        if (this.rmixConnectionEventListener != null) {
            try {
                this.rmixConnectionEventListener.disconnected(this, operator);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    @Override
    public void setConnectionEventListener(RmiConnectionEventHandler rmixConnectionEventListener) throws Exception {
        this.rmixConnectionEventListener = rmixConnectionEventListener;
    }

    @Override
    public void setDataRecieveEventHandler(RmiDataRecieveEventHandler rmiRecieveHandler) throws Exception {
        this.rmiRecieveHandler = rmiRecieveHandler;
    }

    protected void dataRecieved(byte[] bytes) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object obj = objectInputStream.readObject();
        RmiPacket rmixPacket = (RmiPacket)obj;
        if (rmixPacket.getPacketType() == 11) {
            if (this.rmiRecieveHandler != null) {
                this.rmiRecieveHandler.dataRecieved(rmixPacket);
            }
        } else if (rmixPacket.getPacketType() == 12) {
            RmiRespons rmiRes;
            this.rmiRes2 = rmiRes = (RmiRespons)rmixPacket;
        }
    }

    @Override
    public synchronized RmiRespons sendRequest(RmiRequest rmiReq) throws Exception {
        RmiRespons rmiRes = this.sendRequest2(rmiReq);
        if (rmiRes.getStatusId() == -9) {
            if (rmiRes.getException() != null) {
                throw new ServerException("", rmiRes.getException());
            }
            throw new ServerException("unknown");
        }
        return rmiRes;
    }

    protected RmiRespons sendRequest2(RmiRequest rmiReq) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(rmiReq);
        if (!this.requestQueue.offer(byteArrayOutputStream.toByteArray())) {
            throw new Exception("requestQueue \u3078\u306e\u8ffd\u52a0\u306b\u5931\u6557");
        }
        Thread.sleep(this.netConfig.recieveFirstWaitMillis);
        int retryCnt = 0;
        while (true) {
            if (this.rmiRes2 != null) {
                RmiRespons rmiRes3 = this.rmiRes2;
                this.rmiRes2 = null;
                return rmiRes3;
            }
            if (++retryCnt > this.netConfig.recieveRetryCountMax) {
                throw new Exception("sendRequest2:retryCnt=" + retryCnt);
            }
            Thread.sleep(this.netConfig.recieveRetryIntervalMillis);
        }
    }

    @Override
    public void sendRespons(RmiRespons rmiRes) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(rmiRes);
        if (!this.requestQueue.offer(byteArrayOutputStream.toByteArray())) {
            BcLogUtil.error("requestQueue \u3078\u306e\u8ffd\u52a0\u306b\u5931\u6557");
        }
    }
}

