/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.poi.PoiCellFormatUtil;
import jp.co.extreme.poi.PoiCellRangeAddressPack;
import jp.co.extreme.poi.PoiRichTextSegment;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class PoiWorkbookUtil {
    private PoiWorkbookUtil() {
    }

    public static Workbook createWorkbook(InputStream is) throws Exception {
        try {
            Workbook workbook;
            Workbook workbook2 = workbook = WorkbookFactory.create((InputStream)is);
            return workbook2;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static Workbook createWorkbook(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return PoiWorkbookUtil.createWorkbook(is);
    }

    public static int getColumnSizeMax(Workbook workbook) throws Exception {
        if (PoiWorkbookUtil.is2007(workbook)) {
            return 16384;
        }
        if (PoiWorkbookUtil.is1997(workbook)) {
            return 256;
        }
        String msg = "Not supported workbook. " + workbook.getClass().getName();
        throw new Exception(msg);
    }

    public static int getRowSizeMax(Workbook workbook) throws Exception {
        if (PoiWorkbookUtil.is2007(workbook)) {
            return 0x100000;
        }
        if (PoiWorkbookUtil.is1997(workbook)) {
            return 65536;
        }
        String msg = "Not supported workbook. " + workbook.getClass().getName();
        throw new Exception(msg);
    }

    public static double calcYPoint(Sheet sheet, int rowId) throws Exception {
        double yPoi = 0.0;
        int i = 0;
        while (i < rowId) {
            Row row = sheet.getRow(i);
            if (row != null) {
                yPoi += (double)row.getHeight();
            }
            ++i;
        }
        return yPoi;
    }

    public static double calcXPoint(Sheet sheet, int rowId, int columnId) throws Exception {
        double xPoi = 0.0;
        int i = 0;
        while (i < columnId) {
            xPoi += (double)sheet.getColumnWidth(i);
            ++i;
        }
        return xPoi;
    }

    public static int toColumnIndex(String colmnName) throws Exception {
        return CellReference.convertColStringToIndex((String)colmnName);
    }

    public static String toColumnName(int columnId) throws Exception {
        return CellReference.convertNumToColString((int)columnId);
    }

    public static String getCellName(Cell cell) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(CellReference.convertNumToColString((int)cell.getColumnIndex()));
        sb.append(cell.getRow().getRowNum() + 1);
        return sb.toString();
    }

    public static Cell getCell(Sheet sheet, int rowId, int columnId) throws Exception {
        Row row = sheet.getRow(rowId);
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(columnId);
        return cell;
    }

    public static Row getRowForUpdate(Sheet sheet, int rowId) throws Exception {
        Row row = sheet.getRow(rowId);
        if (row == null) {
            row = sheet.createRow(rowId);
        }
        return row;
    }

    public static Cell getCellForUpdate(Sheet sheet, int rowId, int columnId) throws Exception {
        Row row = PoiWorkbookUtil.getRowForUpdate(sheet, rowId);
        return PoiWorkbookUtil.getCellForUpdate(row, columnId);
    }

    public static Cell getCellForUpdate(Row row, int columnId) throws Exception {
        Cell cell = row.getCell(columnId);
        if (cell == null) {
            cell = row.createCell(columnId);
        }
        return cell;
    }

    public static Cell recreateCell(Cell cell) throws Exception {
        Row row = cell.getRow();
        row.removeCell(cell);
        Cell cell2 = row.createCell(cell.getColumnIndex());
        return cell2;
    }

    public static Cell clearCellValue(Cell cell) throws Exception {
        CellStyle cellStyle = cell.getCellStyle();
        Cell cell2 = PoiWorkbookUtil.recreateCell(cell);
        cell2.setCellStyle(cellStyle);
        return cell2;
    }

    public static Cell setCellValue(Cell cell, Object value) throws Exception {
        if (value == null) {
            return PoiWorkbookUtil.clearCellValue(cell);
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            cell.setCellValue(charSequence.toString());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            throw new Exception("Not Supported. value=" + value);
        }
        return cell;
    }

    public static Cell setCellValue(Sheet sheet, int rowId, int columnId, Object value) throws Exception {
        Cell cell = PoiWorkbookUtil.getCellForUpdate(sheet, rowId, columnId);
        PoiWorkbookUtil.setCellValue(cell, value);
        return cell;
    }

    public static Object getCellValue(Cell cell) throws Exception {
        if (cell == null) {
            return null;
        }
        Object value = null;
        BcLogUtil.debug("cellType=" + cell.getCellType());
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                CellStyle cellStyle = cell.getCellStyle();
                if (DateUtil.isCellDateFormatted((Cell)cell) || PoiCellFormatUtil.contains(cellStyle.getDataFormat())) {
                    Date date = cell.getDateCellValue();
                    BcLogUtil.debug("date=" + date);
                    value = BcTimeUtil.toCalendar(date);
                    break;
                }
                double doubleValue = cell.getNumericCellValue();
                value = new BigDecimal(doubleValue);
                break;
            }
            case BOOLEAN: {
                value = new Boolean(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case ERROR: {
                value = cell.getErrorCellValue();
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                BcLogUtil.warning("Not Supported. cellType=" + cell.getCellType());
            }
        }
        return value;
    }

    public static String getCellValueAsString(Cell cell) throws Exception {
        String value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                CellStyle cellStyle = cell.getCellStyle();
                BcLogUtil.debug("cellStyle.getDataFormat()=" + cellStyle.getDataFormat() + " " + cellStyle.getDataFormatString());
                if (DateUtil.isCellDateFormatted((Cell)cell) || PoiCellFormatUtil.contains(cellStyle.getDataFormat())) {
                    Date date = cell.getDateCellValue();
                    value = PoiCellFormatUtil.formt(date, cellStyle.getDataFormat());
                    break;
                }
                DataFormatter formatter = new DataFormatter();
                value = formatter.formatCellValue(cell);
                break;
            }
            case BOOLEAN: {
                value = BcBooleanUtil.toYesNo(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case ERROR: {
                byte byteValue = cell.getErrorCellValue();
                value = Byte.toString(byteValue);
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                BcLogUtil.warning("Not Supported. cellType=" + cell.getCellType());
            }
        }
        return value;
    }

    public static Calendar getCellValueAsCalendar(Cell cell) throws Exception {
        Calendar calendar = null;
        if (cell.getCellType() == CellType.NUMERIC) {
            CellStyle cellStyle = cell.getCellStyle();
            if (DateUtil.isCellDateFormatted((Cell)cell) || PoiCellFormatUtil.contains(cellStyle.getDataFormat())) {
                Date date = cell.getDateCellValue();
                calendar = BcTimeUtil.toCalendar(date);
            } else {
                DataFormatter formatter = new DataFormatter();
                String str = formatter.formatCellValue(cell);
                calendar = BcTimeUtil.toCalendar(str);
            }
        } else {
            String str = cell.getRichStringCellValue().getString();
            if (!BcStringUtil.isEmpty(str) && (calendar = BcTimeUtil.toCalendar(str)) == null) {
                String msg = "\u30bb\u30eb " + PoiWorkbookUtil.getCellName(cell) + " \u304c\u65e5\u4ed8\u3068\u3057\u3066\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002value='" + str + "'";
                throw new Exception(msg);
            }
        }
        return calendar;
    }

    public static int getCellValueAsYyyyMMdd(Cell cell) throws Exception {
        Calendar calendar = PoiWorkbookUtil.getCellValueAsCalendar(cell);
        int yyyyMMdd = 0;
        if (calendar != null) {
            yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        }
        return yyyyMMdd;
    }

    public static void copyCell(Sheet sheet, Cell cell1, Cell cell2, boolean doStyleClone) throws Exception {
        PoiCellRangeAddressPack cellRangeAddressPack2;
        cell2.setCellType(cell1.getCellType());
        switch (cell1.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                cell2.setCellValue(cell1.getBooleanCellValue());
                break;
            }
            case ERROR: {
                cell2.setCellErrorValue(cell1.getErrorCellValue());
                break;
            }
            case FORMULA: {
                cell2.setCellFormula(cell1.getCellFormula());
                break;
            }
            case NUMERIC: {
                cell2.setCellValue(cell1.getNumericCellValue());
                break;
            }
            case STRING: {
                cell2.setCellValue(cell1.getRichStringCellValue());
                break;
            }
            default: {
                throw new Exception("Not Supported. cellType=" + cell1.getCellType());
            }
        }
        PoiWorkbookUtil.copyCellStyle(sheet, cell1, cell2, doStyleClone);
        PoiCellRangeAddressPack cellRangeAddressPack1 = PoiWorkbookUtil.getCellRangeAddress(sheet, cell1);
        if (cellRangeAddressPack1 != null && (cellRangeAddressPack2 = PoiWorkbookUtil.getCellRangeAddress(sheet, cell2)) == null) {
            int rowGap = cell2.getRowIndex() - cell1.getRowIndex();
            int columnGap = cell2.getColumnIndex() - cell1.getColumnIndex();
            CellRangeAddress cellRangeAddress3 = new CellRangeAddress(cellRangeAddressPack1.cellRangeAddress.getFirstRow() + rowGap, cellRangeAddressPack1.cellRangeAddress.getLastRow() + rowGap, cellRangeAddressPack1.cellRangeAddress.getFirstColumn() + columnGap, cellRangeAddressPack1.cellRangeAddress.getLastColumn() + columnGap);
            sheet.addMergedRegion(cellRangeAddress3);
        }
    }

    public static void copyCell(Sheet sheet, Cell cell1, Cell cell2) throws Exception {
        PoiWorkbookUtil.copyCell(sheet, cell1, cell2, false);
    }

    public static void copyCellStyle(Sheet sheet, Cell cell1, Cell cell2, boolean doClone) throws Exception {
        CellStyle cellStyle = null;
        cellStyle = doClone ? PoiWorkbookUtil.cloneCellStyle(sheet.getWorkbook(), cell1.getCellStyle()) : cell1.getCellStyle();
        cell2.setCellStyle(cellStyle);
    }

    public static CellStyle cloneCellStyle(Workbook workbook, CellStyle cellStyle1) {
        CellStyle cellStyle2 = workbook.createCellStyle();
        cellStyle2.cloneStyleFrom(cellStyle1);
        return cellStyle2;
    }

    public static Row insertRow(Sheet sheet, int rowId) throws Exception {
        Row row = null;
        if (rowId <= sheet.getLastRowNum()) {
            sheet.shiftRows(rowId, sheet.getLastRowNum(), 1);
            row = sheet.createRow(rowId);
        } else {
            row = sheet.createRow(rowId);
        }
        return row;
    }

    public static int removeRow(Sheet sheet, int rowId1, int rowId2) throws Exception {
        int rowIdFrom = Math.min(rowId1, rowId2);
        int rowIdTo = Math.max(rowId1, rowId2);
        int rowCount = rowIdTo - rowIdFrom + 1;
        int i = 0;
        while (i < rowCount) {
            Row row = sheet.getRow(rowIdFrom + i);
            int cellCount = row.getLastCellNum() - row.getFirstCellNum() + 1;
            int j = 0;
            while (j < cellCount) {
                PoiCellRangeAddressPack ellRangeAddressPack;
                int cellNum = row.getFirstCellNum() + j;
                Cell cell = row.getCell(cellNum);
                if (cell != null && (ellRangeAddressPack = PoiWorkbookUtil.getCellRangeAddress(sheet, cell)) != null) {
                    sheet.removeMergedRegion(ellRangeAddressPack.index);
                }
                ++j;
            }
            sheet.removeRow(row);
            ++i;
        }
        if (sheet.getLastRowNum() > rowIdTo) {
            sheet.shiftRows(rowIdTo + 1, sheet.getLastRowNum(), rowCount * -1, true, false);
        }
        return rowCount;
    }

    public static int removeRow(Sheet sheet, int rowId) throws Exception {
        return PoiWorkbookUtil.removeRow(sheet, rowId, rowId);
    }

    public static void copyRow(Sheet sheet, Row row1, Row row2, boolean doStyleClone) throws Exception {
        row2.setHeight(row1.getHeight());
        int i = 0;
        while (i < row1.getLastCellNum()) {
            Cell cell1 = row1.getCell(i);
            if (cell1 != null) {
                Cell cell2 = row2.createCell(cell1.getColumnIndex());
                PoiWorkbookUtil.copyCell(sheet, cell1, cell2, doStyleClone);
            }
            ++i;
        }
    }

    public static void copyRow(Sheet sheet, Row row1, Row row2) throws Exception {
        PoiWorkbookUtil.copyRow(sheet, row1, row2, false);
    }

    public static void copyRowStyle(Sheet sheet, Row row1, Row row2, boolean doStyleClone) throws Exception {
        row2.setHeight(row1.getHeight());
        int i = 0;
        while (i < row1.getLastCellNum()) {
            Cell cell1 = row1.getCell(i);
            if (cell1 != null) {
                Cell cell2 = row2.getCell(i);
                PoiWorkbookUtil.copyCellStyle(sheet, cell1, cell2, doStyleClone);
            }
            ++i;
        }
    }

    public static void copyRowStyle(Sheet sheet, Row row1, Row row2) throws Exception {
        PoiWorkbookUtil.copyRowStyle(sheet, row1, row2, false);
    }

    public static List<Row> copyInsertRow(Sheet sheet, int rowIdFrom1, int rowIdFrom2, int rowIdTo, boolean doStyleClone) throws Exception {
        int rowIdFrom1wk = Math.min(rowIdFrom1, rowIdFrom2);
        int rowIdFrom2wk = Math.max(rowIdFrom1, rowIdFrom2);
        int fromRowCnt = rowIdFrom2wk - rowIdFrom1wk + 1;
        ArrayList<Row> rowList = new ArrayList<Row>();
        int i = 0;
        while (i < fromRowCnt) {
            int fromWk1 = rowIdFrom1wk + i;
            if (rowIdTo <= rowIdFrom1wk) {
                fromWk1 += i;
            }
            int toIdWk = rowIdTo + i;
            Row fromRow1 = sheet.getRow(fromWk1);
            if (fromRow1 == null) {
                throw new Exception(String.format("rowId(from)=%D Not exitsts.", rowIdFrom1wk));
            }
            Row row2 = PoiWorkbookUtil.insertRow(sheet, toIdWk);
            PoiWorkbookUtil.copyRow(sheet, fromRow1, row2, doStyleClone);
            rowList.add(row2);
            ++i;
        }
        return rowList;
    }

    public static Row copyInsertRow(Sheet sheet, int rowIdFrom, int rowIdTo, boolean doStyleClone) throws Exception {
        List<Row> rowList = PoiWorkbookUtil.copyInsertRow(sheet, rowIdFrom, rowIdFrom, rowIdTo, doStyleClone);
        return BcCollectionUtil.getFirst(rowList);
    }

    public static List<String> createSheetNameList(Workbook workbook) throws Exception {
        ArrayList<String> sheetNameList = new ArrayList<String>();
        int i = 0;
        while (i < workbook.getNumberOfSheets()) {
            sheetNameList.add(workbook.getSheetName(i));
            ++i;
        }
        return sheetNameList;
    }

    public static String setSheetName(Sheet sheet, String sheetName, boolean doFit) throws Exception {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet);
        BcLogUtil.debug("sheetIndex=" + sheetIndex);
        if (!doFit) {
            workbook.setSheetName(sheetIndex, sheetName);
            return sheetName;
        }
        String sheetName2 = sheetName;
        int cnt = 1;
        while (true) {
            BcLogUtil.debug("cnt=" + ++cnt + " sheetName2=" + sheetName2 + " length=" + sheetName2.length());
            Sheet sheet2 = workbook.getSheet(sheetName2);
            if (sheetIndex == workbook.getSheetIndex(sheet2)) {
                sheetName2 = String.valueOf(sheetName2) + cnt;
            }
            try {
                workbook.setSheetName(sheetIndex, sheetName2);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                if (sheetName2.length() < 30) continue;
                sheetName2 = sheetName2.substring(0, 29);
                sheetName2 = String.valueOf(sheetName2) + cnt;
                BcLogUtil.debug("#2 sheetName2=" + sheetName2 + " length=" + sheetName2.length());
                continue;
            }
            break;
        }
        return sheetName2;
    }

    public static void writeWorkbook(Workbook workbook, File destFile, BcLogger logger) throws Exception {
        logger.info(String.format("Writing workbook... file=%s", destFile.getPath()));
        BcFileUtil.makeParent(destFile);
        try (FileOutputStream os = new FileOutputStream(destFile);){
            workbook.write((OutputStream)os);
        }
    }

    public static void writeWorkbook(Workbook workbook, File destFile) throws Exception {
        PoiWorkbookUtil.writeWorkbook(workbook, destFile, BcLogUtil.getDefaultLogger());
    }

    public static boolean is2007(Workbook workbook) throws Exception {
        return workbook instanceof XSSFWorkbook;
    }

    public static boolean is1997(Workbook workbook) throws Exception {
        return workbook instanceof HSSFWorkbook;
    }

    public static Object convByCellType(Cell cell, String str) throws Exception {
        Object value = null;
        switch (cell.getCellType()) {
            case NUMERIC: {
                CellStyle cellStyle = cell.getCellStyle();
                if (DateUtil.isCellDateFormatted((Cell)cell) || PoiCellFormatUtil.contains(cellStyle.getDataFormat())) {
                    if (BcStringUtil.isEmpty(str)) break;
                    Calendar calendar = BcTimeUtil.toCalendar(str);
                    if (calendar == null) {
                        value = str;
                        break;
                    }
                    value = calendar;
                    break;
                }
                try {
                    value = Double.parseDouble(str);
                }
                catch (Exception ex) {
                    value = str;
                }
                break;
            }
            default: {
                value = str;
            }
        }
        return value;
    }

    public static void setBorderBottom(Sheet sheet, Cell cell1, Cell cell2, BorderStyle borderStyle) throws Exception {
        int count = cell2.getColumnIndex() - cell1.getColumnIndex() + 1;
        Row row = sheet.getRow(cell1.getRowIndex());
        int i = 0;
        while (i < count) {
            Cell cellWk = row.getCell(cell1.getColumnIndex() + i);
            cellWk.getCellStyle().setBorderBottom(borderStyle);
            ++i;
        }
    }

    public static void setSegment(RichTextString richTextString, List<PoiRichTextSegment> richTextSegmentList, int lastFontIndex) throws Exception {
        int preTextIndex = 0;
        int i = 0;
        while (i < richTextSegmentList.size()) {
            PoiRichTextSegment richTextSegment = richTextSegmentList.get(i);
            richTextString.applyFont(preTextIndex, richTextSegment.textIndex, (short)richTextSegment.fontIndex);
            preTextIndex = richTextSegment.textIndex;
            ++i;
        }
        int wholeLength = richTextString.getString().length();
        richTextString.applyFont(preTextIndex, wholeLength, (short)lastFontIndex);
    }

    public static RichTextString replaceText(Cell cell, RichTextString richTextString1, String strFrom, String replacement) throws Exception {
        Workbook workbook = cell.getSheet().getWorkbook();
        String content = richTextString1.getString();
        if (content.indexOf(strFrom.toString()) < 0) {
            return richTextString1;
        }
        if (richTextString1.numFormattingRuns() > 0) {
            try {
                RichTextString ssRichTextString2 = PoiWorkbookUtil.replaceText_2(cell, richTextString1, strFrom, replacement);
                return ssRichTextString2;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                BcLogUtil.warning("\u30ea\u30c3\u30c1\u30c6\u30ad\u30b9\u30c8\u306e\u6587\u5b57\u5217\u7f6e\u63db\u306b\u304a\u3044\u3066\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u7c21\u7d20\u30e2\u30fc\u30c9\u3067\u51e6\u7406\u3057\u307e\u3059\u3002");
                BcLogUtil.warning("error content=" + content);
            }
        }
        XSSFRichTextString ssRichTextString2 = null;
        StringBuilder newValue = BcStringUtil.replace((CharSequence)content, strFrom, replacement);
        if (PoiWorkbookUtil.is2007(workbook)) {
            ssRichTextString2 = new XSSFRichTextString(newValue.toString());
        } else if (PoiWorkbookUtil.is1997(workbook)) {
            ssRichTextString2 = new HSSFRichTextString(newValue.toString());
        }
        return ssRichTextString2;
    }

    public static RichTextString replaceText_2(Cell cell, RichTextString ssRichTextString1, CharSequence strFrom, CharSequence replacement) throws Exception {
        Workbook workbook = cell.getSheet().getWorkbook();
        String content = ssRichTextString1.getString();
        XSSFRichTextString xssfRichTextString = null;
        HSSFRichTextString hssfRichTextString = null;
        if (PoiWorkbookUtil.is2007(workbook)) {
            xssfRichTextString = (XSSFRichTextString)ssRichTextString1;
        } else if (PoiWorkbookUtil.is1997(workbook)) {
            hssfRichTextString = (HSSFRichTextString)ssRichTextString1;
        }
        int formattin\uff47Size = ssRichTextString1.numFormattingRuns();
        int preTextIndex = -1;
        int fromTextIndex = 0;
        CellStyle cellStyle = cell.getCellStyle();
        int fontIndex = cellStyle.getFontIndex();
        ArrayList<PoiRichTextSegment> segmentList = new ArrayList<PoiRichTextSegment>();
        int textIndexSum = 0;
        int i = 0;
        while (i < formattin\uff47Size) {
            int textoIndex1;
            int textoIndex2 = textoIndex1 = ssRichTextString1.getIndexOfFormattingRun(i);
            String subString = content.substring(fromTextIndex, textoIndex1);
            if (textoIndex1 <= 0) {
                preTextIndex = textoIndex1;
            } else {
                if (preTextIndex == 0) {
                    textoIndex2 = textIndexSum;
                }
                preTextIndex = textoIndex1;
                fromTextIndex = textoIndex1;
                textIndexSum += textoIndex1;
                PoiRichTextSegment richTextSegment = new PoiRichTextSegment(textoIndex2, fontIndex);
                segmentList.add(richTextSegment);
                if (xssfRichTextString != null) {
                    XSSFFont xssfFont = xssfRichTextString.getFontOfFormattingRun(i);
                    fontIndex = xssfFont.getIndex();
                } else if (hssfRichTextString != null) {
                    fontIndex = hssfRichTextString.getFontOfFormattingRun(i);
                }
            }
            ++i;
        }
        String subString = content.substring(fromTextIndex);
        int lastFontIndex = 0;
        if (xssfRichTextString != null) {
            XSSFFont xssfFont = xssfRichTextString.getFontAtIndex(content.length() - 1);
            lastFontIndex = xssfFont.getIndex();
        } else if (hssfRichTextString != null) {
            lastFontIndex = hssfRichTextString.getFontAtIndex(content.length() - 1);
        }
        InnerTextReplace textReplace = new InnerTextReplace();
        textReplace.segmentList1 = segmentList;
        StringBuilder sb = textReplace.replace(content, strFrom, replacement, false);
        XSSFRichTextString ssRichTextString2 = null;
        if (PoiWorkbookUtil.is2007(workbook)) {
            ssRichTextString2 = new XSSFRichTextString(sb.toString());
        } else if (PoiWorkbookUtil.is1997(workbook)) {
            ssRichTextString2 = new HSSFRichTextString(sb.toString());
        }
        PoiWorkbookUtil.setSegment((RichTextString)ssRichTextString2, textReplace.segmentList2, lastFontIndex);
        return ssRichTextString2;
    }

    public static void replaceText(Cell cell, String strFrom, String replacement) throws Exception {
        RichTextString ssRichTextString1 = null;
        switch (cell.getCellType()) {
            case STRING: {
                ssRichTextString1 = cell.getRichStringCellValue();
                break;
            }
        }
        if (ssRichTextString1 != null) {
            RichTextString ssRichTextString2 = PoiWorkbookUtil.replaceText(cell, ssRichTextString1, strFrom, replacement);
            cell.setCellValue(ssRichTextString2);
        }
    }

    public static void replaceText(Row row, String strFrom, String replacement) throws Exception {
        int i = 0;
        while (i < row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            if (cell != null) {
                PoiWorkbookUtil.replaceText(cell, strFrom, replacement);
            }
            ++i;
        }
    }

    public static void replaceText(Sheet sheet, int startRowNum, int endRowNum, String strFrom, String replacement) throws Exception {
        Iterator iterator = sheet.rowIterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.getRowNum() < startRowNum || endRowNum > 0 && row.getRowNum() > endRowNum) continue;
            PoiWorkbookUtil.replaceText(row, strFrom, replacement);
        }
    }

    public static void replaceText(Sheet sheet, String strFrom, String replacement) throws Exception {
        PoiWorkbookUtil.replaceText(sheet, -1, -1, strFrom, replacement);
    }

    public static void replaceText(Workbook workbook, String strFrom, String replacement) throws Exception {
        int i = 0;
        while (i < workbook.getNumberOfSheets()) {
            Sheet sheet = workbook.getSheetAt(i);
            PoiWorkbookUtil.replaceText(sheet, strFrom, replacement);
            ++i;
        }
    }

    public static void setFont(Cell cell, short fontIndex, int indexStart, int indexEnd) throws Exception {
        Workbook workbook = cell.getSheet().getWorkbook();
        String cellValue = PoiWorkbookUtil.getCellValueAsString(cell);
        XSSFRichTextString richTextString = null;
        if (PoiWorkbookUtil.is2007(workbook)) {
            richTextString = new XSSFRichTextString(cellValue);
        } else if (PoiWorkbookUtil.is1997(workbook)) {
            richTextString = new HSSFRichTextString(cellValue);
        }
        Font font = workbook.createFont();
        font.setTypeOffset(fontIndex);
        richTextString.applyFont(indexStart, indexEnd, font);
        cell.setCellValue((RichTextString)richTextString);
    }

    public static void setFont(Cell cell, short fontIndex, String target) throws Exception {
        Workbook workbook = cell.getSheet().getWorkbook();
        String cellValue = PoiWorkbookUtil.getCellValueAsString(cell);
        if (BcStringUtil.isEmpty(cellValue)) {
            return;
        }
        List<Integer> indexList = BcStringUtil.createIndexList(cellValue, target);
        if (indexList.size() <= 0) {
            return;
        }
        int i = 0;
        while (i < indexList.size()) {
            Integer indexStart = indexList.get(i);
            PoiWorkbookUtil.setFont(cell, fontIndex, indexStart, indexStart + target.length());
            ++i;
        }
    }

    public static Calendar excelDateToCalendar(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        String base = "1899/12/30";
        Calendar calendar = BcTimeUtil.toCalendar(base);
        int num = BcNumberUtil.parseInteger(src);
        calendar.add(6, num);
        return calendar;
    }

    public static List<Cell> findCells(Row row, Object targetValue) throws Exception {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        if (BcStringUtil.isEmpty(targetValue)) {
            return cellList;
        }
        int i = 0;
        while (i < row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            if (cell != null && CharSequence.class.isAssignableFrom(targetValue.getClass())) {
                String cellValue = null;
                switch (cell.getCellType()) {
                    case STRING: {
                        cellValue = cell.getStringCellValue();
                        break;
                    }
                }
                if (!BcStringUtil.isEmpty(cellValue) && cellValue.toString().indexOf(targetValue.toString()) >= 0) {
                    cellList.add(cell);
                }
            }
            ++i;
        }
        return cellList;
    }

    public static List<Cell> findCells(Sheet sheet, Object targetValue) throws Exception {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        Iterator iterator = sheet.rowIterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            List<Cell> cellList2 = PoiWorkbookUtil.findCells(row, targetValue);
            cellList.addAll(cellList2);
        }
        return cellList;
    }

    public static List<Cell> findCells(Workbook workbook, Object targetValue) throws Exception {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        int i = 0;
        while (i < workbook.getNumberOfSheets()) {
            Sheet sheet = workbook.getSheetAt(i);
            List<Cell> cellList2 = PoiWorkbookUtil.findCells(sheet, targetValue);
            cellList.addAll(cellList2);
            ++i;
        }
        return cellList;
    }

    public static Cell findCell(Sheet sheet, Object targetValue) throws Exception {
        List<Cell> cellList = PoiWorkbookUtil.findCells(sheet, targetValue);
        Cell cell = BcCollectionUtil.getFirst(cellList);
        return cell;
    }

    public static Cell findCell(Workbook workbook, Object targetValue) throws Exception {
        List<Cell> cellList = PoiWorkbookUtil.findCells(workbook, targetValue);
        Cell cell = BcCollectionUtil.getFirst(cellList);
        return cell;
    }

    public static Sheet cloneSheet(Workbook workbook, int sheetNum) throws Exception {
        Sheet sheet1 = workbook.getSheetAt(sheetNum);
        Sheet sheet2 = workbook.cloneSheet(sheetNum);
        PoiWorkbookUtil.copyPrintSetup(sheet1.getPrintSetup(), sheet2.getPrintSetup());
        return sheet2;
    }

    public static void copyPrintSetup(PrintSetup printSetup1, PrintSetup printSetup2) throws Exception {
        printSetup2.setCopies(printSetup1.getCopies());
        printSetup2.setDraft(printSetup1.getDraft());
        printSetup2.setFitHeight(printSetup1.getFitHeight());
        printSetup2.setFitWidth(printSetup1.getFitWidth());
        printSetup2.setFooterMargin(printSetup1.getFooterMargin());
        printSetup2.setHeaderMargin(printSetup1.getHeaderMargin());
        printSetup2.setHResolution(printSetup1.getHResolution());
        printSetup2.setLandscape(printSetup1.getLandscape());
        printSetup2.setLeftToRight(printSetup1.getLeftToRight());
        printSetup2.setNoColor(printSetup1.getNoColor());
        printSetup2.setNoOrientation(printSetup1.getNoOrientation());
        printSetup2.setNotes(printSetup1.getNotes());
        printSetup2.setPaperSize(printSetup1.getPaperSize());
        printSetup2.setScale(printSetup1.getScale());
        printSetup2.setUsePage(printSetup1.getUsePage());
        printSetup2.setValidSettings(printSetup1.getValidSettings());
        printSetup2.setVResolution(printSetup1.getVResolution());
    }

    public static PoiCellRangeAddressPack getCellRangeAddress(Sheet sheet, Cell cell) throws Exception {
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            if (cellRangeAddress.getFirstRow() <= cell.getRowIndex() && cellRangeAddress.getLastRow() >= cell.getRowIndex() && cellRangeAddress.getFirstColumn() <= cell.getColumnIndex() && cellRangeAddress.getLastColumn() >= cell.getColumnIndex()) {
                PoiCellRangeAddressPack cellRangeAddressPack = new PoiCellRangeAddressPack();
                cellRangeAddressPack.cellRangeAddress = cellRangeAddress;
                cellRangeAddressPack.index = i;
                return cellRangeAddressPack;
            }
            ++i;
        }
        return null;
    }

    public static String fontLog(Font font) throws Exception {
        StringBuilder sb = new StringBuilder();
        String str = null;
        switch (font.getTypeOffset()) {
            case 0: {
                str = "SS_NONE";
                break;
            }
            case 1: {
                str = "SS_SUPER";
                break;
            }
            case 2: {
                str = "SS_SUB";
            }
        }
        sb.append("type=" + str);
        sb.append(" fontName=" + font.getFontName());
        sb.append(" fontHeightInPoints=" + font.getFontHeightInPoints());
        sb.append(" bold=" + font.getBold());
        sb.append(" italic=" + font.getItalic());
        sb.append(" underline=" + font.getUnderline());
        return sb.toString();
    }

    public static String fontLog(Workbook workbook, short fontIndex) throws Exception {
        Font font = workbook.getFontAt((int)fontIndex);
        return PoiWorkbookUtil.fontLog(font);
    }

    static class InnerTextReplace
    extends BcStringUtil.TextReplace {
        List<PoiRichTextSegment> segmentList1;
        private List<PoiRichTextSegment> segmentList2;

        @Override
        protected void started() {
            this.replacement = BcStringUtil.toStringNotNull(this.replacement);
            try {
                this.segmentList2 = BcCloneUtil.createClone(this.segmentList1);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        protected void found(int findIndexStrat, StringBuilder beforeStr) {
            int findIndexEnd = findIndexStrat + this.target.length();
            int replaceDifference = this.replacement.length() - this.target.length();
            int preTextIndex = 0;
            int influencedSegmentIndexStart = -1;
            int influencedSegmentIndexEnd = -1;
            int i = 0;
            while (i < this.segmentList2.size()) {
                int replaceStart;
                int segmentIndex = i;
                PoiRichTextSegment richTextSegment = this.segmentList2.get(segmentIndex);
                int segmentTextLength = richTextSegment.textIndex - preTextIndex;
                String segmentText = this.src.toString().substring(preTextIndex, richTextSegment.textIndex);
                int segmentTextIndexBak = richTextSegment.textIndex;
                if (findIndexStrat >= preTextIndex && findIndexStrat < richTextSegment.textIndex) {
                    influencedSegmentIndexStart = segmentIndex;
                    replaceStart = findIndexStrat - preTextIndex;
                    int restTextLngth = richTextSegment.textIndex - preTextIndex - 1;
                    int differenceInSegment = this.replacement.length() - restTextLngth;
                    richTextSegment.textIndex += differenceInSegment;
                } else if (findIndexEnd >= preTextIndex && findIndexEnd < richTextSegment.textIndex) {
                    influencedSegmentIndexEnd = segmentIndex;
                    replaceStart = findIndexEnd - preTextIndex;
                    richTextSegment.textIndex += replaceDifference;
                    int restSegmentSize = this.segmentList2.size() - segmentIndex - 1;
                    int j = 0;
                    while (j < restSegmentSize) {
                        PoiRichTextSegment richTextSegment2 = this.segmentList2.get(segmentIndex + j + 1);
                        richTextSegment2.textIndex += replaceDifference;
                        ++j;
                    }
                    break;
                }
                preTextIndex = segmentTextIndexBak;
                ++i;
            }
            int influencedSegmentIndexDiff = influencedSegmentIndexEnd - influencedSegmentIndexStart - 1;
            if (influencedSegmentIndexDiff > 0) {
                int i2 = 0;
                while (i2 < influencedSegmentIndexDiff) {
                    int segmentIndex = influencedSegmentIndexStart + i2 + 1;
                    PoiRichTextSegment richTextSegment = this.segmentList2.get(segmentIndex);
                    richTextSegment.textIndex = -1;
                    ++i2;
                }
            }
            ArrayList<PoiRichTextSegment> segmentList3 = new ArrayList<PoiRichTextSegment>();
            int i3 = 0;
            while (i3 < this.segmentList2.size()) {
                PoiRichTextSegment richTextSegment = this.segmentList2.get(i3);
                if (richTextSegment.textIndex >= 0) {
                    segmentList3.add(richTextSegment);
                }
                ++i3;
            }
            this.segmentList2 = segmentList3;
        }

        @Override
        protected void finished() {
        }
    }
}

