/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.person.util;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.person.common.PsnPersonConstants;

public class PsnPersonUtil {
    private PsnPersonUtil() {
    }

    public static int calcAge(int birthbay, int targetDate) throws Exception {
        int age = (targetDate - birthbay) / 10000;
        return age;
    }

    public static List<String> divideName(String srcValue) {
        if (srcValue == null) {
            srcValue = "";
        }
        String str2 = BcStringUtil.replace((CharSequence)srcValue, BcUnicode.FULLWIDTH_SPACE.string, BcStringUtil.SPACE_STR).toString();
        ArrayList<String> elemList = new ArrayList<String>();
        BcStringUtil.tokenize(str2, " ", false, true, elemList);
        int gap = 3 - elemList.size();
        if (gap > 0) {
            int i = 0;
            while (i < gap) {
                elemList.add("");
                ++i;
            }
        }
        return elemList;
    }

    public static String getLastName(String srcValue) {
        List<String> elemList = PsnPersonUtil.divideName(srcValue);
        if (elemList.size() > 0) {
            return elemList.get(0);
        }
        return null;
    }

    public static String getFrstName(String srcValue) {
        List<String> elemList = PsnPersonUtil.divideName(srcValue);
        if (elemList.size() > 1) {
            return elemList.get(1);
        }
        return null;
    }

    public static String getMiddleName(String srcValue) {
        List<String> elemList = PsnPersonUtil.divideName(srcValue);
        if (elemList.size() > 2) {
            return elemList.get(2);
        }
        return null;
    }

    public static String margeName(List<? extends String> elemList) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < elemList.size()) {
            CharSequence elem1 = elemList.get(i);
            String elem2 = BcStringUtil.trim(BcStringUtil.toStringNotNull(elem1));
            if (!BcStringUtil.isEmpty(elem2)) {
                if (i > 0) {
                    sb.append(BcUnicode.space.char_);
                }
                sb.append(elem2);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String margeName(String last, String first, String middle) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(last);
        arrayList.add(first);
        arrayList.add(middle);
        return PsnPersonUtil.margeName(arrayList);
    }

    public static String margeName(String last, String first) {
        return PsnPersonUtil.margeName(last, first, null);
    }

    public static String reformName(String srcValue) {
        List<String> list = PsnPersonUtil.divideName(srcValue);
        return PsnPersonUtil.margeName(list);
    }

    public static String toAgeBase(int age) throws Exception {
        if (age <= 0) {
            return null;
        }
        int base = age / 10;
        int remainder = age % 10;
        String baseStr = String.valueOf(base * 10) + "\u4ee3";
        String half = "\u524d\u534a";
        if (remainder >= 5) {
            half = "\u5f8c\u534a";
        }
        return String.valueOf(baseStr) + half;
    }

    public static String toAgeBase(int birthday, int targetDate) throws Exception {
        int age = -1;
        if (birthday > 0) {
            age = PsnPersonUtil.calcAge(birthday, targetDate);
        }
        return PsnPersonUtil.toAgeBase(age);
    }

    public static PsnPersonConstants.Sex toSexByCode(String sexCode) {
        PsnPersonConstants.Sex[] sexArray = PsnPersonConstants.Sex.values();
        int n = sexArray.length;
        int n2 = 0;
        while (n2 < n) {
            PsnPersonConstants.Sex sex = sexArray[n2];
            if (sex.code.equalsIgnoreCase(sexCode)) {
                return sex;
            }
            ++n2;
        }
        return null;
    }

    public static boolean sexEquals(PsnPersonConstants.Sex sex, String sexCode) {
        return sex.code.equalsIgnoreCase(sexCode);
    }

    public static PsnPersonConstants.Sex toAntonymSex(PsnPersonConstants.Sex sex) {
        if (sex == PsnPersonConstants.Sex.male) {
            return PsnPersonConstants.Sex.female;
        }
        if (sex == PsnPersonConstants.Sex.female) {
            return PsnPersonConstants.Sex.male;
        }
        return null;
    }

    public static PsnPersonConstants.Sex toAntonymSex(String sexCode) {
        return PsnPersonUtil.toAntonymSex(PsnPersonUtil.toSexByCode(sexCode));
    }
}

