/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.person.nameIidentification;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcKanaUtil;
import jp.co.extreme.person.nameIidentification.PsnNameBirthday;

public final class PsnNameUtil {
    public static char[][] CHAR_RANGES = new char[][]{{'0', '9'}, {'A', 'Z'}, {'a', 'z'}, {'\u30a1', '\u30f4'}, {'\u4e00', '\u9fff'}};

    private PsnNameUtil() {
    }

    public static String toSimple(String name) throws Exception {
        String simpleName = BcStringUtil.toLatinBasic(name, 2);
        simpleName = simpleName.toString().toUpperCase();
        simpleName = BcKanaUtil.hanKanaToZenKana(simpleName, 2);
        simpleName = BcKanaUtil.zenKanaToSimple(simpleName, 2);
        simpleName = BcStringUtil.choiceChrars((CharSequence)simpleName, CHAR_RANGES);
        return simpleName;
    }

    public static Map<Object, PsnNameBirthday> toIdMap(Collection<PsnNameBirthday> nameBirthdayCollection) throws Exception {
        HashMap<Object, PsnNameBirthday> dataIdMap = new HashMap<Object, PsnNameBirthday>();
        for (PsnNameBirthday nameBirthday : nameBirthdayCollection) {
            dataIdMap.put(nameBirthday.getId(), nameBirthday);
        }
        return dataIdMap;
    }
}

