/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.persistence;

import java.sql.PreparedStatement;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.orm.entity.OrmEntityId;
import jp.co.extreme.orm.entity.OrmGeneralData;
import jp.co.extreme.orm.persistence.OrmAbstractPersistence;
import jp.co.extreme.orm.persistence.OrmPersistenceProxy;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSetClause;
import jp.co.extreme.sql.model.SqlUpdateQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class OrmPersistenceDataId
extends OrmAbstractPersistence {
    @Override
    public void setSetClause(SqlContext sqlContext, List<String> setElementList, Object entity) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        OrmEntityId etdmDataId = (OrmEntityId)entity;
        setElementList.add("id=" + etdmDataId.getDataId());
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, Object entity) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        OrmEntityId etdmDataId = (OrmEntityId)entity;
        updateQuery.addSetClause(new SqlSetClause("id", etdmDataId.getDataId()));
    }

    @Override
    public void setSetClause(List<String> setColumnList, Class entityClass) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entityClass)) {
            return;
        }
        setColumnList.add("id");
    }

    @Override
    public void setValueList(List<Object> valueList, Object entity) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        OrmEntityId etdmDataId = (OrmEntityId)entity;
        valueList.add(etdmDataId.getDataId());
    }

    @Override
    public void getJdbcTypes(List<Integer> sqlTypeList, Class entityClass) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entityClass)) {
            return;
        }
        sqlTypeList.add(4);
    }

    @Override
    public void setPreStmtValue(SqlContext sqlContext, PreparedStatement preStmt, BcInteger columnIndex, Object entity) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        OrmEntityId etdmDataId = (OrmEntityId)entity;
        sqlContext.setPreStmtValue(preStmt, columnIndex, etdmDataId.getDataId(), (Object)4);
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, OrmGeneralData generalData, Class entityClass) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entityClass)) {
            return;
        }
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (mmdField.columnName.equals("id")) {
                updateQuery.addSetClause(new SqlSetClause("id", valueObject));
            }
            ++i;
        }
    }

    @Override
    public void getSelectColumnName(List<String> columnNameList, String tableAlias, Class entityClass) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entityClass)) {
            return;
        }
        String tableAlias2 = SqlUtil.tableAliasToNotNull(tableAlias);
        columnNameList.add(String.valueOf(tableAlias2) + "id");
    }

    @Override
    public void setResultSet(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity) throws Exception {
        if (!OrmEntityId.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        OrmEntityId etdmDataId = (OrmEntityId)entity;
        SqlContext sqlContext = dtsSession.getSqlContext();
        etdmDataId.setEntityId(rs.getInt(columnIndex));
    }

    @Override
    public int putEntity(DtsSession dtsSession, OrmPersistenceProxy persistenceProxy, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean isInsertCheck) throws Exception {
        int updateCount;
        block13: {
            SqlContext sqlContext = dtsSession.getSqlContext();
            Class<?> entityClass = entity.getClass();
            OrmEntityId etdmDataId = (OrmEntityId)entity;
            boolean isInsert = false;
            isInsert = isInsertCheck ? this.preTrans(dtsSession, tableName, entity) : true;
            SqlUpdateQuery updateQuery = new SqlUpdateQuery();
            updateQuery.tableName = tableName;
            persistenceProxy.createCommonSetPhrase(updateQuery, entity);
            int i = 0;
            while (i < columnList.size()) {
                Object value = valueList.get(i);
                SqlSetClause setClause = new SqlSetClause(columnList.get(i), value);
                updateQuery.addSetClause(setClause);
                ++i;
            }
            updateCount = 0;
            if (isInsert) {
                String sql = sqlContext.buildInsertQuery(updateQuery);
                try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                    try {
                        updateCount = stmt.executeUpdate(sql);
                        break block13;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error("error:sql=" + sql);
                        throw ex;
                    }
                }
            }
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id=" + etdmDataId.getDataId());
            updateQuery.getWhereElementList().add(whereElement);
            String sql = sqlContext.buildUpdateQuery(updateQuery);
            try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                try {
                    updateCount = stmt.executeUpdate(sql);
                    if (updateCount <= 0) {
                        sql = sqlContext.buildInsertQuery(updateQuery);
                        updateCount = stmt.executeUpdate(sql);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.debug("error:sql=" + sql);
                    throw ex;
                }
            }
        }
        return updateCount;
    }

    public boolean preTrans(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityId entityId = (OrmEntityId)entity;
        boolean isInsert = false;
        if (entityId.getEntityId() <= 0L) {
            long newEntityId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            entityId.setEntityId(newEntityId);
            isInsert = true;
        }
        return isInsert;
    }
}

