/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.dao;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlLockTimeoutException;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;

public class OrmSequenceDAO
extends OrmAbstractDAO {
    public static final byte FLG_init = -1;
    public static final byte FLG_unlock = 0;
    public static final byte FLG_lock = 1;
    private boolean isExclusive;
    private long lockWaitMiilisDefault = 50L;
    private int lockTryCntMaxDefault = 20;
    private Map<String, Map<String, SequenceContext>> sequenceContextMapMap;

    private OrmSequenceDAO() {
        super(new Object[0]);
        this.setTableName("frwk_sequence_number");
        this.sequenceContextMapMap = new HashMap<String, Map<String, SequenceContext>>();
        this.setExclusive(true);
    }

    public static OrmSequenceDAO getInstance() {
        return SingletonHolder.instance;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public long getNumber(SqlConnection sqlConn, SqlContext sqlContext, String sequenceName, boolean isForUpdate) throws Exception {
        String query1 = "SELECT sequence_number FROM " + this.getTableName() + " WHERE sequence_name" + sqlContext.toCondition_string("=", BcStringUtil.toLowerCase(sequenceName));
        if (isForUpdate) {
            query1 = String.valueOf(query1) + " FOR UPDATE";
        }
        boolean hasRecord = false;
        long number = 0L;
        try (SqlStatement stmt = sqlConn.createStatement();){
            ResultSet rs = stmt.executeQuery(query1);
            if (rs.next()) {
                hasRecord = true;
                number = rs.getLong(1);
            }
            rs.close();
        }
        if (hasRecord) {
            return number;
        }
        String query2 = this.createInsertsql(sqlContext, sequenceName, number, 0);
        int recCnt = SqlUtil.executeUpdate(sqlConn, query2);
        return number;
    }

    protected void updateNumber(SqlConnection sqlConn, SqlContext sqlContext, String sequenceName, long number) throws Exception {
        String query1 = "UPDATE " + this.getTableName() + " SET sequence_number=" + number + " WHERE sequence_name" + sqlContext.toCondition_string("=", BcStringUtil.toLowerCase(sequenceName));
        int updateCount = SqlUtil.executeUpdate(sqlConn, query1);
        if (updateCount <= 0) {
            String query2 = this.createInsertsql(sqlContext, sequenceName, number, 0);
            updateCount = SqlUtil.executeUpdate(sqlConn, query2);
        }
    }

    protected String createInsertsql(SqlContext sqlContext, String sequenceName, long number, int lockFlag) throws Exception {
        String query = "INSERT INTO " + this.getTableName() + " (sequence_name, sequence_number, lock_flag" + ") VALUES (" + sqlContext.toSet(BcStringUtil.toLowerCase(sequenceName)) + "," + number + "," + lockFlag + ")";
        return query;
    }

    protected int getLockFlag(SqlConnection sqlConn, SqlContext sqlContext, String sequenceName) throws Exception {
        String query1 = "SELECT lock_flag FROM " + this.getTableName() + " WHERE sequence_name" + sqlContext.toCondition_string("=", BcStringUtil.toLowerCase(sequenceName));
        boolean hasRecord = false;
        int lockFlag = -1;
        try (SqlStatement stmt = sqlConn.createStatement();){
            ResultSet rs = stmt.executeQuery(query1);
            if (rs.next()) {
                hasRecord = true;
                lockFlag = rs.getInt(1);
            }
            rs.close();
        }
        if (hasRecord) {
            return lockFlag;
        }
        String query2 = this.createInsertsql(sqlContext, sequenceName, 0L, 0);
        int recCnt = SqlUtil.executeUpdate(sqlConn, query2);
        return 0;
    }

    protected int updateLockFlag(SqlConnection sqlConn, SqlContext sqlContext, String sequenceName, int lockFlag) throws Exception {
        String query1 = "UPDATE " + this.getTableName() + " SET lock_flag=" + lockFlag + " WHERE sequence_name" + sqlContext.toCondition_string("=", BcStringUtil.toLowerCase(sequenceName));
        int recCnt = SqlUtil.executeUpdate(sqlConn, query1);
        if (recCnt > 0) {
            return recCnt;
        }
        String query2 = this.createInsertsql(sqlContext, sequenceName, 0L, lockFlag);
        recCnt = SqlUtil.executeUpdate(sqlConn, query2);
        return recCnt;
    }

    private long generateNumber_L2(DtsSession dtsSession, String sequenceName, long requirementCount, long lockWaitMiilis, int lockTryCntMax) throws Exception {
        int tryCnt = 0;
        while (true) {
            SequenceContext sequenceContext;
            if ((sequenceContext = this.getSequenceContext(dtsSession.getSessionFactory(), sequenceName)).lock()) {
                long newNumber = -1L;
                try {
                    try {
                        newNumber = this.generateNumber_L3(dtsSession, sequenceContext, sequenceName, requirementCount);
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                        sequenceContext.unlock();
                    }
                }
                finally {
                    sequenceContext.unlock();
                }
                return newNumber;
            }
            if (++tryCnt >= lockTryCntMax) {
                Thread.dumpStack();
                throw new SqlLockTimeoutException((Object)("[thread:" + Thread.currentThread().hashCode() + "] createDataId1:sequenceName='" + sequenceName + "' tryCnt=" + tryCnt));
            }
            if (tryCnt % 10 == 0) {
                this.getLogger().warning("[thread:" + Thread.currentThread().hashCode() + "] createDataId1:sequenceName='" + sequenceName + "' tryCnt=" + tryCnt);
            }
            this.getLogger().debug("generateNumberExclusive:sleep lockWaitMiilis=" + lockWaitMiilis);
            Thread.sleep(lockWaitMiilis);
        }
    }

    /*
     * Unable to fully structure code
     */
    private long generateNumber_L3(DtsSession dtsSession, SequenceContext sequenceContext, String sequenceName, long requirementCount) throws Exception {
        while (true) lbl-1000:
        // 5 sources

        {
            block12: {
                if (sequenceContext.number >= 0L && sequenceContext.number + requirementCount <= sequenceContext.numberMax) {
                    newNumber = sequenceContext.number + 1L;
                    sequenceContext.number += requirementCount;
                    sequenceContext.unlock();
                    return newNumber;
                }
                buffer = 1L;
                if (sequenceContext.number >= 1L) {
                    diff = sequenceContext.number + requirementCount - sequenceContext.numberMax;
                    if (diff > buffer) {
                        buffer = diff;
                    }
                } else if (requirementCount > buffer) {
                    buffer = requirementCount;
                }
                if (!this.isExclusive()) break block12;
                connectionManager = dtsSession.getConnectionManager();
                sqlConn = connectionManager.getConnection(this);
                sqlContext = sqlConn.getSqlContext();
                try {
                    block13: {
                        sqlConn.setOwner(this);
                        currentNumber = -1L;
                        if (!sqlContext.isSupported(SqlContext.Function.selectForUpdate)) break block13;
                        currentNumber = this.getNumber(sqlConn, sqlContext, sequenceName, true);
                        this.updateNumber(sqlConn, sqlContext, sequenceName, currentNumber + buffer);
                        ** GOTO lbl37
                    }
                    lockFlag = this.getLockFlag(sqlConn, sqlContext, sequenceName);
                    if (lockFlag == 1) ** GOTO lbl-1000
                    this.updateLockFlag(sqlConn, sqlContext, sequenceName, 1);
                    currentNumber = this.getNumber(sqlConn, sqlContext, sequenceName, false);
                    this.updateNumber(sqlConn, sqlContext, sequenceName, currentNumber + buffer);
                    this.updateLockFlag(sqlConn, sqlContext, sequenceName, 0);
lbl37:
                    // 2 sources

                    sqlConn.commit();
                    sequenceContext.number = currentNumber;
                    sequenceContext.numberMax = sequenceContext.number + buffer;
                }
                finally {
                    sqlConn.close();
                }
                continue;
            }
            sqlConn = dtsSession.getConnection();
            sqlContext = dtsSession.getSqlContext();
            currentNumber = this.getNumber(sqlConn, sqlContext, sequenceName, false);
            this.updateNumber(sqlConn, sqlContext, sequenceName, currentNumber + buffer);
            sequenceContext.number = currentNumber;
            sequenceContext.numberMax = sequenceContext.number + buffer;
        }
    }

    public long generateNumber(DtsSession dtsSession, String sequenceName, int requirementCount, long lockWaitMiilis, int lockTryCntMax) throws Exception {
        return this.generateNumber_L2(dtsSession, sequenceName, requirementCount, lockWaitMiilis, lockTryCntMax);
    }

    public long generateNumber(DtsSession dtsSession, String sequenceName, int requirementCount) throws Exception {
        return this.generateNumber(dtsSession, sequenceName, requirementCount, this.lockWaitMiilisDefault, this.lockTryCntMaxDefault);
    }

    public long generateNumber(DtsSession dtsSession, String sequenceName) throws Exception {
        return this.generateNumber(dtsSession, sequenceName, 1);
    }

    public long generateNumber(DtsSession dtsSession, String tableName, String columnName, int requirementCount) throws Exception {
        return this.generateNumber(dtsSession, MmdUtil.createTableColumnName(tableName, columnName), requirementCount);
    }

    public long generateNumber(DtsSession dtsSession, String tableName, String columnName) throws Exception {
        return this.generateNumber(dtsSession, tableName, columnName, 1);
    }

    public int generateNumber_int(DtsSession dtsSession, String sequenceName) throws Exception {
        return (int)this.generateNumber(dtsSession, sequenceName);
    }

    public long getNumberFromSubstance(SqlConnection sqlConn, SqlContext sqlContext, String tableName, String columnName) throws Exception {
        tableName = tableName.toLowerCase();
        String query = "SELECT " + columnName + " FROM " + tableName + " ORDER BY " + columnName + " DESC";
        query = sqlContext.setLimit(query, 1L, 0L);
        long number = 0L;
        try (SqlStatement stmt = sqlConn.createStatement();){
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                number = rs.getLong(columnName);
            }
            rs.close();
        }
        return number;
    }

    public long getNumberFromSubstance(DtsSession dtsSession, String tableName, String columnName) throws Exception {
        return this.getNumberFromSubstance(dtsSession.getConnection(), dtsSession.getSqlContext(), tableName, columnName);
    }

    public void conpareNumber(DtsSession dtsSession1, DtsSession dtsSession2, String tableName, String columnName, boolean doRecovery) throws Exception {
        long number2;
        SqlContext sqlContext = dtsSession1.getSqlContext();
        String sequenceName = MmdUtil.createTableColumnName(tableName, columnName);
        long number1 = this.getNumber(dtsSession1.getConnection(), sqlContext, sequenceName, false);
        if (number1 != (number2 = this.getNumberFromSubstance(dtsSession2, tableName, columnName))) {
            if (doRecovery) {
                BcLogUtil.info("update " + sequenceName + ":" + BcNumberUtil.toString(number1) + " -> " + BcNumberUtil.toString(number2));
                this.updateNumber(dtsSession1.getConnection(), sqlContext, sequenceName, number2);
            } else {
                this.getLogger().info(String.valueOf(sequenceName) + ": seq=" + BcNumberUtil.toString(number1) + " record=" + BcNumberUtil.toString(number2));
                if (number1 < number2) {
                    this.getLogger().info("sequenceName is error!");
                }
            }
        }
    }

    public void conpareNumber(DtsSession dtsSession1, DtsSession dtsSession2, MmdModel mmdModel, boolean doRecovery) throws Exception {
        MmdField mmdField = mmdModel.getFieldByColumnName("sy_oid");
        if (mmdField != null) {
            this.conpareNumber(dtsSession1, dtsSession2, mmdModel.tableName, mmdField.columnName, doRecovery);
        }
        if ((mmdField = mmdModel.getFieldByColumnName("id")) != null && (mmdField.dataClass.equals(Long.class) || mmdField.dataClass.equals(Integer.class) || mmdField.dataClass.equals(Short.class))) {
            this.conpareNumber(dtsSession1, dtsSession2, mmdModel.tableName, mmdField.columnName, doRecovery);
        }
    }

    public void conpareNumber(DtsSession dtsSession1, DtsSession dtsSession2, boolean doRecovery) throws Exception {
        SqlContext sqlContext = dtsSession1.getSqlContext();
        List<String> tableNameList = sqlContext.getTableNameList(dtsSession1.getConnection());
        int i = 0;
        while (i < tableNameList.size()) {
            String tableName = tableNameList.get(i);
            if (!tableName.startsWith("~") && !tableName.endsWith("__")) {
                MmdModel mmdModel = sqlContext.createModelMetaData(dtsSession1.getConnection(), tableName);
                this.conpareNumber(dtsSession1, dtsSession2, mmdModel, doRecovery);
            }
            ++i;
        }
    }

    public void conpareNumber(DtsSession dtsSession1, boolean doRecovery) throws Exception {
        this.conpareNumber(dtsSession1, dtsSession1, doRecovery);
    }

    public void conpareNumber(DtsSession dtsSession1, DtsSession dtsSession2, String tableName, boolean doRecovery) throws Exception {
        SqlContext sqlContext = dtsSession1.getSqlContext();
        MmdModel mmdModel = sqlContext.createModelMetaData(dtsSession1.getConnection(), tableName);
        this.conpareNumber(dtsSession1, dtsSession2, mmdModel, doRecovery);
    }

    public void conpareNumber(DtsSession dtsSession1, String tableName, boolean doRecovery) throws Exception {
        this.conpareNumber(dtsSession1, dtsSession1, tableName, doRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceContext getSequenceContext(DtsSessionFactory stsSessionFactory, String sequenceName) throws Exception {
        SequenceContext sequenceContext = null;
        Map<String, Map<String, SequenceContext>> map = this.sequenceContextMapMap;
        synchronized (map) {
            Map<String, SequenceContext> sequenceContextMap = this.sequenceContextMapMap.get(stsSessionFactory.getName());
            if (sequenceContextMap == null) {
                sequenceContextMap = new HashMap<String, SequenceContext>();
                this.sequenceContextMapMap.put(stsSessionFactory.getName(), sequenceContextMap);
            }
            if ((sequenceContext = sequenceContextMap.get(sequenceName)) == null) {
                sequenceContext = new SequenceContext();
                sequenceContextMap.put(sequenceName, sequenceContext);
            }
            return sequenceContext;
        }
    }

    public void setSequenceNumber(DtsSessionFactory stsSessionFactory, String sequenceName, long number) throws Exception {
        block10: {
            if (this.isExclusive()) {
                DtsConnectionManager connectionManager = stsSessionFactory.getConnectionManager();
                SqlConnection sqlConn = connectionManager.getConnection(this);
                SqlContext sqlContext = sqlConn.getSqlContext();
                try {
                    sqlConn.setOwner(this);
                    if (sqlContext.isSupported(SqlContext.Function.selectForUpdate)) {
                        this.updateNumber(sqlConn, sqlContext, sequenceName, number);
                    } else {
                        int lockFlag = this.getLockFlag(sqlConn, sqlContext, sequenceName);
                        if (lockFlag == 1) {
                            throw new Exception();
                        }
                        this.updateLockFlag(sqlConn, sqlContext, sequenceName, 1);
                        this.updateNumber(sqlConn, sqlContext, sequenceName, number);
                        this.updateLockFlag(sqlConn, sqlContext, sequenceName, 0);
                    }
                    sqlConn.commit();
                    break block10;
                }
                finally {
                    sqlConn.close();
                }
            }
            SequenceContext sequenceContext = this.getSequenceContext(stsSessionFactory, sequenceName);
            if (sequenceContext.lock()) {
                sequenceContext.number = number;
                sequenceContext.unlock();
            }
        }
    }

    /* synthetic */ OrmSequenceDAO(OrmSequenceDAO ormSequenceDAO) {
        this();
    }

    private class SequenceContext {
        boolean isLocked = false;
        long number = -1L;
        long numberMax = -1L;

        public synchronized boolean lock() {
            if (!this.isLocked) {
                this.isLocked = true;
                return true;
            }
            return false;
        }

        public synchronized boolean unlock() {
            if (this.isLocked) {
                this.isLocked = false;
                return true;
            }
            return false;
        }
    }

    private static final class SingletonHolder {
        private static final OrmSequenceDAO instance = new OrmSequenceDAO(null);

        private SingletonHolder() {
        }
    }
}

