/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpToken;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.nlp.NlpWord;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

public class NlpPersonNameFinderEN1
extends BcLoggableObject {
    NameFinderME nameFinder;

    public void init() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("en-ner-person-1.5.bin");
        TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(is);
        this.nameFinder = new NameFinderME(tokenNameFinderModel);
    }

    public List<NlpElement> find(Span[] sapns, String[] tokens) throws Exception {
        if (this.nameFinder == null) {
            this.init();
        }
        Span[] findSpans = this.nameFinder.find(tokens);
        String[] strArray = Span.spansToStrings((Span[])findSpans, (String[])tokens);
        ArrayList<NlpElement> elementList = new ArrayList<NlpElement>();
        int i = 0;
        while (i < findSpans.length) {
            Span findSpan = findSpans[i];
            String name = this.str(tokens, findSpan);
            NlpWord word = new NlpWord();
            word.key = name.toLowerCase();
            word.text = NlpUtil.toCamelCase(name);
            ArrayList<NlpTokenWrap> tokenWrapList = new ArrayList<NlpTokenWrap>();
            int j = findSpan.getStart();
            while (j < findSpan.getEnd()) {
                Span span = sapns[j];
                NlpToken nlpToken = new NlpToken();
                nlpToken.beginIndex = span.getStart();
                nlpToken.surface = tokens[j];
                NlpTokenWrap tokenWrap = new NlpTokenWrap();
                tokenWrap.token = nlpToken;
                tokenWrapList.add(tokenWrap);
                ++j;
            }
            NlpElement nlpElement = NlpUtil.createElement(word, tokenWrapList);
            elementList.add(nlpElement);
            ++i;
        }
        return elementList;
    }

    String str(String[] sentence, Span spanWK) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        int i = spanWK.getStart();
        while (i < spanWK.getEnd()) {
            if (++cnt > 1) {
                sb.append(BcUnicode.space.char_);
            }
            sb.append(sentence[i]);
            ++i;
        }
        return sb.toString();
    }
}

