/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.nlp.NlpAbstractNounFinder;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.nlp.NlpPersonNameFinderEN1;
import jp.co.extreme.nlp.NlpPersonNameFinderEN2;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.util.Span;

public class NlpNounFinderEN
extends NlpAbstractNounFinder {
    private TokenizerME tokenizer;
    NlpPersonNameFinderEN1 personNameFinderEN1;
    NlpPersonNameFinderEN2 personNameFinderEN2;

    public TokenizerME getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(TokenizerME tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<NlpNoun> find(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            this.getLogger().warning("src is empty.");
        }
        Span[] sapns = this.tokenizer.tokenizePos(src);
        String[] tokens = this.tokenizer.tokenize(src);
        List<NlpElement> elementListTmp = this.personNameFinderEN1.find(sapns, tokens);
        ArrayList<NlpElement> elementList1 = new ArrayList<NlpElement>();
        int i = 0;
        while (i < elementListTmp.size()) {
            NlpElement nlpElement = elementListTmp.get(i);
            if (nlpElement.tokenWrapList.size() != 1) {
                elementList1.add(nlpElement);
            } else {
                NlpTokenWrap tokenWrap = nlpElement.tokenWrapList.get(0);
                String tag = this.personNameFinderEN2.getTag(tokenWrap.token.surface);
                if (this.isNNP(tag)) {
                    elementList1.add(nlpElement);
                }
            }
            ++i;
        }
        List<NlpElement> elementList2 = this.personNameFinderEN2.partOfSpeech(tokens);
        elementList1.addAll(elementList2);
        List<NlpElement> elementList3 = NlpUtil.organize(elementList1);
        return NlpUtil.toNownList(elementList3, true);
    }

    protected boolean isNNP(String tag) throws Exception {
        return NlpUtil.EnglishPartOfSpeech.NNP.name().equalsIgnoreCase(tag);
    }
}

