/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.module.xweb.common.SitemapUrl;
import jp.co.extreme.module.xweb.common.XwebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XwebSitemapCreator {
    public static final String FORMAT_date = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public Document createDocument(List<SitemapUrl> sitemapUrlList) throws Exception {
        Document document = BcXmlUtil.createDocument(Tag.urlset.name(), true);
        Element rootElem = document.getDocumentElement();
        XwebSitemapCreator.setXmlns(rootElem);
        int i = 0;
        while (i < sitemapUrlList.size()) {
            SitemapUrl sitemapUrl = sitemapUrlList.get(i);
            Element urlElement = BcXmlUtil.createElement(rootElem, Tag.url.name());
            Element locElement = BcXmlUtil.createElement(urlElement, Tag.loc.name());
            BcXmlUtil.setTextValue(locElement, sitemapUrl.loc);
            Element lastmodElement = BcXmlUtil.createElement(urlElement, Tag.lastmod.name());
            String lastmod = XwebSitemapCreator.toUtcString(sitemapUrl.lastmod);
            BcXmlUtil.setTextValue(lastmodElement, lastmod);
            ++i;
        }
        return document;
    }

    public static void setXmlns(Element element) throws Exception {
        element.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
    }

    public static String toUtcString(Calendar calendar) throws Exception {
        Date baseDate = calendar.getTime();
        DateTimeFormatter form = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        LocalDateTime dateTime = LocalDateTime.of(2023, 12, 17, 12, 10, 50);
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Asia/Tokyo"));
        zonedDateTime.format(DateTimeFormatter.ISO_DATE_TIME);
        String utcDate = zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx"));
        return utcDate;
    }

    public static enum Tag {
        urlset,
        url,
        loc,
        lastmod,
        changefreq,
        priority;

    }

    public static enum TimeZoneId {
        UTC(null),
        Asia_Tokyo("Asia/Tokyo"),
        Europe_London("Europe/London"),
        Asia_Kuwait("Asia/Kuwait"),
        America_New_York("America/New_York"),
        America_Los_Angeles("America/Los_Angeles"),
        US_Hawaii("US/Hawaii");

        private final String id;

        private TimeZoneId(String id) {
            this.id = XwebUtil.enumName(this, id);
        }
    }
}

