/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.rmo;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilTagUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf3.server.ScfSqlServerTask;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XfilUriEntityListRMO
extends RmiAbstractRMO {
    String tableName;
    String tableNameAlias;

    public XfilUriEntityListRMO() {
        this.tableNameAlias = this.tableName = XfilConstants.TableName.xfil_entity.name();
    }

    public void list(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfSqlServerTask queryServerTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase(sqlContext, selectQuery);
        queryServerTask.query = sqlContext.buildSelectQuery(selectQuery);
        this.getLogger().debug("query=" + queryServerTask.query);
        queryServerTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryServerTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryServerTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlConditionParser conditionParser = XfilUtil.createConditionParser(sqlContext);
        if (analysisCondition.indexGroupId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".index_group_id = " + analysisCondition.indexGroupId);
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.crawlerId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("xfil_crawl.crawler_id = " + analysisCondition.crawlerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.registrationPeriodStart > 0 || analysisCondition.registrationPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".add_timestamp", analysisCondition.registrationPeriodStart, analysisCondition.registrationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(analysisCondition.keyword)) {
            SqlWhereElement whereElement2;
            this.getLogger().debug("keyword=" + analysisCondition.keyword);
            ArrayList<SqlWhereElement> whereElementList = new ArrayList<SqlWhereElement>();
            StringBuilder sb = new StringBuilder();
            List<String> wordList = BcCsvUtil.parseCsvRow(analysisCondition.keyword, false);
            int i = 0;
            while (i < wordList.size()) {
                String word = wordList.get(i);
                if (i > 0) {
                    sb.append(" OR ");
                }
                sb.append(String.valueOf(sqlContext.func_Lower(String.valueOf(this.tableNameAlias) + ".tag")) + sqlContext.toKeyword(XfilTagUtil.toKeyword(word)));
                ++i;
            }
            if (!BcStringUtil.isEmpty(sb)) {
                SqlWhereElement whereElement3 = new SqlWhereElement();
                whereElement3.setLogical_OR();
                whereElement3.setFormula("(" + sb + ")");
                whereElementList.add(whereElement3);
            }
            if ((whereElement2 = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableNameAlias) + ".directory_", String.valueOf(this.tableNameAlias) + ".directory_", analysisCondition.keyword, null, false)) != null) {
                whereElement2.setLogical_OR();
                whereElementList.add(whereElement2);
            }
            if ((whereElement2 = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableNameAlias) + ".name_", String.valueOf(this.tableNameAlias) + ".name_", analysisCondition.keyword, null, false)) != null) {
                whereElement2.setLogical_OR();
                whereElementList.add(whereElement2);
            }
            if ((whereElement2 = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableNameAlias) + ".extention_", String.valueOf(this.tableNameAlias) + ".extention_", analysisCondition.keyword, null, false)) != null) {
                whereElement2.setLogical_OR();
                whereElementList.add(whereElement2);
            }
            if (!BcCollectionUtil.isEmpty(whereElementList)) {
                SqlWhereElement whereElementWk = new SqlWhereElement();
                whereElementWk.setLogical_AND();
                whereElementWk.setFormula("(" + sqlContext.buildWhereClause(whereElementList) + ")");
                selectQuery.addWhereElement(whereElementWk);
            }
        }
        if (analysisCondition.isFile) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".child_count < 0");
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.isDirectory) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".child_count >= 0");
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.fileCreationPeriodStart > 0 || analysisCondition.fileCreationPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".creation_timestamp", analysisCondition.fileCreationPeriodStart, analysisCondition.fileCreationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.fileModifiedPeriodStart > 0 || analysisCondition.fileModifiedPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".last_modified_timestamp", analysisCondition.fileModifiedPeriodStart, analysisCondition.fileModifiedPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.fileAccessPeriodStart > 0 || analysisCondition.fileAccessPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableNameAlias) + ".last_access_timestamp", analysisCondition.fileAccessPeriodStart, analysisCondition.fileAccessPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.missingOnly) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(this.tableNameAlias) + ".missing_timestamp Is Not Null");
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "index_group_id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "directory_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "name_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "size_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "duration_millis"));
        if (analysisCondition.resolutionColumn) {
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "width"));
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "height"));
        }
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "thumbnail_files"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "image_files"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "tag"));
        if (analysisCondition.registrationDateTimeColumn) {
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "add_timestamp"));
        }
        if (analysisCondition.fileAttributeColumn) {
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "creation_datetime"));
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "last_modified_datetime"));
            selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "last_access_datetime"));
        }
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "text_02"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableNameAlias, "missing_timestamp"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        if (analysisCondition.crawlerId > 0L) {
            sb.append(" LEFT JOIN xfil_crawl ON xfil_crawl.id = crawl_id");
        }
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlContext sqlContext, SqlSelectQuery selectQuery) throws Exception {
        selectQuery.getOrderByList().add(sqlContext.createTableColumnName(this.tableNameAlias, "directory_"));
        selectQuery.getOrderByList().add(sqlContext.createTableColumnName(this.tableNameAlias, "name_"));
    }

    public static enum Method implements RmiRemoteMethod
    {
        list;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

