/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.httpserver;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.httpserver.HttpServerController;
import jp.co.extreme.module.xdts.httpserver.XdtsHttpServerTask;
import jp.co.extreme.task.TskAbstractCallable2;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskManager;
import org.eclipse.jetty.util.component.LifeCycle;

public class XdtsHttpServerController
extends BcLoggableObject
implements HttpServerController {
    InnerHttpServerTask task;
    BcMonitor monitor = new BcMonitor();

    @Override
    public BcResult start(HtsvSiteContext siteContext, String hostName, int port, int sessionTimeout) throws Exception {
        if (this.task == null) {
            this.task = new InnerHttpServerTask();
        }
        this.task.siteContext = siteContext;
        this.task.hostName = hostName;
        this.task.port = port;
        this.task.sessionTimeout = sessionTimeout;
        this.task.setLogger(this.getLogger());
        this.monitor.lock();
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.task.future = executorService.submit(this.task);
        executorService.shutdown();
        BcResult result = new BcResult();
        this.monitor.sync();
        this.getLogger().info("sync:#1");
        this.getLogger().info("task.getThrowable()=" + this.task.getThrowable());
        if (this.task.getThrowable() == null) {
            TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable2)this.task, this.task.future);
            TskTaskManager.getInstance().addCallableUnit(callableUnit);
        } else {
            result.addError(this.task.getThrowable());
        }
        return result;
    }

    @Override
    public BcResult stop() throws Exception {
        this.task.server.stop();
        BcResult result = new BcResult();
        return result;
    }

    class InnerHttpServerTask
    extends XdtsHttpServerTask {
        InnerHttpServerTask() {
        }

        @Override
        public void lifeCycleStarted(LifeCycle lifeCycle) {
            super.lifeCycleStarted(lifeCycle);
            XdtsHttpServerController.this.monitor.unLock();
        }
    }
}

