/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.tree.FxTreeCell;
import jp.co.extreme.fx.tree.FxTreeFolder;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.mmdx.stub.MmdxModelStub;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsDefinitionCreatePane;
import jp.co.extreme.module.xdts.fx.XdtsFxLauncher;
import jp.co.extreme.module.xdts.fx.XdtsObjectTreeUtil;
import jp.co.extreme.module.xdts.fx.XdtsPersistence;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeItemHelper;
import jp.co.extreme.module.xdts.fx.XdtsTransferPane;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Auto;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Sql;
import jp.co.extreme.scf6.fx.TmpTableViewPane;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.model.SqlSelectQuery;

class XdtsTableTreeItemHelper
extends XdtsProfileTreeItemHelper {
    List<XdtsSchemaObject> schemaObjectList;
    ContextMenu contextMenu;
    MenuItem refreshMenuItem;
    MenuItem dataViewConditionMenuItem;
    MenuItem dataViewSqlMenuItem;
    MenuItem createExtractionConditionMenuItem;
    MenuItem deleteMenuItem;
    MenuItem trancateMenuItem;
    MenuItem tableManipulationMenuItem;
    MenuItem createCreateTableSqlMenuItem;
    MenuItem createInsertSqlMenuItem;
    MenuItem copyToOtherDbMenuItem;
    MenuItem createDefinitionMenuItem;
    MenuItem countSizeMenuItem;
    MenuItem createModelMenuItem;

    XdtsTableTreeItemHelper() {
    }

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(BcWords.getInstance().table, (Object)FxTreeFolder.FolderType.subRoot));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("tables_64x64.png"));
        return treeItem;
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (XdtsSchemaObject.class.isInstance(treeItem.getValue())) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            str = XdtsUtil.apendLogicalName(this.wordManager, schemaObject.name1);
        } else {
            str = super.getItemText(treeItem);
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        super.refresh();
        this.initTree();
    }

    protected void initTree() throws Exception {
        List<String> tableNameList = XdtsSchemaStub.getInstance().getTableNameList(this.profile.getEntityId());
        List<XdtsSchemaObject> schemaObjectList = XdtsUtil.toSchemaObjectList(tableNameList, XdtsConstants.SchemaObjectType.table, true);
        this.setSchemaObjectList(schemaObjectList);
    }

    protected void setSchemaObjectList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        this.schemaObjectList = schemaObjectList;
        this.getSubTreeItem().getChildren().clear();
        ArrayList<FxTreeItem> treeItemList = new ArrayList<FxTreeItem>();
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            FxTreeItem treeItem = this.creaeTreeItem();
            treeItem.setValue(schemaObject);
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
            treeItemList.add(treeItem);
            ++i;
        }
        this.getSubTreeItem().getChildren().addAll(treeItemList);
        String str = String.format(String.valueOf(BcWords.getInstance().table) + "(%d)", treeItemList.size());
        this.getSubTreeItem().setValue(new FxTreeFolder(str, (Object)FxTreeFolder.FolderType.subRoot));
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        super.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        if (treeItem.getParent() == this.getSubTreeItem() && doubleClicked) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            this.profileTreeView.parentPane.profilePane.addTable(schemaObject.name1, -1);
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.deleteMenuItem = new MenuItem(String.valueOf(BcWords.getInstance().delete) + "(" + SqlWords.getInstance().sql_DROP_TABLE + ")", (Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
            this.deleteMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewConditionMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Condition, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewConditionMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewSqlMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Sql, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.createExtractionConditionMenuItem = new MenuItem(XdtsWords.getInstance().createExtractionConditions, (Node)FxImageHelper.createImageView_icon("form_64x64.png"));
            this.createExtractionConditionMenuItem.setOnAction(contextMeneEventHandler);
            this.trancateMenuItem = new MenuItem(SqlWords.getInstance().sql_TRUNCATE_TABLE, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.trancateMenuItem.setOnAction(contextMeneEventHandler);
            this.tableManipulationMenuItem = new MenuItem(XdtsWords.getInstance().GRANT_REVOKE_etc, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.tableManipulationMenuItem.setOnAction(contextMeneEventHandler);
            this.createCreateTableSqlMenuItem = new MenuItem(XdtsWords.getInstance().createCreateTableSql, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.createCreateTableSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.createInsertSqlMenuItem = new MenuItem(XdtsWords.getInstance().createInsertSql, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.createInsertSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.copyToOtherDbMenuItem = new MenuItem(XdtsWords.getInstance().copyToOtherDb, (Node)FxImageHelper.createImageView_icon("db_copy_64x64.png"));
            this.copyToOtherDbMenuItem.setOnAction(contextMeneEventHandler);
            this.countSizeMenuItem = new MenuItem(XdtsWords.getInstance().numberOfRows_size.toPlain(), (Node)FxImageHelper.createImageView_icon("calculator_64x64.png"));
            this.countSizeMenuItem.setOnAction(contextMeneEventHandler);
            this.createDefinitionMenuItem = new MenuItem(XdtsWords.getInstance().cretaeTableDefinition, (Node)FxImageHelper.createImageView_icon("document_64x64.png"));
            this.createDefinitionMenuItem.setOnAction(contextMeneEventHandler);
            this.createModelMenuItem = new MenuItem("\u30e2\u30c7\u30eb\u4f5c\u6210", (Node)FxImageHelper.createImageView_icon("db_64x64.png"));
            this.createModelMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.dataViewConditionMenuItem.setUserData((Object)treeCell);
        this.dataViewSqlMenuItem.setUserData((Object)treeCell);
        this.createExtractionConditionMenuItem.setUserData((Object)treeCell);
        this.deleteMenuItem.setUserData((Object)treeCell);
        this.trancateMenuItem.setUserData((Object)treeCell);
        this.tableManipulationMenuItem.setUserData((Object)treeCell);
        this.createInsertSqlMenuItem.setUserData((Object)treeCell);
        this.createCreateTableSqlMenuItem.setUserData((Object)treeCell);
        this.copyToOtherDbMenuItem.setUserData((Object)treeCell);
        this.countSizeMenuItem.setUserData((Object)treeCell);
        this.createDefinitionMenuItem.setUserData((Object)treeCell);
        this.createModelMenuItem.setUserData((Object)treeCell);
        this.contextMenu.getItems().clear();
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu.getItems().add((Object)this.trancateMenuItem);
            this.contextMenu.getItems().add((Object)this.tableManipulationMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.createCreateTableSqlMenuItem);
            this.contextMenu.getItems().add((Object)this.createInsertSqlMenuItem);
            this.contextMenu.getItems().add((Object)this.copyToOtherDbMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.countSizeMenuItem);
            if (XdtsConstants.isTableDefinition()) {
                this.contextMenu.getItems().add((Object)this.createDefinitionMenuItem);
            }
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.refreshMenuItem);
        } else {
            this.contextMenu.getItems().add((Object)this.dataViewConditionMenuItem);
            this.contextMenu.getItems().add((Object)this.dataViewSqlMenuItem);
            this.contextMenu.getItems().add((Object)this.createExtractionConditionMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu.getItems().add((Object)this.trancateMenuItem);
            this.contextMenu.getItems().add((Object)this.tableManipulationMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.createCreateTableSqlMenuItem);
            this.contextMenu.getItems().add((Object)this.createInsertSqlMenuItem);
            this.contextMenu.getItems().add((Object)this.copyToOtherDbMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.countSizeMenuItem);
            if (XdtsConstants.isTableDefinition()) {
                this.contextMenu.getItems().add((Object)this.createDefinitionMenuItem);
            }
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.refreshMenuItem);
        }
        treeCell.setContextMenu(this.contextMenu);
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.refreshMenuItem) {
            this.initTree();
        } else if (ev.getSource() == this.dataViewConditionMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            XdtsExtractionCondition extractionCondition = XdtsObjectTreeUtil.createExtractionCondition(this.profile.getEntityId(), schemaObject, (Node)this.getTreeView());
            String fileName2 = XdtsPersistence.createFileName(this.profile.getEntityId(), XdtsConstants.Category.dev, schemaObject.name1, XdtsConstants.FileType.user);
            XdtsUserSetting userSetting = (XdtsUserSetting)XdtsPersistence.readObject(fileName2);
            if (userSetting == null) {
                userSetting = new XdtsUserSetting();
            }
            XdtsDataViewPanel_Auto dataViewPanel = new XdtsDataViewPanel_Auto();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setData(extractionCondition, userSetting, true);
            dataViewPanel.setTitle(String.valueOf(this.profile.name) + " : " + schemaObject.name1);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.dataViewSqlMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(this.profile.getEntityId(), schemaObject.name1);
            SqlSelectQuery selectQuery = XdtsSqlConditionUtil.createSelectQuery(this.sqlContext, mmdModel);
            XdtsUtil.setOption(selectQuery);
            XdtsCustomSql customSql = new XdtsCustomSql();
            customSql.sql = this.sqlContext.buildSelectQuery(selectQuery).toString();
            customSql.name = String.valueOf(this.profile.name) + " : " + schemaObject.name1;
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.createExtractionConditionMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            XdtsExtractionCondition extractionCondition = XdtsObjectTreeUtil.createExtractionCondition(this.profile.getEntityId(), schemaObject, (Node)this.getTreeView());
            XdtsFxLauncher.extractionCondition(this.sqlContext, extractionCondition);
        } else if (ev.getSource() == this.deleteMenuItem || ev.getSource() == this.trancateMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            if (ev.getSource() == this.deleteMenuItem) {
                transferPane.setProfile(this.profile, XdtsTransferPane.Mode.dropTable);
            } else if (ev.getSource() == this.trancateMenuItem) {
                transferPane.setProfile(this.profile, XdtsTransferPane.Mode.truncateTable);
            }
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.tableManipulationMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.tableManipulation);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createCreateTableSqlMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.createCreateTableSql);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createInsertSqlMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.createInsertSql);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.copyToOtherDbMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.copyToOtherDb);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createDefinitionMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsDefinitionCreatePane definitionCreatePane = new XdtsDefinitionCreatePane(this.profile);
            definitionCreatePane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            definitionCreatePane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.countSizeMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            BcTableModel tableModel = XdtsSchemaStub.getInstance().countSize(this.profile.getEntityId(), selectedSchemaObjectList, this.getTreeView().getScene().getWindow());
            FxTableView tableView = new FxTableView();
            FxTableUtil.createColumn(tableModel.getTableColumnModel(), tableView, null);
            FxTableRowList tableRowList = new FxTableRowList(tableModel);
            tableView.setItems(tableRowList);
            TmpTableViewPane tmpTableViewPane = new TmpTableViewPane();
            tmpTableViewPane.setTableView(tableView);
            tmpTableViewPane.tableControlPane.setData(tableModel.getTableColumnModel(), tableModel, null);
            tmpTableViewPane.tableControlPane.setTitle(this.countSizeMenuItem.getText());
            Tab tab = new Tab();
            tab.setText(tmpTableViewPane.tableControlPane.getTitle());
            tab.setContent((Node)tmpTableViewPane);
            tab.closableProperty().set(true);
            this.profileTreeView.parentPane.profilePane.tabPane1.getTabs().add((Object)tab);
            this.profileTreeView.parentPane.profilePane.tabPane1.getSelectionModel().select((Object)tab);
        } else if (ev.getSource() == this.createModelMenuItem) {
            XdtsTableTreeItemHelper.modelCreateTest(this.profile, this.schemaObjectList);
        }
    }

    public List<XdtsSchemaObject> getSelectedSchemaObjectList(FxTreeItem treeItem) throws Exception {
        List<XdtsSchemaObject> selectedSchemaObject = null;
        if (treeItem == this.getSubTreeItem()) {
            selectedSchemaObject = this.schemaObjectList;
        } else {
            selectedSchemaObject = new ArrayList<XdtsSchemaObject>();
            ObservableList treeItemList = this.getTreeView().getSelectionModel().getSelectedItems();
            int i = 0;
            while (i < treeItemList.size()) {
                FxTreeItem treeItemWk = (FxTreeItem)((Object)treeItemList.get(i));
                if (treeItemWk.getParent() == this.getSubTreeItem()) {
                    XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItemWk.getValue();
                    selectedSchemaObject.add(schemaObject);
                }
                ++i;
            }
        }
        return selectedSchemaObject;
    }

    public static void modelCreateTest(XdtsProfile profile, List<XdtsSchemaObject> tableObjectList) throws Exception {
        List<String> objectNameList = XdtsUtil.toNameList(tableObjectList);
        Map<String, MmdxModel> mdxMap = XdtsSchemaStub.getInstance().getXmmdModelMap(profile.getEntityId(), objectNameList);
        int i = 0;
        while (i < objectNameList.size()) {
            String shemaObjectName = objectNameList.get(i);
            MmdxModel mmdxModel = mdxMap.get(shemaObjectName);
            MmdxModelStub.getInstance().putDataModel(mmdxModel);
            ++i;
        }
    }
}

