/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.fx.XdtsHttpConfigPane;
import jp.co.extreme.module.xdts.fx.XdtsProfileSelectPane2;
import jp.co.extreme.module.xdts.fx.XdtsStagePane;
import jp.co.extreme.module.xdts.rmo.XdtsHttpServerRMO;
import jp.co.extreme.module.xdts.stub.XdtsHttpServerStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf4.fx.HfxProcessingPane;

public class XdtsHttpServerPane
extends XdtsStagePane {
    FxBorderPane borderPane = new FxBorderPane();
    XdtsHttpConfigPane httpConfigPane = new XdtsHttpConfigPane();
    XdtsProfileSelectPane2 profileSelectPane = new XdtsProfileSelectPane2();
    FxButton startButton = FxUtil.createStartButton();
    FxButton stopButton = FxUtil.createStopButton();
    FxButton closeButton = FxUtil.createCloseButton();
    HtsvSiteContext siteContext;

    public XdtsHttpServerPane() throws Exception {
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.httpConfigPane.setPrefHeight(260.0);
        this.borderPane.setTop((Node)this.httpConfigPane);
        this.profileSelectPane.setPrefHeight(440.0);
        this.borderPane.setCenter((Node)this.profileSelectPane);
        this.startButton.setOnAction(this.actionEventHandler);
        this.stopButton.setOnAction(this.actionEventHandler);
        FlowPane flowPane2 = new FlowPane();
        flowPane2.setOrientation(Orientation.HORIZONTAL);
        flowPane2.setAlignment(Pos.CENTER);
        flowPane2.setHgap(8.0);
        flowPane2.getChildren().addAll((Object[])new Node[]{this.startButton, this.stopButton});
        flowPane2.setPrefHeight(40.0);
        this.borderPane.setBottom((Node)flowPane2);
        this.setCenter((Node)this.borderPane);
        this.underLineEnabled();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.closeButton);
        this.siteContext = XdtsHttpServerStub.getInstance().getSiteContext();
        String jsonStr = this.siteContext.propertyMap.get(XdtsConstants.Property.httpServer.name());
        Map map = (Map)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        this.httpConfigPane.setData(map);
        this.profileSelectPane.setData(this.siteContext);
        this.stopButton.setDisable(true);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.startButton) {
            BcResult result1 = new BcResult();
            BcResult result2 = this.httpConfigPane.validation();
            result1.addResult(result2);
            result2 = this.profileSelectPane.validation();
            result1.addResult(result2);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            this.httpConfigPane.storeData(map);
            this.profileSelectPane.storeData(this.siteContext);
            String jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(map);
            this.siteContext.propertyMap.put(XdtsConstants.Property.httpServer.name(), jsonStr);
            this.startButton.setDisable(true);
            RmiRequest rmiReq = new RmiRequest();
            rmiReq.setClassName(XdtsHttpServerRMO.class.getName());
            rmiReq.setMethodName(XdtsHttpServerRMO.Method.start.name());
            rmiReq.addData(this.siteContext);
            InnerProcessingPane processingPane = new InnerProcessingPane();
            processingPane.setRequest(rmiReq);
            processingPane.successfullyMessageEnable = false;
            processingPane.show("HTTP Server starting...", (Window)this.getStage());
        } else if (ev.getSource() == this.stopButton) {
            this.stopButton.setDisable(true);
            try {
                BcResult result = XdtsHttpServerStub.getInstance().stop();
                this.startButton.setDisable(false);
            }
            catch (Exception ex) {
                this.stopButton.setDisable(false);
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    @Override
    public void close() throws Exception {
        this.getStage().hide();
    }

    @Override
    protected Stage createStage() throws Exception {
        Stage stage = super.createStage();
        stage.setWidth(1080.0);
        stage.setHeight(820.0);
        stage.setResizable(false);
        stage.getIcons().add((Object)FxImageHelper.getImage("web_64x64.png"));
        return stage;
    }

    class InnerProcessingPane
    extends HfxProcessingPane {
        @Override
        protected void successed() {
            super.successed();
            this.getLogger().error("successed:");
            try {
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RmiRespons rmiRes = InnerProcessingPane.this.getResponse();
                            BcResult result3 = (BcResult)rmiRes.getData();
                            if (result3.hasError()) {
                                String msg = BcMessageCreator.getInstance().createMessage(result3.getErrorList());
                                FxOptionPane.showMessageDialog((Node)XdtsHttpServerPane.this, (Object)msg, BcWords.getInstance().error, 0);
                                ((InnerProcessingPane)InnerProcessingPane.this).XdtsHttpServerPane.this.startButton.setDisable(false);
                            } else {
                                ((InnerProcessingPane)InnerProcessingPane.this).XdtsHttpServerPane.this.stopButton.setDisable(false);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }
}

