/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.model.v001.XdtsColumn;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsElemet;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderBy;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderByElement;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsExtractionConditionCreator
extends BcLoggableObject {
    public static XdtsExtractionConditionCreator getInstance() {
        return SingletonHolder.instance;
    }

    public XdtsExtractionCondition createExtractionCondition(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.name = mmdModel.tableName;
        extractionCondition.sqlTemplate = extractionCondition.sqlOrign = "SELECT * FROM " + mmdModel.tableName;
        extractionCondition.selectList = new ArrayList<XdtsSelect>();
        XdtsSelect selectContext = new XdtsSelect();
        extractionCondition.selectList.add(selectContext);
        selectContext.controlContextList = new ArrayList<XdtsControlContext>();
        selectContext.columnList = new ArrayList<XdtsColumn>();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        int i = 0;
        while (i < tableColumnNameList.size()) {
            String tableColumnName = tableColumnNameList.get(i);
            XdtsColumn selectColumn = this.toSelectColumn(tableColumnName);
            selectColumn.order = i + 1;
            selectContext.columnList.add(selectColumn);
            ++i;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createFromContext();
        XdtsElemet xdtsElemet = new XdtsElemet();
        xdtsElemet.template = xdtsElemet.orign = mmdModel.tableName;
        selectContext.from = xdtsElemet;
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        selectContext.whereBase = xdtsElemet = new XdtsElemet();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createOrderByContext();
        selectContext.orderByList = this.createOrderByList(mmdModel);
        if (!BcCollectionUtil.isEmpty(selectContext.orderByList)) {
            XdtsOrderBy xdtsOrderBy = BcCollectionUtil.getFirst(selectContext.orderByList);
            controlContext.defaultValue = XdtsSqlConditionUtil.toOrderByString(xdtsOrderBy);
        }
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createRowLimitContext();
        selectContext.controlContextList.add(controlContext);
        List<XdtsControlContext> controlContextList = XdtsSqlParserUtil.createControlContextList(mmdModel.fieldList);
        selectContext.controlContextList.addAll(controlContextList);
        return extractionCondition;
    }

    public XdtsColumn toSelectColumn(String src) throws Exception {
        XdtsColumn selectColumn = new XdtsColumn();
        selectColumn.elemet = new XdtsElemet();
        selectColumn.elemet.template = src;
        return selectColumn;
    }

    public List<XdtsOrderBy> createOrderByList(MmdModel mmdModel) throws Exception {
        ArrayList<XdtsOrderBy> orderByList = new ArrayList<XdtsOrderBy>();
        MmdIndex primaryIndex = mmdModel.getPrimaryIndex();
        if (primaryIndex != null) {
            XdtsOrderBy xdtsOrderBy = this.toXdtsOrderBy(primaryIndex);
            orderByList.add(xdtsOrderBy);
        }
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            XdtsOrderBy xdtsOrderBy = this.toXdtsOrderBy(mmdIndex);
            orderByList.add(xdtsOrderBy);
        }
        return orderByList;
    }

    public XdtsOrderBy toXdtsOrderBy(MmdIndex mmdIndex) throws Exception {
        XdtsOrderBy xdtsOrderBy = new XdtsOrderBy();
        for (MmdIndexElement mmdIndexElement : mmdIndex.indexElementList) {
            XdtsOrderByElement orderByElement = new XdtsOrderByElement();
            orderByElement.name = mmdIndexElement.columnName;
            orderByElement.isAscending = mmdIndexElement.isAscending;
            xdtsOrderBy.orderByElementList.add(orderByElement);
        }
        return xdtsOrderBy;
    }

    private static final class SingletonHolder {
        private static final XdtsExtractionConditionCreator instance = new XdtsExtractionConditionCreator();

        private SingletonHolder() {
        }
    }
}

