/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.server;

import java.io.File;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.httpserver.HtsvSiteContext;
import jp.co.extreme.module.wbs1.dao.Wbs1AccountDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1PersonBasicDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.Wbs1PersonBasic;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.person.util.PsnPersonUtil;

public class PersonManager
extends BcLoggableObject {
    static Map<String, PersonManager> instanceMap = new HashMap<String, PersonManager>();
    private String dataSourceName;
    private Map<Long, Wbs1Account> accountMap = new HashMap<Long, Wbs1Account>();
    private Map<Long, Wbs1PersonBasic> personMap = new HashMap<Long, Wbs1PersonBasic>();
    private Map<String, Wbs1Answer> profilenMap = new HashMap<String, Wbs1Answer>();

    public static PersonManager getInstance(String dataSourceName) {
        PersonManager instance = instanceMap.get(dataSourceName);
        if (instance == null) {
            instance = new PersonManager(dataSourceName);
            instanceMap.put(dataSourceName, instance);
        }
        return instance;
    }

    private PersonManager(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void crear(long personId) throws Exception {
        this.accountMap.remove(personId);
        this.personMap.remove(personId);
        this.profilenMap.remove(personId);
    }

    public Wbs1Account getAccountByPersonId(long personId) throws Exception {
        Wbs1Account account = this.accountMap.get(personId);
        if (account == null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(this.dataSourceName, this);){
                account = (Wbs1Account)Wbs1AccountDAO.getInstance().getByPersonId(dtsSession, personId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (account != null) {
                this.accountMap.put(personId, account);
            }
        }
        if (account == null) {
            this.getLogger().error("personId=" + personId + "\u306e Wbs1Account \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        return account;
    }

    public Wbs1PersonBasic getPersonBasic(long personId) throws Exception {
        Wbs1PersonBasic personBasic = this.personMap.get(personId);
        if (personBasic == null) {
            Object[] res = this.getPersonBasic2(personId);
            personBasic = (Wbs1PersonBasic)res[0];
            Wbs1Account account = (Wbs1Account)res[1];
            this.personMap.put(personBasic.id, personBasic);
            this.accountMap.put(account.personId, account);
        }
        return personBasic;
    }

    protected Object[] getPersonBasic2(long personId) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(this.dataSourceName, this);){
            Wbs1PersonBasic personBasic = (Wbs1PersonBasic)Wbs1PersonBasicDAO.getInstance().getById(dtsSession, personId);
            Wbs1Account account = (Wbs1Account)Wbs1AccountDAO.getInstance().getByPersonId(dtsSession, personId);
            return new Object[]{personBasic, account};
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getName(long personId) throws Exception {
        Wbs1PersonBasic personBasic = this.getPersonBasic(personId);
        String name = PsnPersonUtil.margeName(personBasic.firstName, personBasic.lastName);
        if (BcStringUtil.isEmpty(name)) {
            Wbs1Account account = this.accountMap.get(personId);
            name = account.nickname;
        }
        return name;
    }

    public Wbs1Answer getAnswer(long personId, long questionSetId) throws Exception {
        String key = String.valueOf(personId) + "-" + questionSetId;
        Wbs1Answer answer = this.profilenMap.get(personId);
        if (answer == null) {
            Throwable throwable = null;
            Object var8_8 = null;
            try (DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(this.dataSourceName, this);){
                WbsTempCondition tempCondition = new WbsTempCondition();
                tempCondition.personId = personId;
                answer = (Wbs1Answer)Wbs1AnswerDAO.getInstance().getByPersonId(dtsSession, tempCondition, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (answer != null) {
                this.profilenMap.put(key, answer);
            }
        }
        return answer;
    }

    public File getPersonDir(HtsvSiteContext siteContext, long personId) throws Exception {
        String dirName = "person_" + BcStringUtil.fillPrefix(personId, 8);
        File dir = new File(siteContext.getDatasourceDir(), dirName);
        BcFileUtil.mkdirs(dir, new FileAttribute[0]);
        return dir;
    }
}

