/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1AccountDAO
extends OrmAbstractDAO<Wbs1Account> {
    private Wbs1AccountDAO() {
        super(new Wbs1Account[0]);
        this.setTableName("wbs1_account");
    }

    public static Wbs1AccountDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsTempCondition tempCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (!BcStringUtil.isEmpty(tempCondition.loginId)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "login_id" + sqlContext.toCondition_string("=", tempCondition.loginId));
            selectQuery.addWhereElement(whereElement);
        }
        if (tempCondition.personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + tempCondition.personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tempCondition.accountTemporaryId)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "temporary_id" + sqlContext.toCondition_string("=", tempCondition.accountTemporaryId));
            selectQuery.addWhereElement(whereElement);
        }
        if (tempCondition.sex != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "sex_code" + sqlContext.toCondition_string("=", tempCondition.sex.code));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsTempCondition tempCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, tempCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByLoginId(DtsSession dtsSession, String loginId) throws Exception {
        if (BcStringUtil.isEmpty(loginId)) {
            return null;
        }
        WbsTempCondition tempCondition = new WbsTempCondition();
        tempCondition.loginId = loginId;
        List<T> entityList = this.getList(dtsSession, Mode.loginId, tempCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByPersonId(DtsSession dtsSession, long personId) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        WbsTempCondition tempCondition = new WbsTempCondition();
        tempCondition.personId = personId;
        List<T> entityList = this.getList(dtsSession, Mode.personId, tempCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByTemporaryId(DtsSession dtsSession, String temporaryId) throws Exception {
        if (BcStringUtil.isEmpty(temporaryId)) {
            return null;
        }
        WbsTempCondition tempCondition = new WbsTempCondition();
        tempCondition.accountTemporaryId = temporaryId;
        List<T> entityList = this.getList(dtsSession, Mode.temporaryId, tempCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1AccountDAO(Wbs1AccountDAO wbs1AccountDAO) {
        this();
    }

    public static enum Mode {
        loginId("login_id"),
        personId("person_id"),
        temporaryId("person_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1AccountDAO instance = new Wbs1AccountDAO(null);

        private SingletonHolder() {
        }
    }
}

