/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.fx;

import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.mmdx.fx.MmdxEventHandler;
import jp.co.extreme.module.mmdx.fx.MmdxFieldListPane;
import jp.co.extreme.module.mmdx.fx.MmdxFieldPane;
import jp.co.extreme.module.mmdx.fx.MmdxHeaderPane;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.mmdx.stub.MmdxModelStub;

public class MmdxModelEditor
implements MmdxEventHandler {
    protected FxDecoratePane decoratePane = new InnerDecoratePane();
    protected SplitPane splitPane = new SplitPane();
    protected MmdxHeaderPane mmdHeaderPane = new MmdxHeaderPane();
    protected MmdxFieldListPane fieldListPane = new MmdxFieldListPane();
    protected MmdxFieldPane mmdFieldPane = new MmdxFieldPane();
    protected MmdxModel mmdxModel1;
    protected MmdxModel mmdxModel2;
    protected Stage stage;

    public MmdxModelEditor() throws Exception {
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.mmdHeaderPane.setPrefSize(10.0, 100.0);
        this.decoratePane.setTop((Node)this.mmdHeaderPane);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.fieldListPane, this.mmdFieldPane});
        this.splitPane.setDividerPositions(new double[]{0.3f, 0.6f});
        this.decoratePane.setCenter((Node)this.splitPane);
        this.fieldListPane.addEventHandler(this);
        this.setFont(FxFontUtil.font_12b);
    }

    public void setFont(Font font) throws Exception {
        FxUtil.setFont((Node)this.decoratePane, font);
        FxUtil.setPrefSize((Node)this.decoratePane);
    }

    protected void storeData() throws Exception {
        this.mmdHeaderPane.storeData();
    }

    public void setData(MmdxModel mmdxModel1) throws Exception {
        this.mmdxModel1 = mmdxModel1;
        this.mmdxModel2 = BcCloneUtil.createClone(mmdxModel1);
        this.mmdHeaderPane.setXmmd(this.mmdxModel2);
        this.fieldListPane.setData(this.mmdxModel2, null);
        if (this.mmdxModel2.getFieldCount() <= 0) {
            MmdxField mmdxField = this.createDefault(1);
            this.mmdxModel2.addField(mmdxField);
            this.mmdSelected_L2(mmdxField);
        } else {
            MmdxField mmdxField = this.mmdxModel2.getField(0);
            this.mmdSelected_L2(mmdxField);
        }
    }

    public MmdxField createDefault(int seq) throws Exception {
        MmdxField mmdField = new MmdxField();
        mmdField.columnName = "field_" + seq;
        mmdField.sqlTypeId = 12;
        mmdField.dataSize = 20;
        return mmdField;
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new Stage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MmdxModelEditor.this.splitPane.setDividerPositions(new double[]{0.4f, 0.6f});
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.centerOnScreen();
        this.stage.setResizable(true);
        this.stage.setWidth(1400.0);
        this.stage.setHeight(800.0);
        this.stage.setTitle("Data Madel Editor");
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }

    @Override
    public void mmdSelected(Object obj) throws Exception {
        if (obj instanceof MmdxField) {
            MmdxField mmdField = (MmdxField)obj;
            if (this.mmdFieldPane.mmdxField != null) {
                this.mmdFieldPane.storeData();
                BcResult result = new BcResult();
                if (result.hasError()) {
                    String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                    FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                    return;
                }
            }
            this.mmdSelected_L2(mmdField);
        }
    }

    public void mmdSelected_L2(MmdxField mmdxField) throws Exception {
        this.mmdFieldPane.setXmmdField(mmdxField);
    }

    class InnerDecoratePane
    extends FxDecoratePane {
        Button completionButton;
        Button cancelButton;
        Button button3;

        public InnerDecoratePane() throws Exception {
            this.completionButton = this.createButton(BcWords.getInstance().completion);
            this.cancelButton = this.createButton(BcWords.getInstance().cancel);
            this.button3 = this.createButton("\u884c\u8ffd\u52a0");
        }

        @Override
        public void actionPerformed(ActionEvent ev) throws Exception {
            super.actionPerformed(ev);
            if (ev.getSource() == this.completionButton) {
                MmdxModelEditor.this.storeData();
                BcResult result = new BcResult();
                if (result.hasError()) {
                    String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                    FxOptionPane.showMessageDialog((Node)this, (Object)message, BcWords.getInstance().warning, 2);
                    return;
                }
                MmdxModelStub.getInstance().putDataModel(MmdxModelEditor.this.mmdxModel2);
                MmdxModelEditor.this.stage.close();
            } else if (ev.getSource() == this.cancelButton) {
                MmdxModelEditor.this.stage.close();
            } else if (ev.getSource() == this.button3) {
                MmdxField mmdField = MmdxModelEditor.this.createDefault(MmdxModelEditor.this.mmdxModel2.getFieldCount() + 1);
                MmdxModelEditor.this.mmdxModel2.addField(mmdField);
                MmdxModelEditor.this.mmdSelected_L2(mmdField);
                MmdxModelEditor.this.fieldListPane.setData(MmdxModelEditor.this.mmdxModel2, null);
            }
        }
    }
}

