/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.dao;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.impt.model.ImptDefineIndex;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class ImptDefineIndexDAO
extends OrmAbstractDAO {
    private ImptDefineIndexDAO() {
        super(new Object[0]);
        this.setTableName("impt_define_index");
    }

    public static ImptDefineIndexDAO getInstance() {
        return SingletonHolder.instance;
    }

    protected List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add("code");
        this.updateColumnList.add("name");
        this.updateColumnList.add("file_resource_id");
        this.updateColumnList.add("class_id");
        this.updateColumnList.add("display_no");
        this.updateColumnList.add("note_");
        return this.updateColumnList;
    }

    public List<Object> toValueList(Object entity) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        ImptDefineIndex importDefine = (ImptDefineIndex)entity;
        valueList.add(importDefine.code);
        valueList.add(importDefine.name);
        valueList.add(importDefine.fileResourceId);
        valueList.add(importDefine.classId);
        valueList.add(importDefine.displayNo);
        valueList.add(importDefine.note);
        return valueList;
    }

    public String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        String selectColumns = String.valueOf(this.getPersistenceProxy().createCommonSelectPhrase(ImptDefineIndex.class, tableAlias)) + asTable2 + "code" + asTable2 + "name" + asTable2 + "file_resource_id" + asTable2 + "class_id" + asTable2 + "display_no" + asTable2 + "note_";
        return selectColumns;
    }

    public void putDefineIndex(DtsSession dtsSession, ImptDefineIndex importDefine) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(importDefine);
        this.getPersistenceProxy().putEntity(dtsSession, this.tableName, columnList, valueList, importDefine);
    }

    public int deleteDefineIndex(DtsSession dtsSession, int importDefineId) throws Exception {
        int resValue = this.getPersistenceProxy().physicalDeleteByEntityId(dtsSession, this.tableName, importDefineId);
        return resValue;
    }

    public ImptDefineIndex getDefineIndex(DtsSession dtsSession, int importDefineId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getTableName() + this.getPersistenceProxy().createDataIdWhereClause(importDefineId);
        ImptDefineIndex defineIndex = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                defineIndex = new ImptDefineIndex();
                this.getDefineIndex(dtsSession, rs, columnIndex, defineIndex);
            }
            rs.close();
        }
        return defineIndex;
    }

    protected void getDefineIndex(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, ImptDefineIndex importDefine) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, importDefine);
        importDefine.code = rs.getString(columnIndex);
        importDefine.name = rs.getString(columnIndex);
        importDefine.fileResourceId = rs.getInt(columnIndex);
        importDefine.classId = rs.getInt(columnIndex);
        importDefine.displayNo = rs.getInt(columnIndex);
        importDefine.note = rs.getString(columnIndex);
    }

    public List<ImptDefineIndex> getDefineIndexList(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getTableName() + " WHERE display_no > 0" + " ORDER BY display_no";
        ArrayList<ImptDefineIndex> dataList = new ArrayList<ImptDefineIndex>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            BcInteger columnIndex = new BcInteger();
            while (rs.next()) {
                columnIndex.value = 0;
                ImptDefineIndex importDefine = new ImptDefineIndex();
                this.getDefineIndex(dtsSession, rs, columnIndex, importDefine);
                dataList.add(importDefine);
            }
            rs.close();
        }
        return dataList;
    }

    /* synthetic */ ImptDefineIndexDAO(ImptDefineIndexDAO imptDefineIndexDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ImptDefineIndexDAO instance = new ImptDefineIndexDAO(null);

        private SingletonHolder() {
        }
    }
}

