/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.arcv.dao.ArcvBinaryHelper;
import jp.co.extreme.module.dcmn.dao.DcmnDocumentTemplateDAO;
import jp.co.extreme.module.dcmn.dao.DcmnFileResourceDAO;
import jp.co.extreme.module.dcmn.model.DcmnDocumentTemplate;
import jp.co.extreme.poi.PoiWorkbookUtil;
import jp.co.extreme.scf5.model.ScfFileResource;
import org.apache.poi.ss.usermodel.Workbook;

public class DcmnServerUtil {
    private DcmnServerUtil() {
    }

    public static void putDocumentTemplate(DtsSession dtsSession, DcmnDocumentTemplate documentTemplate, String fileName) throws Exception {
        if (!BcStringUtil.isEmpty(fileName)) {
            File dir = new File(AfbApplication.getInstance().toReal("${APP}temp/"));
            File file = new File(dir, fileName);
            ScfFileResource fileResource = documentTemplate.fileResourceId <= 0L ? new ScfFileResource() : DcmnFileResourceDAO.getInstance().getFileResource(dtsSession, documentTemplate.fileResourceId);
            DcmnFileResourceDAO.getInstance().putFileResource(dtsSession, fileResource, file);
            documentTemplate.fileResourceId = fileResource.getDataId();
        }
        DcmnDocumentTemplateDAO.getInstance().putDocumentTemplate(dtsSession, documentTemplate);
    }

    public static Workbook getWorkbook(DtsSession dtsSession, int documentTemplateId) throws Exception {
        BcLogUtil.debug("documentTemplateId=" + documentTemplateId);
        DcmnDocumentTemplate documentTemplate = DcmnDocumentTemplateDAO.getInstance().getDocumentTemplate(dtsSession, documentTemplateId);
        BcLogUtil.debug("documentTemplate=" + documentTemplate);
        ArcvBinaryHelper binaryHelper = null;
        Workbook workbook = null;
        try {
            binaryHelper = DcmnFileResourceDAO.getInstance().getBinaryInputStream(dtsSession.getConnection(), documentTemplate.fileResourceId);
            if (binaryHelper == null) {
                return null;
            }
            BufferedInputStream bis = new BufferedInputStream(binaryHelper.is);
            ByteArrayOutputStream baos = BcStreamUtil.toBaos(bis);
            byte[] byts = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byts);
            workbook = PoiWorkbookUtil.createWorkbook(bais);
        }
        finally {
            binaryHelper.rs.close();
            binaryHelper.stmt.close();
        }
        return workbook;
    }

    public static Workbook getWorkbookByCode(DtsSession dtsSession, String documentTemplateCode) throws Exception {
        DcmnDocumentTemplate documentTemplate = DcmnDocumentTemplateDAO.getInstance().getDocumentTemplateByCode(dtsSession, documentTemplateCode);
        return DcmnServerUtil.getWorkbook(dtsSession, documentTemplate.getDataId());
    }
}

