/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.advm.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.SwgUtil;

class FxAdvancedStage
extends Stage {
    protected EventHandler<ActionEvent> actionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent ev) {
            try {
                FxAdvancedStage.this.actionPerformed(ev);
            }
            catch (Exception ex) {
                FxAdvancedStage.this.handleException(ex);
            }
        }
    };
    protected EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent ev) {
            try {
                FxAdvancedStage.this.mouseEvent(ev);
            }
            catch (Exception ex) {
                FxAdvancedStage.this.handleException(ex);
            }
        }
    };
    protected double initX;
    protected double initY;
    protected FxButton minButton = new FxButton("min");
    protected FxButton closButtone = new FxButton("close");
    FxBorderPane borderPane = new FxBorderPane();

    public FxAdvancedStage(StageStyle style) throws Exception {
        super(style);
        this.init();
    }

    protected void init() throws Exception {
        Node dragger = this.createDraggerShape();
        dragger.setOnMousePressed(this.mouseEventHandler);
        dragger.setOnMouseDragged(this.mouseEventHandler);
        this.minButton.setOnAction(this.actionEventHandler);
        this.closButtone.setOnAction(this.actionEventHandler);
        this.borderPane.setTop(dragger);
        this.borderPane.setEffect((Effect)FxEffectUtil.createDropShadow());
        FxScene scene = new FxScene((Parent)this.borderPane);
        this.setScene(scene);
        FxUtil.setWindowSize((Window)this, 400.0, 100.0, true);
    }

    protected Node createDraggerShape() throws Exception {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setPrefHeight(24.0);
        hBox.getChildren().addAll((Object[])new Node[]{this.minButton, this.closButtone});
        hBox.setStyle(FxCssUtil.css_backgroundColor(Color.AQUA));
        return hBox;
    }

    protected void actionPerformed(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.minButton) {
            this.setIconified(true);
        } else if (ev.getSource() == this.minButton) {
            this.close();
        }
    }

    public void mouseEvent(MouseEvent ev) throws Exception {
        if (ev.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.initX = ev.getScreenX() - this.getX();
            this.initY = ev.getScreenY() - this.getY();
        } else if (ev.getEventType() == MouseEvent.MOUSE_DRAGGED) {
            this.setX(ev.getScreenX() - this.initX);
            this.setY(ev.getScreenY() - this.initY);
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

