/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.util;

import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlUtil {
    public static final String ISTYLE_HIRAGANA = "1";
    public static final String ISTYLE_KATAKANA = "2";
    public static final String ISTYLE_ALPHABET = "3";
    public static final String ISTYLE_NUMERIC = "4";
    public static final String MODE_HIRAGANA = "hiragana";
    public static final String MODE_KATAKANA = "katakana";
    public static final String MODE_ALPHABET = "alphabet";
    public static final String MODE_NUMERIC = "numeric";
    public static final String FORMAT_ZENKAKU = "M";
    public static final String FORMAT_NUMERIC = "N";
    public static final String FORMAT_ALPHABET = "m";

    private HtmlUtil() {
    }

    public static String encode(String src) throws Exception {
        List<String> lineList = BcStringUtil.lineSeparete2(src);
        return HtmlUtil.encode(lineList);
    }

    public static String encode(Collection msgCollection) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcCollectionUtil.isEmpty(msgCollection)) {
            return sb.toString();
        }
        for (Object msg : msgCollection) {
            if (!BcStringUtil.isEmpty(sb)) {
                sb.append(HtmlBuilder.getInstance().br());
            }
            if (BcStringUtil.isEmpty(msg)) continue;
            sb.append(StringEscapeUtils.escapeHtml4((String)msg.toString()));
        }
        return sb.toString();
    }

    public static String encodeNotLineFeed(String src) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcStringUtil.isEmpty(src)) {
            return sb.toString();
        }
        char aChar = '\u0000';
        int i = 0;
        while (i < src.length()) {
            aChar = src.charAt(i);
            boolean isHit = false;
            HtmlConstants.HtmlSpecialCharacter[] htmlSpecialCharacterArray = HtmlConstants.HtmlSpecialCharacter.values();
            int n = htmlSpecialCharacterArray.length;
            int n2 = 0;
            while (n2 < n) {
                HtmlConstants.HtmlSpecialCharacter specialCharacter = htmlSpecialCharacterArray[n2];
                if (aChar == specialCharacter.aChar) {
                    sb.append(specialCharacter.value);
                    isHit = true;
                }
                ++n2;
            }
            if (!isHit) {
                sb.append(aChar);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void appendAddQua(StringBuilder sb, String data1, String data2) throws Exception {
        if (!BcStringUtil.isEmpty(data2)) {
            if (!BcStringUtil.isEmpty(data1)) {
                sb.append(data1);
            }
            sb.append(BcStringUtil.doubleQuotation(data2));
        }
    }

    public static StringBuilder link2(String urlStr, String para, String target, String cssClass, String label) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<a");
        sb.append(" href=");
        sb.append("\"" + urlStr);
        if (!BcStringUtil.isEmpty(para)) {
            sb.append("?" + para);
        }
        sb.append("\"");
        if (!BcStringUtil.isEmpty(target)) {
            sb.append(" target=" + BcStringUtil.doubleQuotation(target));
        }
        if (!BcStringUtil.isEmpty(cssClass)) {
            sb.append(" class=" + BcStringUtil.doubleQuotation(cssClass));
        }
        sb.append(">");
        sb.append(HtmlUtil.encode(label));
        sb.append("</a>");
        return sb;
    }

    public static StringBuilder link(String urlStr, String para, String target, String label) throws Exception {
        return HtmlUtil.link2(urlStr, para, target, null, label);
    }

    public static StringBuilder link(String urlStr, String para, String target, Object label) throws Exception {
        if (label != null) {
            return HtmlUtil.link2(urlStr, para, target, null, label.toString());
        }
        return HtmlUtil.link2(urlStr, para, target, null, null);
    }

    public static StringBuilder linkMenuWithImage(String urlStr, String para, String target, String cssClass, String image, String label) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<a");
        sb.append(" href=");
        sb.append("\"" + urlStr);
        if (!BcStringUtil.isEmpty(para)) {
            sb.append("?" + para);
        }
        sb.append("\"");
        if (!BcStringUtil.isEmpty(target)) {
            sb.append(" target=" + BcStringUtil.doubleQuotation(target));
        }
        if (!BcStringUtil.isEmpty(cssClass)) {
            sb.append(" class=" + BcStringUtil.doubleQuotation(cssClass));
        }
        sb.append(">");
        sb.append(String.valueOf(image) + HtmlUtil.encode(label));
        sb.append("</a>");
        return sb;
    }

    public static StringBuilder linkStartTag(String url, String target, String script) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<A");
        if (!BcStringUtil.isEmpty(url)) {
            sb.append(" href=" + BcStringUtil.doubleQuotation(url));
        }
        if (!BcStringUtil.isEmpty(target)) {
            sb.append(" target=" + BcStringUtil.doubleQuotation(target));
        }
        if (!BcStringUtil.isEmpty(script)) {
            sb.append(" " + script);
        }
        sb.append(">");
        return sb;
    }

    public static StringBuilder linkStartTag(String url, String target) throws Exception {
        return HtmlUtil.linkStartTag(url, target, null);
    }

    public static StringBuilder linkEndTag() {
        StringBuilder sb = new StringBuilder(8);
        sb.append("</A>\n");
        return sb;
    }

    public static boolean isHtml(String extention) {
        HtmlConstants.FileExtention[] fileExtentionArray = HtmlConstants.FileExtention.values();
        int n = fileExtentionArray.length;
        int n2 = 0;
        while (n2 < n) {
            HtmlConstants.FileExtention htmlExtention = fileExtentionArray[n2];
            if (htmlExtention.name().equalsIgnoreCase(extention)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

