/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.component;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.component.WhcBuilder;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.html.component.WhcHiddenField;
import jp.co.extreme.html.component.WhcLabel;
import jp.co.extreme.html.component.WhcSelect;
import jp.co.extreme.html.component.WhcSubmitButton;
import jp.co.extreme.html.component.WhcTable;
import jp.co.extreme.html.component.WhcTableCell;
import jp.co.extreme.html.component.WhcTableRow;
import jp.co.extreme.html.component.WhcTextArea;
import jp.co.extreme.html.component.WhcTextField;

public class WhcBuilder4Mobile
extends WhcBuilder {
    public WhcBuilder4Mobile(HtmlBuilder htmlBuilder) {
        super(htmlBuilder);
    }

    public StringBuilder createHtml(WhcTable wcTable, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        int i = 0;
        while (i < wcTable.getRowCount()) {
            WhcTableRow wcTableRow = wcTable.getRow(i);
            sb.append("<tr>");
            int j = 0;
            while (j < wcTableRow.valueList.size()) {
                WhcTableCell whcComponent = wcTableRow.valueList.get(j);
                if (WhcTableCell.class.isAssignableFrom(whcComponent.getClass())) {
                    WhcTableCell whcTableCell = whcComponent;
                    sb.append(this.htmlBuilder.tableCell(1, 1, whcTableCell.horizontalAlign, whcTableCell.verticalAlign));
                    int k = 0;
                    while (k < whcTableCell.childList.size()) {
                        Object obj = whcTableCell.childList.get(k);
                        if (obj != null) {
                            sb.append((CharSequence)this.createHtmlL2((WhcComponent)obj, isEdit));
                        }
                        ++k;
                    }
                    sb.append("</td>");
                    sb.append(this.htmlBuilder.lineSep);
                } else {
                    sb.append("<td>");
                    sb.append((CharSequence)this.createHtmlL2(whcComponent, isEdit));
                    sb.append("</td>");
                    sb.append(this.htmlBuilder.lineSep);
                }
                ++j;
            }
            sb.append("</tr>");
            sb.append(this.htmlBuilder.lineSep);
            ++i;
        }
        sb.append("</table>");
        sb.append(this.htmlBuilder.lineSep);
        return sb;
    }

    protected StringBuilder createHtmlL2(WhcComponent whcComponent, boolean isEdit) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (WhcLabel.class.isAssignableFrom(whcComponent.getClass())) {
            WhcLabel whcLabel = (WhcLabel)whcComponent;
            if (whcLabel.value != null) {
                sb.append(whcLabel.value.toString());
            }
        } else if (WhcHiddenField.class.isAssignableFrom(whcComponent.getClass())) {
            WhcHiddenField whcHiddenField = (WhcHiddenField)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcHiddenField.getValue(), String.class);
            if (isEdit) {
                sb.append(this.htmlBuilder.hidden(whcHiddenField.name, valueStr));
            } else if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcTextField.class.isAssignableFrom(whcComponent.getClass())) {
            WhcTextField whcTextField = (WhcTextField)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcTextField.getValue(), String.class);
            if (!isEdit && !BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcTextArea.class.isAssignableFrom(whcComponent.getClass())) {
            WhcTextArea whcTextArea = (WhcTextArea)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcTextArea.getValue(), String.class);
            if (isEdit) {
                StringBuilder sb2 = new StringBuilder(this.htmlBuilder.textArea(whcTextArea.getGlobalAttribute(), whcTextArea.name, valueStr, whcTextArea.columnCount, whcTextArea.rowCount));
                sb.append((CharSequence)sb2);
            } else if (!BcStringUtil.isEmpty(valueStr)) {
                sb.append(valueStr);
            }
        } else if (WhcSelect.class.isAssignableFrom(whcComponent.getClass())) {
            WhcSelect whcSelect = (WhcSelect)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcSelect.value, String.class);
            sb.append(this.htmlBuilder.select(whcSelect.name, whcSelect.getOptionList(), valueStr));
        } else if (WhcSubmitButton.class.isAssignableFrom(whcComponent.getClass())) {
            WhcSubmitButton whcSubmitButton = (WhcSubmitButton)whcComponent;
            String valueStr = (String)BcObjectConvertor.getInstance().convert(whcSubmitButton.getValue(), String.class);
            sb.append(this.htmlBuilder.inputButton(HtmlConstants.HtmlInputType.submit, whcSubmitButton.name, (Object)whcSubmitButton.getValue(), whcSubmitButton.disabled, whcSubmitButton.getGlobalAttribute().clazz, whcSubmitButton.script));
        } else if (CharSequence.class.isAssignableFrom(whcComponent.getClass())) {
            CharSequence charSequence = (CharSequence)((Object)whcComponent);
            sb.append(charSequence);
        } else {
            sb.append(whcComponent.toString());
        }
        return sb;
    }
}

