/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.media.AudioClip;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.sounds.SwgSoundUtil;

class FxOptionPaneWork
extends FxDecoratePane {
    protected int optionType;
    protected int messageType;
    protected int selectetOption = -1;
    protected Pane topPane = new Pane();
    protected VBox leftVBox = new VBox();
    protected Image image;
    protected FxTextArea textArea;
    protected FxButton button1;
    protected FxButton button2;
    protected FxButton button3;
    protected Stage stage = new FxStage(StageStyle.DECORATED);
    AudioClip audioClip;

    public FxOptionPaneWork() throws Exception {
        this.textArea = new FxTextArea();
    }

    protected void build() throws Exception {
        this.topPane.setPrefHeight(8.0);
        this.setTop((Node)this.topPane);
        ImageView imageView = new ImageView(this.image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(48.0);
        this.leftVBox.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
        this.leftVBox.getChildren().add((Object)imageView);
        this.setLeft((Node)this.leftVBox);
        this.textArea.setEditable(false);
        this.setCenter((Node)this.textArea);
        switch (this.optionType) {
            case -1: {
                this.button1 = FxUtil.createOkButton();
                this.button1.setOnAction(this.actionEventHandler);
                this.getControlPane().addControl((Node)this.button1);
                break;
            }
            case 0: {
                this.button1 = FxUtil.createOkButton(BcWords.getInstance().yes, null);
                this.button1.setOnAction(this.actionEventHandler);
                this.getControlPane().addControl((Node)this.button1);
                this.button2 = FxUtil.createCancelButton(BcWords.getInstance().no, null);
                this.button2.setOnAction(this.actionEventHandler);
                this.getControlPane().addControl((Node)this.button2);
                break;
            }
            case 1: {
                this.button1 = this.createButton(BcWords.getInstance().yes);
                this.button2 = this.createButton(BcWords.getInstance().no);
                this.button3 = this.createButton(BcWords.getInstance().cancel);
                break;
            }
            case 2: {
                this.button1 = FxUtil.createOkButton();
                this.button1.setOnAction(this.actionEventHandler);
                this.getControlPane().addControl((Node)this.button1);
                this.button2 = FxUtil.createCancelButton();
                this.button2.setOnAction(this.actionEventHandler);
                this.getControlPane().addControl((Node)this.button2);
            }
        }
        this.playAudio();
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.centerOnScreen();
        this.stage.setResizable(true);
        this.stage.setFullScreen(false);
        this.stage.setIconified(false);
        this.stage.setWidth(640.0);
        this.stage.setHeight(280.0);
        if (this.image != null) {
            this.stage.getIcons().add((Object)this.image);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                FxOptionPaneWork.this.button1.requestFocus();
            }
        });
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.button1) {
            switch (this.optionType) {
                case -1: 
                case 0: 
                case 1: 
                case 2: {
                    this.selectetOption = 0;
                }
            }
            this.stage.close();
        } else if (ev.getSource() == this.button2) {
            switch (this.optionType) {
                case 0: 
                case 1: {
                    this.selectetOption = 1;
                    break;
                }
                case 2: {
                    this.selectetOption = 2;
                }
            }
            this.stage.close();
        } else if (ev.getSource() == this.button3) {
            switch (this.optionType) {
                case 1: {
                    this.selectetOption = 2;
                }
            }
            this.stage.close();
        }
    }

    public void playAudio() throws Exception {
        if (this.audioClip == null) {
            URL soundUrl = SwgSoundUtil.getNotifyUrl();
            this.audioClip = new AudioClip(soundUrl.toString());
        }
        this.audioClip.play();
    }
}

