/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.io.File;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.swing.SwgUtil;

public class FxDndTargetHelper
extends BcLoggableObject {
    public void setup(Node target) throws Exception {
        target.setOnDragEntered((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                try {
                    FxDndTargetHelper.this.onDragEntered(ev);
                }
                catch (Exception ex) {
                    FxDndTargetHelper.this.handleException(ex);
                }
            }
        });
        target.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                try {
                    FxDndTargetHelper.this.onDragExited(ev);
                }
                catch (Exception ex) {
                    FxDndTargetHelper.this.handleException(ex);
                }
            }
        });
        target.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                try {
                    FxDndTargetHelper.this.onDragOver(ev);
                }
                catch (Exception ex) {
                    FxDndTargetHelper.this.handleException(ex);
                }
            }
        });
        target.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent ev) {
                try {
                    FxDndTargetHelper.this.onDragDropped(ev);
                }
                catch (Exception ex) {
                    FxDndTargetHelper.this.handleException(ex);
                }
            }
        });
    }

    protected void onDragEntered(DragEvent ev) throws Exception {
        ev.consume();
    }

    protected void onDragExited(DragEvent ev) throws Exception {
        ev.consume();
    }

    protected void onDragOver(DragEvent ev) throws Exception {
        ev.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        ev.consume();
    }

    protected void onDragDropped(DragEvent ev) throws Exception {
        Dragboard dragboard = ev.getDragboard();
        List fileList = dragboard.getFiles();
        if (!BcCollectionUtil.isEmpty(fileList)) {
            try {
                this.droppedFileList(dragboard.getFiles());
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        ev.setDropCompleted(dragboard.hasString());
        ev.consume();
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    protected void droppedFileList(List<File> fileList) throws Exception {
        this.getLogger().debug("droppedFileList:fileList.size()=" + fileList.size());
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            this.getLogger().debug("file=" + file.getPath());
            ++i;
        }
    }
}

