/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.comm;

import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.comm.CommSerialConstants;

public class CommSerialParameters {
    private String portName;
    private int baudRate;
    private int dataBits;
    private int stopBits;
    private int parity;
    private int flowControlIn;
    private int flowControlOut;

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setBaudRate(int baudRate) throws Exception {
        this.baudRate = baudRate;
    }

    public void setBaudRate(String baudRate) throws Exception {
        this.baudRate = BcNumberUtil.parseInt(baudRate, 0);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public String getBaudRateString() {
        return Integer.toString(this.baudRate);
    }

    public void setDataBits(int dataBits) throws Exception {
        this.dataBits = dataBits;
    }

    public void setDataBits(String dataBits) throws Exception {
        if (BcStringUtil.isEmpty(dataBits)) {
            String msg = BcInputValidator.getInstance().notReasonable(CommSerialConstants.SerialPortProperty.dataBits.name(), dataBits);
            throw new Exception(msg);
        }
        switch (dataBits) {
            case "5": {
                this.dataBits = 5;
                break;
            }
            case "6": {
                this.dataBits = 6;
                break;
            }
            case "7": {
                this.dataBits = 7;
                break;
            }
            case "8": {
                this.dataBits = 8;
                break;
            }
            default: {
                String msg = BcInputValidator.getInstance().notReasonable(CommSerialConstants.SerialPortProperty.dataBits.name(), dataBits);
                throw new Exception(msg);
            }
        }
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public String getDataBitsString() {
        return Integer.toString(this.dataBits);
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public void setStopBits(String stopBits) throws Exception {
        if (BcStringUtil.isEmpty(stopBits)) {
            String msg = BcInputValidator.getInstance().notReasonable(CommSerialConstants.SerialPortProperty.stopBits.name(), stopBits);
            throw new Exception(msg);
        }
        switch (stopBits) {
            case "1": {
                this.stopBits = 1;
                break;
            }
            case "1.5": {
                this.stopBits = 3;
                break;
            }
            case "2": {
                this.stopBits = 2;
                break;
            }
            default: {
                String msg = BcInputValidator.getInstance().notReasonable(CommSerialConstants.SerialPortProperty.stopBits.name(), stopBits);
                throw new Exception(msg);
            }
        }
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public String getStopBitsString() {
        switch (this.stopBits) {
            case 1: {
                return "1";
            }
            case 3: {
                return "1.5";
            }
            case 2: {
                return "2";
            }
        }
        return null;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public void setParity(String parityStr) throws Exception {
        CommSerialConstants.Parity parity = CommSerialConstants.Parity.valueOf(parityStr);
        if (parity == null) {
            String msg = BcInputValidator.getInstance().notReasonable(CommSerialConstants.SerialPortProperty.parity.name(), parityStr);
            throw new Exception(msg);
        }
        this.parity = parity.value;
    }

    public int getParity() {
        return this.parity;
    }

    public String getParityString() {
        CommSerialConstants.Parity[] parityArray = CommSerialConstants.Parity.values();
        int n = parityArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommSerialConstants.Parity parity = parityArray[n2];
            if (parity.value == this.parity) {
                return parity.name();
            }
            ++n2;
        }
        return null;
    }

    public void setFlowControlIn(int flowControlIn) {
        this.flowControlIn = flowControlIn;
    }

    public void setFlowControlIn(String flowControlIn) {
        this.flowControlIn = this.stringToFlow(flowControlIn);
    }

    public int getFlowControlIn() {
        return this.flowControlIn;
    }

    public String getFlowControlInString() {
        return this.flowToString(this.flowControlIn);
    }

    public void setFlowControlOut(int flowControlOut) {
        this.flowControlOut = flowControlOut;
    }

    public void setFlowControlOut(String flowControlOut) {
        this.flowControlOut = this.stringToFlow(flowControlOut);
    }

    public int getFlowControlOut() {
        return this.flowControlOut;
    }

    public String getFlowControlOutString() {
        return this.flowToString(this.flowControlOut);
    }

    protected int stringToFlow(String flowControl) {
        if (BcStringUtil.isEmpty(flowControl)) {
            return -1;
        }
        if (flowControl.equals("None")) {
            return 0;
        }
        if (flowControl.equals("Xon/Xoff Out")) {
            return 8;
        }
        if (flowControl.equals("Xon/Xoff In")) {
            return 4;
        }
        if (flowControl.equals("RTS/CTS In")) {
            return 1;
        }
        if (flowControl.equals("RTS/CTS Out")) {
            return 2;
        }
        return 0;
    }

    protected String flowToString(int flowControl) {
        switch (flowControl) {
            case 0: {
                return "None";
            }
            case 8: {
                return "Xon/Xoff Out";
            }
            case 4: {
                return "Xon/Xoff In";
            }
            case 1: {
                return "RTS/CTS In";
            }
            case 2: {
                return "RTS/CTS Out";
            }
        }
        return "None";
    }
}

