/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;

public final class BcRegexUtil {
    public static final char ESAPE = '\\';
    public static final String ESAPE_STR = Character.toString('\\');
    public static final String SPACE = "\\s";
    public static final String \u534a\u89d2\u6570\u5b57 = "[0-9]";
    public static final String \u534a\u89d2\u6570\u5b57\u4ee5\u5916 = "[^0-9]";
    public static char[] ESCAPE_SEQENCE_CHARS = new char[]{'\\', '*', '+', '.', '?', '{', '}', '(', ')', '[', ']', '^', '$', BcUnicode.hyphen.char_, '|'};

    private BcRegexUtil() {
    }

    public static boolean isEscapeSequenceChar(char aChar) {
        int i = 0;
        while (i < ESCAPE_SEQENCE_CHARS.length) {
            if (aChar == ESCAPE_SEQENCE_CHARS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String escapEncode(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length() + 32);
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            if (BcRegexUtil.isEscapeSequenceChar(aChar)) {
                sb.append('\\');
            }
            sb.append(aChar);
            ++i;
        }
        return sb.toString();
    }

    public static String toRejex(String ... elements) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            String encode;
            if (sb.length() > 0) {
                sb.append('|');
            }
            if (!BcStringUtil.isEmpty(encode = BcRegexUtil.escapEncode(elements[i]))) {
                sb.append(encode);
            }
            ++i;
        }
        return sb.toString();
    }
}

