/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javax.swing.JScrollPane;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.rmi.client.RmiLocalAgent;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf3.client.ScfSqlClientEventHandler;
import jp.co.extreme.scf3.client.ScfSqlClientTask;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.scf4.client.ScfOnlineTableModelClient;
import jp.co.extreme.scf4.client.ScfSqlClientOnlineTask;
import jp.co.extreme.scf4.client.ScfStandAloneHelper;
import jp.co.extreme.scf4.swg.HswgTableDisplayUtil;
import jp.co.extreme.scf4.table.ScfColumnContext;
import jp.co.extreme.scf4.table.ScfDisplayContext;
import jp.co.extreme.scf5.swg.IswgTableControlPanel3;
import jp.co.extreme.scf5.swg.IswgTablePanel;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.swing.SwgTextArea;
import jp.co.extreme.swing.SwgUtil;
import jp.co.extreme.task.Z_TskTaskScheduler;

public class IswgLoadableTablePanel
extends IswgTablePanel
implements ScfSqlClientEventHandler {
    private static final long serialVersionUID = 3882513288409357969L;
    private ScfSqlClientTask sqlClientTask;
    private boolean isLocal;
    private boolean isOnLine;
    protected boolean visualSaveEnavled = false;
    protected int preFromIndex = -1;
    protected int preToIndex = -1;
    protected FxLabel searchingLabel;
    protected FxButton cancelButton;
    private RmiRequest rmiReqOnShown;
    protected EventHandler<ActionEvent> fxActionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent ev) {
            try {
                IswgLoadableTablePanel.this.searchingLabel.setText(BcWords.getInstance().canceling);
                IswgLoadableTablePanel.this.cancelButton.setDisable(true);
                IswgLoadableTablePanel.this.sqlClientTask.cancel(this);
            }
            catch (Exception ex) {
                IswgLoadableTablePanel.this.handleException(ex);
            }
        }
    };

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnline(boolean isOnLine) {
        this.isOnLine = isOnLine;
    }

    public void doLoad(RmiRequest rmiReq) throws Exception {
        this.getTableLoadTask().init();
        this.sqlClientTask.setRequest(rmiReq);
        this.tableControlPanel.setOriginalRequest(BcCloneUtil.createClone(rmiReq));
        Future future = Z_TskTaskScheduler.getInstance().startTask(this.sqlClientTask);
        BcLogUtil.debug("future=" + future);
    }

    public void doLoad2(RmiRespons rmiRes) throws Exception {
        this.getTableLoadTask().init();
        this.sqlClientTask.setRespons1(rmiRes);
        Z_TskTaskScheduler.getInstance().startTask(this.sqlClientTask);
    }

    public void doLoad(String datasourceName, Object query) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, query);
        this.doLoad(rmiReq);
    }

    protected ScfSqlClientTask getTableLoadTask() throws Exception {
        if (this.sqlClientTask == null) {
            this.sqlClientTask = this.createTableLoadTask();
        }
        return this.sqlClientTask;
    }

    protected ScfSqlClientTask createTableLoadTask() throws Exception {
        RmiLocalAgent localAgent = ScfStandAloneHelper.getInstance().getLocalAgent(ScfClientContainer.getInstance().getAgent(), this.isLocal());
        ScfSqlClientTask sqlClientTask = null;
        sqlClientTask = this.isOnLine() ? new ScfSqlClientOnlineTask() : new ScfSqlClientTask();
        sqlClientTask.setLocalAgent(localAgent);
        sqlClientTask.getEventListenerList().add(ScfSqlClientEventHandler.class, this);
        sqlClientTask.getEventListenerList().add(ScfSqlClientEventHandler.class, this.tableControlPanel);
        return sqlClientTask;
    }

    protected BcTableModel createTableModel() throws Exception {
        BcTableModel tableModel = null;
        if (this.sqlClientTask instanceof ScfSqlClientOnlineTask) {
            ScfOnlineTableModelClient onlineTableModelClient = new ScfOnlineTableModelClient();
            onlineTableModelClient.setLocalAgent(this.getTableLoadTask().getLocalAgent());
            tableModel = onlineTableModelClient;
        } else {
            tableModel = new BcTableModel();
        }
        return tableModel;
    }

    @Override
    protected void tableMouseReleased(MouseEvent ev) throws Exception {
        super.tableMouseReleased(ev);
        if (ev.getSource() instanceof JTableHeader && this.preToIndex >= 0) {
            this.columnChanged();
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent ev) {
        super.columnMoved(ev);
        try {
            if (this.preFromIndex >= 0 && this.preFromIndex != ev.getFromIndex() && ev.getFromIndex() == ev.getToIndex()) {
                this.columnChanged();
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        this.preFromIndex = ev.getFromIndex();
        this.preToIndex = ev.getToIndex();
    }

    @Override
    protected void setPogressIndicator_L3(Pane pane) throws Exception {
        super.setPogressIndicator_L3(pane);
        this.searchingLabel = new FxLabel(BcWords.getInstance().searching);
        FxUtil.setFont((Node)this.searchingLabel, FxFontUtil.font_12_black);
        pane.getChildren().addAll((Object[])new Node[]{this.searchingLabel});
        this.cancelButton = new FxButton(BcWords.getInstance().cancel);
        this.cancelButton.setGraphic((Node)FxImageHelper.createImageView_icon("sign_forbidden_64x64.png"));
        this.cancelButton.setOnAction(this.fxActionEventHandler);
        pane.getChildren().addAll((Object[])new Node[]{this.cancelButton});
    }

    public boolean isVisualSaveEnavled() throws Exception {
        return this.visualSaveEnavled;
    }

    public void setVisualSaveEnavled(boolean visualSaveEnavled) throws Exception {
        this.visualSaveEnavled = visualSaveEnavled;
        this.tableControlPanel.setDisplaySettingButton(visualSaveEnavled);
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            if (this.sqlClientTask != null) {
                this.sqlClientTask.cancel(this);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void started(ScfSqlClientTask sqlClientTask) throws Exception {
        this.setPogressIndicator();
    }

    @Override
    public void tableColumnReceived(ScfSqlClientTask sqlClientTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        BcTableModel tableModel = this.createTableModel();
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        BcTableUtil.addTableColumn(tableColumnModel, tableColumnList);
        SwgTableViewUtil.setEditable(tableColumnModel, false);
        this.setTableModel(tableModel);
        SwgTableView tableView = this.createTableView();
        this.setTableView(tableView);
        this.setTableContext(tableContext);
        if (sqlClientTask instanceof ScfSqlClientOnlineTask) {
            ScfSqlClientOnlineTask tableLoadOnlineTask = (ScfSqlClientOnlineTask)sqlClientTask;
            ScfOnlineTableModelClient onlineTableModelClient = (ScfOnlineTableModelClient)tableModel;
            onlineTableModelClient.setHandleId(sqlClientTask.getHandleId());
            onlineTableModelClient.setRowCount(rowCount);
            tableLoadOnlineTask.setOnlineTableModelClient(onlineTableModelClient);
        }
        if (this.visualSaveEnavled) {
            this.columnSetting();
        }
    }

    @Override
    public void rowListReceived(ScfSqlClientTask sqlClientTask, List<List> rowList) throws Exception {
        if (sqlClientTask instanceof ScfSqlClientOnlineTask) {
            ScfSqlClientOnlineTask tableLoadOnlineTask = (ScfSqlClientOnlineTask)sqlClientTask;
            BcTableModel tableModel = this.getTableModel();
            ScfOnlineTableModelClient onlineTableModel = (ScfOnlineTableModelClient)tableModel;
            onlineTableModel.setLows(tableLoadOnlineTask.getRowNumberList(), rowList);
        } else {
            BcTableModel tableModel = this.getTableModel();
            tableModel.addRowList(rowList);
        }
    }

    @Override
    public void loaded(ScfSqlClientTask sqlClientTask, boolean eod) throws Exception {
    }

    @Override
    public void loadedRowCountChanged(ScfSqlClientTask sqlClientTask, int rowCount, int loadedRowCount) throws Exception {
    }

    @Override
    public void resultReceived(ScfSqlClientTask sqlClientTask, Object generalResult) throws Exception {
        Component messageComponent = SwgUtil.createMessageComponent(BcWords.getInstance().information, generalResult);
        this.setMainContent(messageComponent);
    }

    @Override
    public void cancelStarted(ScfSqlClientTask sqlClientTask, Object source) throws Exception {
    }

    @Override
    public void canceled(ScfSqlClientTask sqlClientTask) throws Exception {
        SwgTextArea txetArea = new SwgTextArea();
        txetArea.setEditable(false);
        txetArea.setForeground(Color.RED);
        txetArea.setText("Statement was canceled.");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(txetArea);
        this.setMainContent(scrollPane);
    }

    @Override
    public void errorOccurred(ScfSqlClientTask sqlClientTask, Throwable throwable) {
        BcLogUtil.error(throwable);
        Component messageComponent = SwgUtil.createMessageComponent(BcWords.getInstance().error, throwable);
        this.setMainContent(messageComponent);
    }

    @Override
    public IswgTableControlPanel3 createControlPanel() throws Exception {
        IswgTableControlPanel3 tableControlPanel = super.createControlPanel();
        tableControlPanel.setRefreshButton();
        tableControlPanel.setCancelButton();
        return tableControlPanel;
    }

    public RmiRequest getRequestOnShown() throws Exception {
        return this.rmiReqOnShown;
    }

    public void setRequestOnShown(RmiRequest rmiReq) throws Exception {
        this.rmiReqOnShown = rmiReq;
    }

    public void setRequestOnShown(String datasourceName, Object query) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, query);
        this.setRequestOnShown(rmiReq);
    }

    @Override
    protected void componentShownFirst(ComponentEvent ev) throws Exception {
        super.componentShownFirst(ev);
        if (this.rmiReqOnShown != null) {
            this.doLoad(this.rmiReqOnShown);
        }
    }

    public void columnSetting() throws Exception {
        if (BcStringUtil.isEmpty(this.getTableContext().title)) {
            return;
        }
        try {
            BcTableColumnModel tableColumnModel = this.getTableModel().getTableColumnModel();
            List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.createColumnContextList(tableColumnModel);
            this.tableControlPanel.displayContextOrigin = new ScfDisplayContext();
            this.tableControlPanel.displayContextOrigin.columnContextMap = HswgTableDisplayUtil.toMap(columnContextList);
            File xmlFile = HswgTableDisplayUtil.findXmlFile(this.getTableContext().title);
            if (xmlFile.exists()) {
                ScfDisplayContext displayContext2 = HswgTableDisplayUtil.parseXml(xmlFile);
                HswgTableDisplayUtil.applyDisplayContext(this.getTableView(), displayContext2);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            String msg = "\u5217\u9806\u4f4d\u8a2d\u5b9a\u306b\u304a\u3044\u3066\u4f8b\u5916" + ex.getMessage();
            SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
        }
    }

    public void columnChanged() throws Exception {
        if (this.visualSaveEnavled && !BcStringUtil.isEmpty(this.getTableContext().title)) {
            List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.createColumnContextList(this.getTableModel().getTableColumnModel());
            ScfDisplayContext displayContextNew = new ScfDisplayContext();
            displayContextNew.columnContextMap = HswgTableDisplayUtil.toMap(columnContextList);
            HswgTableDisplayUtil.save(this.getTableContext().title, displayContextNew, this.tableControlPanel.displayContextOrigin);
        }
    }
}

