/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.List;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.dao.XdtsProfileDAO;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.module.xdts.server.XdtsTempProc;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.datasource.ScfDatasourceConfigParser;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf3.server.ScfSqlServerTask;
import jp.co.extreme.scf5.dao.ScfSchemaVersionDAO;
import jp.co.extreme.scf5.model.ScfSchemaVersion;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;

public class XdtsProfileRMO
extends RmiAbstractRMO {
    public void putProfile(RmiRmoArgument rmoArg) throws Exception {
        XdtsProfile profile1 = (XdtsProfile)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        BcResult result = new BcResult();
        if (!BcStringUtil.isEmpty(profile1.name)) {
            XdtsProfile profile2 = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSession, profile1.name);
            if (profile2 != null && profile1.getDataId() != profile2.getDataId()) {
                String msg = String.format(XdtsWords.getInstance().\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d_$_\u306f\u767b\u9332\u6e08\u3067\u3059, profile1.name);
                result.addError(msg);
            }
            if (!result.hasError()) {
                XdtsProfileDAO.getInstance().putEntity(dtsSession, profile1);
            }
            result.setUserObject(profile1);
        } else {
            String msg = String.format(XdtsWords.getInstance().\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093, new Object[0]);
            result.addError(msg);
            result.setUserObject(profile1);
        }
        rmoArg.getRespons().addData(result);
    }

    public void deleteProfile(RmiRmoArgument rmoArg) throws Exception {
        long dataSourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, dataSourceId, true);
        int cnt = XdtsProfileDAO.getInstance().deleteEntity(dtsSession, profile);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileById(RmiRmoArgument rmoArg) throws Exception {
        long dataSourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, dataSourceId, true);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileByName(RmiRmoArgument rmoArg) throws Exception {
        String dataSourceName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSession, dataSourceName);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List profileList = XdtsProfileDAO.getInstance().getList(dtsSession, XdtsProfileDAO.Mode.group, null, null);
        rmoArg.getRespons().addData(profileList);
    }

    public void connectByProfileId(RmiRmoArgument rmoArg) throws Exception {
        long dataSourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, dataSourceId, true);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, dataSourceId, true);
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactoryWk1, AfbApplication.getInstance().getLogDir());
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        profile.productId = dtsSessionWk1.getSqlContext().getDatabaseProduct().id;
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactoryWk1.wordManager;
        XdtsTempProc xdtsTempProc = new XdtsTempProc();
        profile.connectionTimestamp = BcTimeUtil.createCalendar();
        profile.connectionCount = BcNumberUtil.addMax(profile.connectionCount, 1);
        this.getLogger().debug("### profile.productId=" + profile.productId);
        XdtsProfileDAO.getInstance().putEntity(dtsSession, profile);
        rmoArg.getRespons().addData(profile);
    }

    public void disconnect(RmiRmoArgument rmoArg) throws Exception {
        Long dataSourceId = rmoArg.getRequest().getDataAsLong();
        XdtsSessionFactoryManager.getInstance().disconnect(dataSourceId);
    }

    public void getSchemaVersion(RmiRmoArgument rmoArg) throws Exception {
        XdtsProfile profile = (XdtsProfile)rmoArg.getRequest().getData();
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().createSessionFactory(profile);
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        ScfSchemaVersion schemaVersion = null;
        if (ScfSchemaVersionDAO.getInstance().existTable(dtsSessionWk1)) {
            schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSessionWk1);
        }
        rmoArg.getRespons().addData(schemaVersion);
    }

    public void profileList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.createDtsSession();
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = XdtsProfileDAO.getInstance().createSelectQuery(sqlContext, XdtsProfileDAO.Mode.group, null, null, null);
        selectQuery.getSelectColumnList().add(XdtsConstants.xdts_profile.id.tableColumnName());
        selectQuery.getSelectColumnList().add(XdtsConstants.xdts_profile.group_.tableColumnName());
        selectQuery.getSelectColumnList().add(XdtsConstants.xdts_profile.name.tableColumnName());
        selectQuery.getSelectColumnList().add("xdts_profile.url_");
        selectQuery.getSelectColumnList().add("xdts_profile.user_");
        selectQuery.getSelectColumnList().add("xdts_profile.driver");
        selectQuery.getSelectColumnList().add("xdts_profile.parameters_");
        selectQuery.getSelectColumnList().add(XdtsConstants.xdts_profile.product_id.tableColumnName());
        selectQuery.getSelectColumnList().add("xdts_profile.note_");
        selectQuery.getSelectColumnList().add("xdts_profile.connection_count");
        String query = sqlContext.buildSelectQuery(selectQuery);
        ScfSqlServerTask queryServerTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        queryServerTask.query = query;
        queryServerTask.rowLimit = XdtsConstants.LIMIT_recordCount;
        ScfSqlUtil.generalListNew(queryServerTask, (Object)this);
    }

    public static enum Method implements RmiRemoteMethod
    {
        putProfile,
        deleteProfile,
        getProfileById,
        getProfileByName,
        getProfileList,
        profileList,
        connectByProfileId,
        disconnect,
        getSchemaVersion;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

