/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcReflectUtil;

public final class BcCollectionUtil {
    private BcCollectionUtil() {
    }

    public static int getSize(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static int getSize(Map<?, ?> map) {
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public static boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static boolean isEmpty(Object array) throws Exception {
        if (array == null) {
            return true;
        }
        if (array.getClass().isArray()) {
            int arrayLength = Array.getLength(array);
            return arrayLength == 0;
        }
        String msg = "\u5f15\u6570\u304c\u914d\u5217\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002array=" + array;
        throw new Exception(msg);
    }

    public static <T> T getElement(List<T> list, int index) {
        T value = null;
        if (list.size() > index) {
            value = list.get(index);
        }
        return value;
    }

    public static <T> T getElement(Object array, int index) throws Exception {
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Class '" + clazz.getName() + "' is not array.");
        }
        int length = Array.getLength(array);
        Object value = null;
        if (Array.getLength(array) > index) {
            value = Array.get(array, index);
        }
        return (T)value;
    }

    public static <T> T getFirst(List<T> list) {
        return BcCollectionUtil.getElement(list, 0);
    }

    public static <T> T getLast(List<T> list) {
        T value = null;
        if (list.size() > 0) {
            value = list.get(list.size() - 1);
        }
        return value;
    }

    public static void fill(List list, int newSize, Object value) {
        if (list.size() < newSize) {
            int diff = newSize - list.size();
            int i = 0;
            while (i < diff) {
                list.add(value);
                ++i;
            }
        } else if (list.size() > newSize) {
            BcCollectionUtil.setHeadSize(list, newSize);
        }
    }

    public static void fill(List list, int newSize) {
        BcCollectionUtil.fill(list, newSize, null);
    }

    public static int setHeadSize(List<?> list, int size) {
        int diff = list.size() - size;
        if (diff > 0) {
            int i = 0;
            while (i < diff) {
                list.remove(list.size() - 1);
                ++i;
            }
        }
        return diff;
    }

    public static int setTailSize(List<?> list, int size) {
        int diff = list.size() - size;
        if (diff > 0) {
            int i = 0;
            while (i < diff) {
                list.remove(0);
                ++i;
            }
        }
        return diff;
    }

    public static Object setElement(List list, int index, Object element) {
        if (list.size() <= index) {
            BcCollectionUtil.fill(list, index + 1);
        }
        return list.set(index, element);
    }

    public static int getArrayIndex(Object value, Object ... objects) {
        int index = -1;
        if (objects == null) {
            return index;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i].equals(value)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static void reverse(List<?> list1, List list2) {
        int i = 0;
        while (i < list1.size()) {
            Object object = list1.get(list1.size() - 1 - i);
            list2.add(object);
            ++i;
        }
    }

    public static void addElementUnique(Collection collection, Object element) throws Exception {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    public static <T> void toList(Object array, List<T> list) {
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Class '" + clazz.getName() + "' is not array.");
        }
        int length = Array.getLength(array);
        int i = 0;
        while (i < length) {
            Object element = Array.get(array, i);
            list.add(element);
            ++i;
        }
    }

    public static List<Object> toList(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        BcCollectionUtil.toList(array, list);
        return list;
    }

    public static <T> List<T> asList(T ... array) {
        ArrayList list = new ArrayList();
        BcCollectionUtil.toList(array, list);
        return list;
    }

    public static <T> List<T> toListNotNull(T ... array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        int i = 0;
        while (i < length) {
            Object element = Array.get(array, i);
            if (element != null) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    public static int[] marge(int[] array1, int[] array2) {
        int[] resArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, resArray, 0, array1.length);
        System.arraycopy(array2, 0, resArray, array1.length, array2.length);
        return resArray;
    }

    public static byte[] marge(byte[] array1, byte[] array2) {
        byte[] resArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, resArray, 0, array1.length);
        System.arraycopy(array2, 0, resArray, array1.length, array2.length);
        return resArray;
    }

    public static String[] marge(String[] array1, String[] array2) {
        String[] resArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, resArray, 0, array1.length);
        System.arraycopy(array2, 0, resArray, array1.length, array2.length);
        return resArray;
    }

    public static void copy(Collection collection1, Collection collection2, boolean cloneable) throws Exception {
        Iterator iterator = collection1.iterator();
        while (iterator.hasNext()) {
            Object obj1;
            Object obj2 = obj1 = iterator.next();
            if (obj1 != null && cloneable && Cloneable.class.isAssignableFrom(obj1.getClass())) {
                obj2 = BcReflectUtil.invokeCloneMethod(obj1);
            }
            collection2.add(obj2);
        }
    }

    public static void copy(Map map1, Map map2, boolean doClone) throws Exception {
        for (Map.Entry mapEntry : map1.entrySet()) {
            Object key1 = mapEntry.getKey();
            Object value1 = mapEntry.getValue();
            Object key2 = key1;
            Object value2 = value1;
            if (key1 != null && doClone && Cloneable.class.isAssignableFrom(key1.getClass())) {
                key2 = BcReflectUtil.invokeCloneMethod(key1);
            }
            if (value1 != null && doClone && Cloneable.class.isAssignableFrom(value1.getClass())) {
                value2 = BcReflectUtil.invokeCloneMethod(value1);
            }
            map2.put(key2, value2);
        }
    }

    public static <T> List<T> toUniqueList(List<T> srcList) throws Exception {
        List newList = (List)srcList.getClass().newInstance();
        int i = 0;
        while (i < srcList.size()) {
            T obj = srcList.get(i);
            if (newList.indexOf(obj) < 0) {
                newList.add(obj);
            }
            ++i;
        }
        return newList;
    }

    public static List<Integer> toUniqueList(int ... array) throws Exception {
        List<Integer> newList = BcNumberUtil.toList(array);
        return BcCollectionUtil.toUniqueList(newList);
    }

    public static int[] toUniqueArray(int ... array) throws Exception {
        List<Integer> newList = BcCollectionUtil.toUniqueList(array);
        return BcNumberUtil.toIntArray(newList);
    }

    public static <T> List toNotEmptyList(List<T> srcList) throws Exception {
        List newList = (List)srcList.getClass().newInstance();
        int i = 0;
        while (i < srcList.size()) {
            T obj = srcList.get(i);
            if (!BcStringUtil.isEmpty(obj)) {
                newList.add(obj);
            }
            ++i;
        }
        return newList;
    }

    public static void removeByKeyCollection(Map map, Collection keyCollection) {
        for (Object key : keyCollection) {
            map.remove(key);
        }
    }

    public static List<Object> removeNotExistsKey(Map targetMap, Map keyMap) {
        ArrayList<Object> removeKeyList = new ArrayList<Object>();
        Iterator iterator = targetMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            if (keyMap.containsKey(mapEntry.getKey())) continue;
            iterator.remove();
            removeKeyList.add(mapEntry.getKey());
        }
        return removeKeyList;
    }

    public static List<Object> removeByValue(Map<?, ?> map, Object value) {
        ArrayList<Object> removeKeyList = new ArrayList<Object>();
        for (Map.Entry mapEntry : map.keySet()) {
            Object key = mapEntry.getKey();
            if (mapEntry.getValue() == null || !mapEntry.getValue().equals(value)) continue;
            map.remove(key);
            removeKeyList.add(key);
        }
        return removeKeyList;
    }

    public static Object[] toTopAndLast(List<?> list) {
        Object[] obj = new Object[2];
        if (list == null || list.size() == 0) {
            return obj;
        }
        obj[0] = list.get(0);
        obj[1] = list.get(list.size() - 1);
        return obj;
    }

    public static <T> List<T> toDifferentList(Collection<T> collection1, Collection<T> collection2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : collection1) {
            if (collection2.contains(element)) continue;
            list.add(element);
        }
        for (T element : collection2) {
            if (collection1.contains(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static String toString(Map<?, ?> map) throws Exception {
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> mapEntry : map.entrySet()) {
            if (++cnt > 1) {
                sb.append("\n");
            }
            sb.append("key=" + mapEntry.getKey());
            sb.append(" ");
            sb.append("value=" + mapEntry.getValue());
        }
        return sb.toString();
    }
}

