/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.assembler.wbs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcDifference;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.zip.BcZipUtil;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpCsvComparator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.task.TskAbstractCallable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class TbcpCsvComparatorTask
extends TskAbstractCallable {
    public Future future;
    public int statusId;
    public String message;
    public File file1;
    public File file2;
    public List<File> destFileList;
    public WbxTokenContext tokenContext;
    public TbcpCondition condition;
    public double percent;

    TbcpCsvComparatorTask() {
        this.statusId = WbxConstants.ProgressStatus.OK.id;
        this.destFileList = new ArrayList<File>();
        this.percent = 20.0;
    }

    public Object taskProcess() throws Exception {
        InnerLogger logger = new InnerLogger();
        logger.task = this;
        InnerCsvComparator csvComparator = new InnerCsvComparator();
        csvComparator.setLogger(logger);
        csvComparator.condition = this.condition;
        BcResult result = csvComparator.compare(this.file1, this.file2);
        if (result.hasError()) {
            this.statusId = WbxConstants.ProgressStatus.NG.id;
            this.message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            return null;
        }
        this.getLogger().debug("destFileList.size()=" + this.destFileList.size());
        String zipFileName = BcFileUtil.createFileName("csv_comparison_result", "zip");
        File zipFile = BcFileUtil.add_yyyyMMdd_HHmmssSSS(zipFileName, this.file1.getParentFile());
        this.getLogger().debug("zipFile=" + zipFile.getPath());
        BcFileUtil.deleteIfExists(zipFile);
        BcZipUtil.compression(zipFile, this.destFileList);
        this.tokenContext.map.put(File.class.getName(), zipFile);
        return null;
    }

    @Override
    protected void handleException(Throwable throwable) {
        super.handleException(throwable);
        this.statusId = WbxConstants.ProgressStatus.NG.id;
        this.message = throwable.getMessage();
    }

    class InnerCsvComparator
    extends TbcpCsvComparator {
        int step;

        InnerCsvComparator() {
        }

        @Override
        protected BcTableModel csvToTable(File file) throws Exception {
            ++this.step;
            TbcpCsvComparatorTask.this.percent = (double)this.step / 5.0 * 80.0 + 20.0;
            return super.csvToTable(file);
        }

        @Override
        protected Map<String, BcDifference> createDiffMap(BcTableModel tableModel1, BcTableModel tableModel2) throws Exception {
            ++this.step;
            TbcpCsvComparatorTask.this.percent = (double)this.step / 5.0 * 80.0 + 20.0;
            Map<String, BcDifference> diffMap = super.createDiffMap(tableModel1, tableModel2);
            return diffMap;
        }

        @Override
        protected void writeWorkbook(XSSFWorkbook workbook, File destFile) throws Exception {
            ++this.step;
            TbcpCsvComparatorTask.this.percent = (double)this.step / 5.0 * 80.0 + 20.0;
            super.writeWorkbook(workbook, destFile);
            TbcpCsvComparatorTask.this.destFileList.add(destFile);
        }

        @Override
        protected String creatDestFilePath(File baseFile) throws Exception {
            File destFile = BcFileUtil.replaceExtention(baseFile, PoiConstants.Extention.xlsx.name());
            return destFile.getPath();
        }
    }

    class InnerLogger
    implements BcLogger {
        TbcpCsvComparatorTask task;

        InnerLogger() {
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public BcLogConstants.LogLevel getLogLevel() {
            return BcLogConstants.LogLevel.INFO;
        }

        @Override
        public void fatal(Object log) {
            this.log(log);
        }

        @Override
        public void error(Object log) {
            this.log(log);
        }

        @Override
        public void warning(Object log) {
            this.log(log);
        }

        @Override
        public void info(Object log) {
            this.log(log);
        }

        @Override
        public void debug(Object log) {
            this.log(log);
        }

        @Override
        public void trace(Object log) {
            this.log(log);
        }

        protected void log(Object log) {
            BcLogUtil.debug(log);
            this.task.message = BcLogUtil.convertMessage(log);
        }
    }
}

