/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.sql.SqlConstants;

public class XdtsImageHelper {
    static Map<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();

    private XdtsImageHelper() {
    }

    public static BufferedImage getImage(int productId) throws Exception {
        BufferedImage image;
        FileName fileName = FileName.getById(productId);
        if (fileName == null) {
            fileName = FileName.Default;
        }
        if ((image = imageMap.get(fileName.fileName)) == null) {
            image = AwtImageUtil.loadImage(XdtsImageHelper.class.getResourceAsStream("images/" + fileName.fileName), BcFileUtil.getExtention(fileName.fileName));
            imageMap.put(fileName.fileName, image);
        }
        return image;
    }

    public static enum FileName {
        H2(SqlConstants.DatabaseProduct.H2.id, "H2_250x137.png"),
        PostgreSQL(SqlConstants.DatabaseProduct.PostgreSQL.id, "PostgreSQL_64x64.png"),
        MySQL(SqlConstants.DatabaseProduct.MySQL.id, "MySQL_360x360.png"),
        Oracle(SqlConstants.DatabaseProduct.Oracle.id, "Oracle_256x256.png"),
        SQLServer(SqlConstants.DatabaseProduct.SQLServer.id, "Microsoft_SQL_Server_330x268.png"),
        Access(SqlConstants.DatabaseProduct.Access.id, "Microsoft_Access_330x313.png"),
        DB2(SqlConstants.DatabaseProduct.DB2.id, "IBM_DB2_300x300x.png"),
        Default(-1, "db_table_64x64.png");

        public final int productId;
        public final String fileName;

        private FileName(int productId, String fileName) {
            this.productId = productId;
            this.fileName = fileName;
        }

        public static FileName getById(int productId) {
            FileName[] fileNameArray = FileName.values();
            int n = fileNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileName fileName = fileNameArray[n2];
                if (fileName.productId == productId) {
                    return fileName;
                }
                ++n2;
            }
            return null;
        }
    }
}

