/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.component.WhcBuilder;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.httpserver.HtsvArgument;
import jp.co.extreme.httpserver.HtsvRequestParameter;
import jp.co.extreme.httpserver.HtsvUrlParameterMap;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.cmsv.dao.CmsvMessageDAO;
import jp.co.extreme.module.cmsv.model.CmsvMessage;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsMessageCondition;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1LinkUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1MessageWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1RecruitmentListWCB;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.wcb.XdsDataViewUtil;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebMessageConstants;
import jp.co.extreme.module.xweb.common.XwebPaginationBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;

public class Wbs1MessageListWCB
extends Wbs1AbstractWCB {
    Wbs1MessageWCB messageWCB = new Wbs1MessageWCB();

    @Override
    protected String createHeadStyle(HtsvArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, super.createHeadStyle(wcbArg));
        return sb.toString();
    }

    public void form(HtsvArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(HtsvArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        HtsvRequestParameter requestParameter = wcbArg.getRequestParameter();
        HtsvUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        WbsJudgementCondition judgementCondition = null;
        WbsMessageCondition messageCondition = null;
        XwebMessageConstants.MessageContext messageContext = null;
        WbsTempCondition tempCondition = null;
        if (tokenContext.validationResult == null) {
            tokenContext.validationResult = new XsysValidationResult();
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            XwebUtil.putToMap(tokenContext.map, urlParam);
            judgementCondition = new WbsJudgementCondition();
            XwebUtil.putToMap(tokenContext.map, judgementCondition);
            messageCondition = new WbsMessageCondition();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, messageCondition);
            XwebUtil.putToMap(tokenContext.map, messageCondition);
            messageContext = XwebMessageConstants.ceateMessageContext(messageCondition.messageCategory);
            XwebUtil.putToMap(tokenContext.map, messageContext);
            tempCondition = new WbsTempCondition();
            XwebUtil.putToMap(tokenContext.map, tempCondition);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            judgementCondition = (WbsJudgementCondition)XwebUtil.getMapValue(tokenContext.map, WbsJudgementCondition.class);
            messageCondition = (WbsMessageCondition)XwebUtil.getMapValue(tokenContext.map, WbsMessageCondition.class);
            messageContext = (XwebMessageConstants.MessageContext)XwebUtil.getMapValue(tokenContext.map, XwebMessageConstants.MessageContext.class);
            tempCondition = (WbsTempCondition)XwebUtil.getMapValue(tokenContext.map, WbsTempCondition.class);
        }
        EtcPagination pagination = XwebUtil.cretaePagination(wcbArg);
        if (pagination.getPageNumReq() <= 0) {
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, tempCondition);
        }
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgementCondition);
        StringBuilder sb = new StringBuilder();
        int contentColumn = 10;
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(contentColumn));
        String title = messageContext.title;
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            title = String.valueOf(title) + ":" + urlParam.mode;
        }
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(3, title, "headline1"));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createConditionForm(wcbArg, tokenContext, dtsSessionSite, Method.form.path, urlParam, judgementCondition, tempCondition));
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createDetailList(wcbArg, dtsSessionSite, tokenContext, urlParam, pagination, messageContext, messageCondition, judgementCondition));
        sb.append(this.getHtmlBuilder().div_end());
        MdlCreator mdlCreator = MdlCreator.getInstance();
        MdlCreator.getInstance();
        sb.append((CharSequence)mdlCreator.div_grid_cell_start(12 - contentColumn));
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1RecruitmentListWCB.Method.form);
        StringBuilder sb2 = Wbs1LinkUtil.getInstance().createLink(wcbArg, dtsSessionSite);
        sb.append((CharSequence)sb2);
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, messageContext.title, messageContext.description, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    protected StringBuilder createConditionForm(HtsvArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, String url, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = this.createConditionForm_L2(wcbArg, urlParam, judgementCondition);
        String formName = "form1";
        StringBuilder controls = new StringBuilder();
        String onclickAction = WbfJslUtil.submit2(formName, url);
        String searchButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().search, onclickAction);
        controls.append(searchButton);
        sb.append((CharSequence)this.getHtmlBuilder().div(controls.toString(), HtmlConstants.HtmlAlign.center, -1));
        sb.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        sb = HtmlUtil2.form(formName, sb.toString());
        return sb;
    }

    protected StringBuilder createConditionForm_L2(HtsvArgument wcbArg, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            sb.append(XwebJudgementUtil.createJudgementCondition(this.getHtmlBuilder(), judgementCondition.judgementStatusId));
        }
        return sb;
    }

    protected StringBuilder createConditionForm_L3(String whcComponentName, List<String> optionList, String defaultValue, String title) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_08rem.className));
        sb.append(this.getHtmlBuilder().p(title, true));
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.controlType = XdtsConstants.ControlType.CheckBox;
        controlContext.options = BcCsvUtil.toCsv(optionList, true);
        controlContext.defaultValue = defaultValue;
        XdtsUserSetting userSetting = null;
        WhcComponent whcComponent = XdsDataViewUtil.createHtmlComponent(controlContext, userSetting, whcComponentName);
        WhcBuilder whcBuilder = new WhcBuilder(this.getHtmlBuilder());
        sb.append(whcBuilder.createComponentHtml(whcComponent, true));
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected StringBuilder createDetailList(HtsvArgument wcbArg, DtsSession dtsSessionSite, WbxTokenContext tokenContext, WbsUrlParam urlParam, EtcPagination pagination, XwebMessageConstants.MessageContext messageContext, WbsMessageCondition messageCondition, WbsJudgementCondition judgementCondition) throws Exception {
        CmsvMessageDAO mailDAO = CmsvMessageDAO.getInstance(messageContext.messageCategory.tableName);
        List mailList1 = null;
        long fromPersonId = BcNumberUtil.parseLong(messageCondition.source, -1);
        long toPersonId = BcNumberUtil.parseLong(messageCondition.destination, -1);
        mailList1 = fromPersonId > 0L ? mailDAO.getList(dtsSessionSite, CmsvMessageDAO.Mode.from, messageCondition, judgementCondition) : (toPersonId > 0L ? mailDAO.getList(dtsSessionSite, CmsvMessageDAO.Mode.to, messageCondition, judgementCondition) : mailDAO.getList(dtsSessionSite, CmsvMessageDAO.Mode.id, messageCondition, judgementCondition));
        XwebUtil.putToMap(tokenContext.map, mailList1);
        pagination.setDataCount(mailList1.size());
        List mailList2 = pagination.newList(mailList1);
        StringBuilder sb = new StringBuilder();
        InnerPaginationBuilder paginationBuilder = new InnerPaginationBuilder();
        paginationBuilder.tokenContext = tokenContext;
        paginationBuilder.messageContext = messageContext;
        sb.append((CharSequence)paginationBuilder.create(wcbArg, pagination));
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        int i = 0;
        while (i < mailList2.size()) {
            CmsvMessage wbsMessage = (CmsvMessage)mailList2.get(i);
            long fromPersonId2 = BcNumberUtil.parseLong(wbsMessage.from, -1);
            long toPersonId2 = BcNumberUtil.parseLong(wbsMessage.to, -1);
            switch (messageContext.messageCategory) {
                // Empty switch
            }
            sb.append(this.messageWCB.createDetail(wcbArg, dtsSessionSite, urlParam, messageContext, wbsMessage, fromPersonId2, toPersonId2, personManager));
            sb.append("\n\n");
            ++i;
        }
        sb.append((CharSequence)this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)paginationBuilder.create(wcbArg, pagination));
        return sb;
    }

    protected StringBuilder editButtonXXXXXXXXXXXXXXXXXXX(HtsvArgument wcbArg, XwebMessageConstants.MessageContext messageContext, CmsvMessage wbs1Mail) throws Exception {
        StringBuilder sb = new StringBuilder();
        Wbs1Account loginAccount = XwebUtil.getLoginAccount(wcbArg, false);
        if (loginAccount != null) {
            String param1 = WbfwUtil.createParameter((Enum)XwebMessageConstants.MessageParam.messageCategoryId, (Number)messageContext.messageCategory.id);
            String param2 = WbfwUtil.createParameter((Enum)XwebMessageConstants.MessageParam.messageId, Long.toString(wbs1Mail.id));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MessageWCB.Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            String onclickAction = WbfJslUtil.locationHref(href);
            String button = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
            sb.append(this.getHtmlBuilder().div_start());
            sb.append(button);
            sb.append(this.getHtmlBuilder().div_end());
        }
        return sb;
    }

    class InnerPaginationBuilder
    extends XwebPaginationBuilder {
        WbxTokenContext tokenContext;
        XwebMessageConstants.MessageContext messageContext;

        InnerPaginationBuilder() {
        }

        @Override
        protected String createHref(HtsvArgument wcbArg, int pageNo) throws Exception {
            String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(this.tokenContext));
            String param2 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.page.name(), (Number)pageNo);
            String param3 = WbfwUtil.createParameter(XwebMessageConstants.MessageParam.messageCategoryId.name(), (Number)this.messageContext.messageCategory.id);
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1, param2, param3);
            return href;
        }
    }

    public static enum Method implements WbxPath
    {
        form("mail-list");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1MessageListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

