/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpWords;

class TbcpConditionPane
extends FxBorderPane {
    HBox vBox = new HBox();
    FxTitledPane titledPane1 = new FxTitledPane();
    FxCheckBox workbook1CheckBox = new FxCheckBox();
    FxCheckBox workbook2CheckBox = new FxCheckBox();
    FxCheckBox csvCheckBox = new FxCheckBox();
    FxTitledPane titledPane2 = new FxTitledPane();
    FxLabel commentLabel;
    FxCheckBox commentCheckBox;
    FxCheckBox fileOpenCheckBox;

    public TbcpConditionPane() throws Exception {
        this.commentLabel = new FxLabel(TbcpWords.getInstance().comment_the_difference_comparison_target);
        this.commentCheckBox = new FxCheckBox();
        this.fileOpenCheckBox = new FxCheckBox();
        FxFlowPane centerPane1 = new FxFlowPane(11);
        centerPane1.setPrefWidth(400.0);
        centerPane1.setPrefHeight(90.0);
        this.titledPane1.setTitle(BcWords.getInstance().output);
        this.titledPane1.setContentNode((Node)centerPane1);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(TbcpWords.getInstance().excel_workbook) + " for File1"), new Node[]{this.workbook1CheckBox});
        centerPane1.addNodeUnit(nodeUnit);
        this.workbook1CheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TbcpConditionPane.this.workbookChanged();
            }
        });
        nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(TbcpWords.getInstance().excel_workbook) + " for File2"), new Node[]{this.workbook2CheckBox});
        centerPane1.addNodeUnit(nodeUnit);
        this.workbook2CheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TbcpConditionPane.this.workbookChanged();
            }
        });
        nodeUnit = new FxNodeUnit((Node)new FxLabel(TbcpWords.getInstance().csv_file), new Node[]{this.csvCheckBox});
        centerPane1.addNodeUnit(nodeUnit);
        FxFlowPane centerPane2 = new FxFlowPane(11);
        centerPane2.setPrefWidth(centerPane1.getPrefWidth());
        centerPane2.setPrefHeight(centerPane1.getPrefHeight());
        this.titledPane2.setTitle(BcWords.getInstance().options);
        this.titledPane2.setContentNode((Node)centerPane2);
        nodeUnit = new FxNodeUnit((Node)this.commentLabel, new Node[]{this.commentCheckBox});
        centerPane2.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(TbcpWords.getInstance().open_resul_file), new Node[]{this.fileOpenCheckBox});
        centerPane2.addNodeUnit(nodeUnit);
        this.vBox.setSpacing(8.0);
        this.vBox.getChildren().addAll((Object[])new Node[]{this.titledPane1, this.titledPane2});
        this.setCenter((Node)this.vBox);
    }

    public TbcpCondition getCondition() throws Exception {
        TbcpCondition condition = new TbcpCondition();
        condition.workbook1 = this.workbook1CheckBox.isSelected();
        condition.workbook2 = this.workbook2CheckBox.isSelected();
        condition.csv = this.csvCheckBox.isSelected();
        condition.comment = this.commentCheckBox.isSelected();
        condition.fileOpen = this.fileOpenCheckBox.isSelected();
        return condition;
    }

    public void setCondition(TbcpCondition condition) throws Exception {
        this.workbook1CheckBox.setSelected(condition.workbook1);
        this.workbook2CheckBox.setSelected(condition.workbook2);
        this.csvCheckBox.setSelected(condition.csv);
        this.commentCheckBox.setSelected(condition.comment);
        this.fileOpenCheckBox.setSelected(condition.fileOpen);
        this.workbookChanged();
    }

    protected void workbookChanged() {
        boolean isSelected = this.workbook1CheckBox.isSelected() || this.workbook2CheckBox.isSelected();
        this.commentLabel.setDisable(!isSelected);
        this.commentCheckBox.setDisable(!isSelected);
    }
}

