/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.etc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;

public class EtcEventHandlerManager
extends BcLoggableObject {
    private Semaphore semaphore = new Semaphore(1);
    private Map<Class, List<Object>> listMap = new HashMap<Class, List<Object>>();

    public static EtcEventHandlerManager getInstance() {
        return SingletonHolder.instance;
    }

    public List<Object> getEventHandlerList(Class clazz, boolean doCleate) throws Exception {
        this.semaphore.acquire();
        List<Object> list = null;
        try {
            try {
                list = this.listMap.get(clazz);
                if (list == null && doCleate) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.listMap.put(clazz, list);
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                this.semaphore.release();
            }
        }
        finally {
            this.semaphore.release();
        }
        return list;
    }

    public List<Object> getEventHandlerList(Class clazz) throws Exception {
        return this.getEventHandlerList(clazz, true);
    }

    public List<Object> removeEventHandlerList(Class clazz) throws Exception {
        return this.listMap.remove(clazz);
    }

    public boolean addEventHandler(Class clazz, Object eventHandler) throws Exception {
        List<Object> eventHandlerList = this.getEventHandlerList(clazz);
        return eventHandlerList.add(eventHandler);
    }

    public boolean removeEventHandler(Class clazz, Object eventHandler) throws Exception {
        List<Object> eventHandlerList = this.getEventHandlerList(clazz);
        return eventHandlerList.remove(eventHandler);
    }

    private static final class SingletonHolder {
        private static final EtcEventHandlerManager instance = new EtcEventHandlerManager();

        private SingletonHolder() {
        }
    }
}

